// 전화번호 입력
function ds_wg_sms_check_phone(e) {
	var phone_h = /^010([0-9]{8,8}$)|^01([1,6,7,8,9])([0-9]{7,8}$)|^050([0-9]{9,9}$)/g;
	var phone_l = /^070([0-9]{8,8}$)|^(0[3-6][1-5]|02)([0-9]{7,8}$)/g;
	if(phone_l.test(e) || phone_h.test(e)) return true;
	else return false;
}
function ds_wg_sms_form_submit(form) {
	var chk_phone = true;
	var chk_checkbox = true;
	
	if($(form).find('input[name="to_num[]"]').length>0 && $(form).find('input[name="to_num[]"]:checkbox:checked').length<1) {
		chk_checkbox = false;
		alert('전화번호를 선택해주세요. \n\nPlease select phone numbers.');
		$(form).find('input[name="to_num[]"]').focus();
		return false;
	} 
	if($(form).find('textarea[data-type="tel"]').length>0) {
		$(form).find('textarea[data-type="tel"]').each(function(){
			var val = $(this).val().replace(/\n|\r/g,',');
			var val_array = val.split(',');
			var new_array = new Array();
			for (var i=0; i<val_array.length; i++) {
				val_array[i] = val_array[i].replace(/[^0-9]/g,'');
				if(ds_wg_sms_check_phone(val_array[i])) new_array.push(val_array[i]);
			}
			if(new_array.length<1) {
				alert('전화번호를 다시 한번 확인해주세요. \n\nPlease check phone numbers again.');
				$(this).focus().css({'fontWeight':'bold','color':'crimson'});
				chk_phone = false;
				return false;
			} else {
				new_array = new_array.join(',');
				$(this).val(new_array);
			}
		});
	} 
	if(chk_phone==true && chk_checkbox==true) {
		if($(form).find('.ds-wg-sms-ata-ok').length>0) {
			var div = $(form).find('.ds-wg-sms-ata-ok >div');
			div.find('input').each(function(){
				$(this).html($(this).val());
			});
			var val = div.text();
			var textarea = div.closest('.ds-wg-sms-set').find('textarea');
			textarea.val(val);
		}
		return true;
	}
	else return false;
}
function ds_wg_sms_msg_type(e){
	var v = e.value;
	var sms = $(e).closest('form').find('.ds-wg-sms-msg_type-sms');
	var ata = $(e).closest('form').find('.ds-wg-sms-msg_type-ata');
	if(v=='sms') {
		sms.removeClass('ds-display-none').find('*[data-required]').attr('required','true');
		ata.addClass('ds-display-none').find('*[data-required], [required="required"]').removeAttr('required');
		ata.find('textarea').val('');
	}
	if(v=='ata') {
		ata.removeClass('ds-display-none').find('.ds-wg-sms-ata-ok *[data-required]').attr('required','true');
		sms.addClass('ds-display-none').find('*[data-required], [required="required"]').removeAttr('required');
		sms.find('textarea').val('');
		var temid = ata.find('select.ds-wg-sms-temid');
	}
}
function ds_wg_sms_temid(e){
	var v = e.value;
	var ata = $(e).closest('.ds-wg-sms-msg_type-ata');
	var ok_ata = $(e).closest('.ds-wg-sms-msg_type-ata:not(".ds-display-none")');
	var div = ata.find('div.ds-wg-sms-temid');
	var div_ok = ata.find('div[id*='+v+']');
	var ok_div_ok = ok_ata.find('div[id*='+v+']');
	div.removeClass('ds-wg-sms-ata-ok').addClass('ds-display-none').find('input').removeAttr('required');
	div_ok.addClass('ds-wg-sms-ata-ok').removeClass('ds-display-none');
	ok_div_ok.find('input').attr('required','true');
}
jQuery(document).ready(function($){
	$('.ds-wg-sms-form-loading').hide();
	$('.ds-wg-sms').find('*[required]').each(function(){
		$(this).attr('data-required','true');
	});
	$('select.ds-wg-sms-msg_type').each(function(){
		ds_wg_sms_msg_type(this);
		$(this).on('change', function(){
			ds_wg_sms_msg_type(this);
		});
	});
	$('select.ds-wg-sms-temid').each(function(){
		ds_wg_sms_temid(this);
		$(this).on('change', function(){
			ds_wg_sms_temid(this);
		});
	});
});