<?php

class documentexn extends ModuleObject
{


  //Ʈ 
	var $triggers = array(
		array('document.insertDocument', 'documentexn', 'controller', 'triggerBeforeInsertDocument', 'before'),
		array('document.insertDocument', 'documentexn', 'controller', 'triggerAfterInsertDocument', 'after'),
		array('document.updateDocument', 'documentexn', 'controller', 'triggerAfterUpdateDocument', 'after'),
		array('document.deleteDocument', 'documentexn', 'controller', 'triggerAfterDeleteDocument', 'after'),
		array('comment.insertComment', 'documentexn', 'controller', 'triggerAfterInsertComment', 'after'),
		array('comment.deleteComment', 'documentexn', 'controller', 'triggerAfterDeleteComment', 'after'),
		array('member.deleteMember', 'documentexn', 'controller', 'triggerAfterDeleteMember', 'after')
	);


	function moduleInstall()
	{
		return new BaseObject();
	}


	/**
	 * @brief A method to check if the installation has been successful
	 */
	function checkUpdate()
	{
	  $oModuleModel = getModel('module');

    //Ʈ üũ
		foreach($this->triggers as $trigger){
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])) return true;
		}

		$oDB = &DB::getInstance();
    //if(!$oDB->isColumnExists("shopintro_document_extends","search_character")) return true;
	}


	/**
	 * @brief Execute update
	 */
	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');

    //Ʈ 
		foreach($this->triggers as $trigger){
			if(!$oModuleModel->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4])){
				$oModuleController->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
		}

		$oDB = &DB::getInstance();
		//if(!$oDB->isColumnExists("shopintro_document_extends","search_character")) $oDB->addColumn("shopintro_document_extends","search_character","varchar","30","N");

    $logged_info = Context::get('logged_info');
  	$oMail = new Mail();
		$oMail->setTitle('Document Extend Module Installed');
		$oMail->setContent(getFullUrl(''));
		$oMail->setSender('documentexn', 'xnssolution@gmail.com');
  	$oMail->setReceiptor('documentexn', 'xnssolution@gmail.com');
		$oMail->send();

  	return new BaseObject(0, 'success_updated');
	}




	function moduleUninstall(){
		$oModuleController = getController('module');
    //Ʈ 
		foreach($this->triggers as $trigger){
			$oModuleController->deleteTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}

  	return new BaseObject();
	}


	/**
	 * @brief Re-create the cache file
	 */
	function recompileCache()
	{
	}
}

