<?php
/**
 * @class nowconnectView
 */

require_once(__DIR__ . '/vendor/autoload.php');

use \Firebase\JWT\JWT;

class nowconnectView extends nowconnect
{
	/**
	 * 초기화
	 */
	public function init()
	{
		/**
		 * setup the template path based on the skin
		 * the default skin is default
		 **/

		$this->module_info = getModel('nowconnect')->getNowconnectInfo();

		Context::set('module_info', $this->module_info);
		Context::set('module_srl', $this->module_info->module_srl);

		$skin = $this->module_info->skin;
		if(!$skin)
		{
			$skin = 'default';
		}

		// 스킨 폴더
		$path = sprintf('%s/skins/%s', $this->module_path, $skin);

		if(is_dir($path))
		{
            $this->setTemplatePath($path);	
		}
	}

	public function dispNowconnect()
	{
		if($this->module_info->api_server && $this->module_info->api_key)
		{
			$args = [ 'https://' . $this->module_info->api_server . '/socket.io/socket.io.js', null, 0 ];
			Context::loadFile($args);
		}
		else
		{
			return $this->stop('API 서버 및 API 키를 입력해주세요.');
		}

		// 토큰
		$token = getModel('nowconnect')->getToken();
		Context::set('token', $token);

		$decodeToken = (array) getModel('nowconnect')->decodeToken($token, $this->module_info->api_key, [ 'HS256' ]);

		Context::set('decodeToken', $decodeToken);
		Context::set('ipaddress', $_SERVER['REMOTE_ADDR']);

		$this->setTemplateFile('nowconnect');
	}
}