function parseJwt (token) {
	var base64Url = token.split('.')[1];
	var base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
	var jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
		return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
	}).join(''));

	return JSON.parse(jsonPayload);
}

jQuery(function($) {
	$(function() {
		$('.nowconnectXE .iCheck').iCheck({
			checkboxClass: 'icheckbox_minimal-red'
		});

		checkHide();

		$('#chkHide').on('ifChanged', function(event) {
			var isChecked = $(this).is(':checked');

			if(isChecked) {
				$('#chkHide').iCheck('check');
				Cookies.set('ncxeHide', 'Y', { expires : 7 });
			} else {
				Cookies.set('ncxeHide', 'N', { expires : 7 });
				$('#chkHide').iCheck('uncheck');
			}

			checkHide();
		});

		function checkHide(){
			var hide = Cookies.get('ncxeHide');

			switch(hide) {
				case 'Y':
					$('#chkHide').iCheck('check');					
					break;
				default:
					hide = 'N';

			}
		}
	});
});