<?php

require_once(__DIR__ . '/vendor/autoload.php');

use \Firebase\JWT\JWT;

class nowconnectController extends nowconnect
{
	/**
	 * after_module_proc 시점의 트리거
	 *
	 * @return Object
	 */
	public function triggerAfterModuleProc(&$oModule)
	{
		// 관리자 페이지는 수집 대상에서 제외합니다.
		if(Context::get('module') === 'admin')
		{
			return $this->makeObject();
		}

		$config = getModel('nowconnect')->getNowconnectInfo();
		if(!$config->mid)
		{
			return $this->makeObject();
		}

		// API 서버 및 API 키를 입력하지 않았다면 실행 중단
		if(!$config->api_server || !$config->api_key)
		{
			return $this->makeObject();
		}

		// 현재 접속자 페이지가 아니면
		if($config->mid !== $this->module_info->mid)
		{
			// 토큰 값을 가져옴
			$token = getModel('nowconnect')->getToken();

			// API 서버에서 Socket.io.js 불러오기
			$args = [ 'https://' . $config->api_server . '/socket.io/socket.io.js', null, 0 ];
			Context::loadFile($args);

			$rawIpaddress = $_SERVER['REMOTE_ADDR'];

			$skin = $this->module_info->skin;
			if(!$skin)
			{
				$skin = 'default';
			}
	
			// 스킨 폴더
			$path = sprintf('%sskins/%s', $this->module_path, $skin);

			Context::set('config', $config);
			Context::set('token', $token);
			Context::set('rawIpaddress', $rawIpaddress);

			$oTemplate = TemplateHandler::getInstance();
			$js = $oTemplate->compile($path, '_socket.html');

			Context::addHtmlFooter($js);
		}
		return $this->makeObject();
	}
}