<?php
/**
 * @class nowconnectView
 */

require_once(__DIR__ . '/vendor/autoload.php');

use \Firebase\JWT\JWT;

class nowconnectView extends nowconnect
{
	/**
	 * 초기화
	 */
	public function init()
	{
		/**
		 * setup the template path based on the skin
		 * the default skin is default
		 **/

		$this->module_info = getModel('nowconnect')->getNowconnectInfo();

		Context::set('module_info', $this->module_info);
		Context::set('module_srl', $this->module_info->module_srl);

		$skin = $this->module_info->skin;
		if(!$skin)
		{
			$skin = 'default';
		}

		// 스킨 폴더
		$path = $this->module_path . 'skins/' . $skin;

		if(is_dir($path))
		{
			$path = $this->module_path . 'skins/' . $skin;
            $this->setTemplatePath($path);	
		}
	}

	public function dispNowconnect()
	{
		$args = [ 'https://' . $this->module_info->api_server . '/socket.io/socket.io.js', null, 0 ];
		Context::loadFile($args);

		// 토큰
		$token = getModel('nowconnect')->getToken();
		Context::set('token', $token);

		$decodeToken = (array) getModel('nowconnect')->decodeToken($token, $this->module_info->api_key, [ 'HS256' ]);

		Context::set('decodeToken', $decodeToken);
		
		

		$this->setTemplateFile('nowconnect');
	}
}