<?php

require_once(__DIR__ . '/vendor/autoload.php');

use \Firebase\JWT\JWT;

class nowconnectController extends nowconnect
{
	/**
	 * before_display_content 시점의 트리거
	 *
	 * @return Object
	 */
	public function triggerAfterModleProc(&$obj)
	{
		// 관리자 페이지는 수집 대상에서 제외합니다.
		if(Context::get('module') === 'admin')
		{
			return $this->makeObject();
		}

		$config = getModel('nowconnect')->getNowconnectInfo();
		$mid = Context::get('mid');

		$logged_info = Context::get('logged_info');
		$ipaddress = $_SERVER['REMOTE_ADDR'];

		// 관리자가 아닌 경우 IP 주소를 가린다
		if($logged_info->is_admin !== 'Y')
		{
			$ipaddress = preg_replace('/([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)/', '*.$2.*.$4', $ipaddress);
		}

		// 토큰
		$token = getModel('nowconnect')->getToken();
		$session_id = session_id();

		if($config->mid !== $mid)
		{
			$js = <<<JS
<script src="//$config->api_server/socket.io/socket.io.js"></script>
<script>
var socket = io.connect('$config->api_server');
var token = "{$token}";
socket.on('connect', function() {
    // 접속 알림
    socket.emit('systemIn', {
		api_key: '$config->api_key',
		token: token,
		location: window.location.href,
		location_title : window.document.title,
		nickname: "$logged_info->nick_name",
		is_admin: "$logged_info->is_admin"
    });
});
</script>
JS;
			Context::addHtmlFooter($js);
		}
		return $this->makeObject();
	}
}