<?php
/**
 * @class nowconnectAdminView
 *
 * nowconnect 모듈의 admin view class
 */
class nowconnectAdminView extends nowconnect
{
	public function init()
	{
		$oNowconnectModel = getModel('nowconnect');
		$this->module_info = $oNowconnectModel->getNowconnectInfo();
		Context::set('module_info', $this->module_info);
		Context::set('module_srl', $this->module_info->module_srl);

            $skin= $this->module_info->skin;
            if(!$skin) $skin = 'default';
            $skin_path = $this->module_path.'skins/'.$skin;
            if(!is_dir($skin_path)) $skin_path = $this->module_path.'skins/'.$skin;
            $this->setTemplatePath($skin_path);

		// check module_srl is existed or not
		$module_srl = Context::get('module_srl');
		if(!$module_srl && $this->module_srl) {
			$module_srl = $this->module_srl;
			Context::set('module_srl', $module_srl);
		}

		// generate module model object
		$oModuleModel = getModel('module');

		// get the module infomation based on the module_srl
		if($module_srl) {
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
			if(!$module_info) {
				Context::set('module_srl','');
				$this->act = 'list';
			} else {
				ModuleModel::syncModuleToSite($module_info);
				$this->module_info = $module_info;
				$this->module_info->use_status = explode('|@|', $module_info->use_status);
				Context::set('module_info',$module_info);
			}
		}

		if($module_info && $module_info->module != 'nowconnect') return $this->stop("msg_invalid_request");

		// get the module category list
		$module_category = $oModuleModel->getModuleCategories();
		Context::set('module_category', $module_category);

		$security = new Security();
		$security->encodeHTML('module_info.');
		$security->encodeHTML('module_category..');

		// setup template path (nowconnect admin panel templates is resided in the tpl folder)
		$template_path = sprintf("%stpl/",$this->module_path);
		$this->setTemplatePath($template_path);
	}

	public function dispNowconnectAdminInsertNowconnect()
	{
		if($this->module_info->module && !in_array($this->module_info->module, array('admin', 'nowconnect'))) {
			return $this->makeObject(-1, 'msg_invalid_request');
		}

		// get the skins list
		$oModuleModel = getModel('module');
		$skin_list = $oModuleModel->getSkins($this->module_path);
		Context::set('skin_list',$skin_list);

		$mskin_list = $oModuleModel->getSkins($this->module_path, "m.skins");
		Context::set('mskin_list', $mskin_list);

		// get the layouts list
		$oLayoutModel = getModel('layout');
		$layout_list = $oLayoutModel->getLayoutList();
		Context::set('layout_list', $layout_list);

		$mobile_layout_list = $oLayoutModel->getLayoutList(0,"M");
		Context::set('mlayout_list', $mobile_layout_list);

		$security = new Security();
		$security->encodeHTML('skin_list..title','mskin_list..title');
		$security->encodeHTML('layout_list..title','layout_list..layout');
		$security->encodeHTML('mlayout_list..title','mlayout_list..layout');

		// set the template file
		$this->setTemplateFile('nowconnect_insert');
	}

	/**
	 * 스킨 설정
	 */
	public function dispNowconnectAdminSkinInfo()
	{		
		$oModuleAdminModel = getAdminModel('module');

		$skin_content = $oModuleAdminModel->getModuleSkinHTML($this->module_info->module_srl);
		Context::set('skin_content', $skin_content);

		$this->setTemplateFile('skin_info');
	}

	/**
	 * Display the module mobile skin information
	 **/
	public function dispNowconnectAdminMobileSkinInfo() {
		 // get the grant infotmation from admin module
		$oModuleAdminModel = getAdminModel('module');
		$skin_content = $oModuleAdminModel->getModuleMobileSkinHTML($this->module_info->module_srl);
		Context::set('skin_content', $skin_content);

		$this->setTemplateFile('skin_info');
	}
}