<?php

/**
 * @class  nowconnect
 * @author 퍼니XE (contact@funnyxe.com)
 * @brief  nowconnect module high class
 **/

class nowconnect extends ModuleObject
{
	private $triggers = [
		// after_module_proc 시점의 트리거
		['moduleObject.proc', 'nowconnect', 'controller', 'triggerAfterModuleProc', 'after'],
	];

	/**
	 * 모듈 설치 시 실행되는 method
	 */
	public function moduleInstall()
	{
		foreach($this->triggers as $trigger)
		{
			getController('module')->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
		}

		return $this->makeObject();
	}

	/**
	 * 모듈 업데이트 시 실행되는 method
	 */
	public function moduleUpdate()
	{
		foreach($this->triggers as $trigger)
		{
			if(!getModel('module')->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
			{
				getController('module')->insertTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]);
			}
		}

		return $this->makeObject(0, 'success_updated');
	}

	/**
	 * 모듈 업데이트가 필요한 지 확인
	 */
	public function checkUpdate()
	{
		foreach($this->triggers as $trigger)
		{
			if(!getModel('module')->getTrigger($trigger[0], $trigger[1], $trigger[2], $trigger[3], $trigger[4]))
			{
				return true;
			}
		}

		return false;
	}

	public function makeObject($status = 0, $message = 'success')
	{
		return class_exists('BaseObject') ? new BaseObject($status, $message) : new Object($status, $message);
	}
}