<?php
class nowconnectAdminController extends nowconnect
{

	/**
	 * @brief initialization
	 **/
	function init() {
	}

	/**
	 * @brief insert borad module
	 **/
	function procNowconnectAdminInsertNowconnect($args = null) {
		// generate module model/controller object
		$oModuleController = getController('module');
		$oModuleModel = getModel('module');

		// setup the board module infortmation
		$args = Context::getRequestVars();
		$args->module = 'nowconnect';
		$args->mid = $args->nowconnect_name;

		unset($args->nowconnect_name);

		// if there is an existed module
		if($args->module_srl) {
			$module_info = $oModuleModel->getModuleInfoByModuleSrl($args->module_srl);
			if($module_info->module_srl != $args->module_srl) unset($args->module_srl);
		} else {
			$module_info = $oModuleModel->getModuleInfoByMid($args->mid);
		}

		// insert/update the board module based on module_srl
		if(!$args->module_srl) {
			$output = $oModuleController->insertModule($args);
			$msg_code = 'success_registed';
		} else {
			$output = $oModuleController->updateModule($args);
			$msg_code = 'success_updated';
		}

		if(!$output->toBool()) return $output;

		$this->setMessage($msg_code);

		if (Context::get('success_return_url')){
			changeValueInUrl('mid', $args->mid, $module_info->mid);
			$this->setRedirectUrl(Context::get('success_return_url'));
		}else{
			$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispNowconnectAdminInsertNowconnect', 'module_srl', $output->get('module_srl')));
		}
	}
}