<?php

class phpExif extends Object 
{
	protected static $info;
	protected static $srl;
	protected static $file;
        
	public static function setConfig($info)
        {
                self::$info = $info;
        }

	public static function setSrl($srl)
        {
                self::$srl = $srl;
        }

	protected static function setFile($file)
        {
                self::$file = $file;
        }

	protected function gps_display()
	{
		$info = self::$info;
		$mid = Context::get('mid');
		$off_mid = preg_split("/[\s,]+/", $info->gps_display_off);
		$on_mid = preg_split("/[\s,]+/", $info->gps_display_on);
		$logged_info = Context::get('logged_info');
		if(     ($info->gps_display =='Y' && !in_array($mid, $off_mid))
		   ||   ($info->gps_display =='M' && $logged_info->is_admin == 'Y')
		   ||   ($info->gps_display =='N' && in_array($mid, $on_mid))             )
		{	
       			 return true ;
		}
		else  return false ;
	}

	private function setExifCache($cache_path, $cache_file, $exif, $gps) 
	{
		$cache = serialize($exif);
                $gps = serialize($gps);
                if(!is_dir($cache_path)) FileHandler::makeDir($cache_path);
                FileHandler::writeFile($cache_path.$cache_file, $cache);
                FileHandler::writeFile($cache_path.$cache_file.'_1', $gps);
	}

	private function getExifCache($cache_path, $cache_file)
        {
                $exif_info = array();
                if(!file_exists($cache_path.$cache_file)) return false;
                $cache_info =  FileHandler::readFile($cache_path.$cache_file);
                $exif = unserialize($cache_info);
                if(!$exif) return false;
                foreach($exif as $ex) $exif_info[] = $ex;
                if(self::gps_display())
                {
                        $cache_info =  FileHandler::readFile($cache_path.$cache_file.'_1');
                        $gps = unserialize($cache_info);
                        $exif_info[] = $gps[0];
                }
                $new_exif = sprintf('<span class="exif_addon"><button onclick="jQuery(this).parent().toggleClass(\'on\')"><b title="사진의 정보를 봅니다">EXIF</b><span>X</span></button><strong>PHPEXIF Viewer</strong>%s</span>',implode($exif_info));
                return  $new_exif;
        }

	public function getExifData($matche_img)
	{
		$info = self::$info;
		$srl = self::$srl;
		$module = $srl->module;
		$target_srl = $srl->srl;
		$image_path = urldecode($matche_img);
		if(!file_exists($image_path)) return;

//		self::setFile($image_path);
                if($info->cache_use == 'Y')
                {
                        $file_md5 = md5_file($image_path);
                        $cache_path = './files/cache/addon_php_exif/';
                        $cache_file = sprintf('%s.cache.php', $file_md5);
                        $old_exif = self::getExifCache($cache_path, $cache_file);
                        if($old_exif)
                        {
                                return $old_exif;
                        }
                }

		$exif_data = @exif_read_data($image_path,  'IFD0');
		if(!$exif_data) 
		{
			$file_srl = self::getFileSrl($image_path, $target_srl);
			if(!$file_srl) return;
			$exif = self::getExifDB($file_srl);
			return $exif;
	
		}
		$return_exif = self::returnExifInfo($exif_data, $image_path);
		return $return_exif;
	}

	private function returnExifInfo(&$exif_data, $file) 
	{
                $exif_info[] = array();
		$info = self::$info;
                $gps = self::returnGps($exif_data);
                $exif_info = self::returnExif($exif_data);
		if($info->cache_use == 'Y')
                {
                        $file_md5 = md5_file($file);
                        $cache_path = './files/cache/addon_php_exif/';
                        $cache_file = sprintf('%s.cache.php', $file_md5);
                        self::setExifCache($cache_path, $cache_file, $exif_info, $gps);
                }

/*		//애드온에서 이미지스트립 작업 계획중...
		if($info->clearexif_use == 'S')
		{
			$oImageprocessModel = &getModel('imageprocess');
	                if(!$oImageprocessModel) return false;
			$logged_info = Context::get('logged_info');
        	        $args = new stdClass;
			$args->target_srl =  self::$srl->srl;
                	$args->file_srl =  self::getFileSrl($file, $args->target_srl);
			$args->member_srl = $logged_info->member_srl;
			$args->exif = serialize($exif_info); 
			$args->gps = serialize($gps);
			$args->regdate = date('YmdHis');
			$oImageprocessModel->insertEXIF($args);
		}
		if($info->clearexif_use == 'S' || $info->clearexif_use == 'Y')	$oImageprocessModel->clearEXIF('./'.$file);
*/
                if(self::gps_display()) $exif_info[] = $gps[0];
                $new_exif = sprintf('<span class="exif_addon"><button onclick="jQuery(this).parent().toggleClass(\'on\')"><b title="사진의 정보를 봅니다">EXIF</b><span>X</span></button><strong>EXIF Viewer</strong>%s</span>',implode($exif_info));
                return $new_exif;
        }

private function returnExif(&$exif_data)
{
        $ExMode = array('Auto exposure','Manual exposure','Auto bracket');
        $uni_pattern = '<span><b>%s</b>%s</span>';
        $flashfired = ($exif_data['Flash'] & 1) != 0;
        $Flash = array('Not Fired','Fired');
        $Exposure = array('자동','수동','프로그램','조리개우선','셔터우선','정물사진모드','스포츠모드','인물사진모드','풍경사진모드');
        $WB = array('Auto','Manual');
        $Metering = array('','평균평가측광','중앙부중점측광','스팟측광','멀티스팟측광','패턴측광','부분측>광');

        if(!$exif_data['Make']) $exif_data['Make'] = "Unknown";
        if(!$exif_data['Model']) $exif_data['Model'] = "Unknown";
        if($exif_data['DateTimeOriginal'] == $exif_data['DateTime'])
        $exif_data['DateTime'] = null;
        if($exif_data['DateTimeDigitized'] == '0000:00:00 00:00:00')
        $exif_data['DateTimeOriginal'] = null;
        if($exif_data['COMPUTED']['Width'] == $exif_data['ExifImageWidth'])
        $exif_data['COMPUTED']['Width'] = null;
        $replace = array(
                array('카메라제조사', $exif_data['Make']),
                array('카메라모델명', $exif_data['Model']),
                array('소프트웨어', $exif_data['Software'], substr($exif_data['Software'],0,30)),
                array('촬영일자', $exif_data['DateTimeOriginal']),
                array('저장일자', $exif_data['DateTime']),
                array('촬영자', $exif_data['Artist']),
                array('감도(ISO)', $exif_data['ISOSpeedRatings']),
                array('촬영모드', $exif_data['ExposureProgram'], $Exposure[$exif_data['ExposureProgram']]),
                array('노출모드', $exif_data['ExposureMode'], $ExMode[$exif_data['ExposureMode']]),
                array('측광모드', $exif_data['MeteringMode'], $Metering[$exif_data['MeteringMode']]),
                array('노출시간', $exif_data['ExposureTime']),
                array('조리개 값', $exif_data['COMPUTED']['ApertureFNumber']),
                array('촛점거리', $exif_data['FocalLength']),
                array('조리개 최대개방', $exif_data['MaxApertureValue']),
                array('노출보정', $exif_data['ExposureBiasValue'], $exif_data['ExposureBiasValue']),
                array('플래쉬', $flashfired, $Flash[$flashfired]),
                array('35mm 환산', $exif_data['FocalLengthIn35mmFilm']),
                array('화이트밸런스', $exif_data['WhiteBalance'], $WB[$exif_data['WhiteBalance']]),
                array('사진 크기', $exif_data['COMPUTED']['Width'], $exif_data['COMPUTED']['Width'].' X '.$exif_data['COMPUTED']['Height']),
                array('원본사진 크기', $exif_data['ExifImageWidth'], $exif_data['ExifImageWidth'].' X '.$exif_data['ExifImageLength'])
        );

        $exif_info = array();
        for($i=0;$i<count($replace);$i++)
        {
                if($replace[$i][2])
                        $value = $replace[$i][2];
                else
                        $value = $replace[$i][1];
                if(isset($replace[$i][1]))
                        $exif_info[] = sprintf($uni_pattern, $replace[$i][0], $value);
        }
        return $exif_info;
}

	private function returnGps(&$exif_data)
	{
        	$uni_pattern = '<span><b>%s</b>%s</span>';
	        $latitude = $longitude = $altitude = $gps = null;
        	$exif_info = array();
	        if($exif_data['GPSLongitude'] && $exif_data['GPSLatitude'])
        	{
                	$latitude = sprintf($uni_pattern, '위도', $exif_data['GPSLatitudeRef'].' '.self::gps($exif_data["GPSLatitude"]));
	                $longitude = sprintf($uni_pattern, '경도',$exif_data['GPSLongitudeRef'].' '.self::gps($exif_data['GPSLongitude']));
        	        if($exif_data['GPSAltitude']) $altitude = sprintf( $uni_pattern, '고도', '해발 '.self::gpsaltitude($exif_data['GPSAltitude']).'m');
                	$gps = self::triphoto_getGPS($exif_data);
	                $exif_info[] = sprintf('<span class="exif_gps" title="%s"><sub title="%s,%s"></sub>%s%s%s</span></span>','클릭하면 지도에 위치를 표시합니다',$gps['latitude'],$gps['longitude'],$latitude,$longitude,$altitude);
        	}
	        return $exif_info;
	}

	private function triphoto_getGPS($exif)
	{
    		$LatM = 1; $LongM = 1;
		if($exif["GPSLatitudeRef"] == 'S')
	    	$LatM = -1;
		if($exif["GPSLongitudeRef"] == 'W')
		$LongM = -1;

		$gps['LatDegree']=$exif["GPSLatitude"][0];
		$gps['LatMinute']=$exif["GPSLatitude"][1];
		$gps['LatgSeconds']=$exif["GPSLatitude"][2];
		$gps['LongDegree']=$exif["GPSLongitude"][0];
		$gps['LongMinute']=$exif["GPSLongitude"][1];
		$gps['LongSeconds']=$exif["GPSLongitude"][2];
    		foreach($gps as $key => $value)
		{
		    	$pos = strpos($value, '/');
		    	if($pos !== false)
   			{
       				$temp = explode('/',$value);
			        $gps[$key] = $temp[0] / $temp[1];
    			}
    		}

		$result['latitude'] = $LatM * ($gps['LatDegree'] + ($gps['LatMinute'] / 60) + ($gps['LatgSeconds'] / 3600));
		$result['longitude'] = $LongM * ($gps['LongDegree'] + ($gps['LongMinute'] / 60) + ($gps['LongSeconds'] / 3600));

    		return $result;
	}

	private function gpsaltitude($coordinate) 
	{
		if(!$coordinate) return false;
		$part = explode('/', $coordinate);
		if($part[0] == 0)
			return 0;
    		elseif($part[1] == 1 || count($part) ==1)
        		return $part[0];
    		else
        		return number_format(floatval($part[0])/floatval($part[1]));
	}

	private function gps($coordinate) 
	{
  		for ($i = 0; $i < 3; $i++) 
		{
    			$part = explode('/', $coordinate[$i]);
	    		if (count($part) == 1) 
			{
      				$coordinate[$i] = $part[0];
	    		} 
			elseif(count($part) == 2) 
			{
      				$coordinate[$i] = floatval($part[0])/floatval($part[1]);
	    		} else 
			{
			      $coordinate[$i] = 0;
	    		}
  		}
	  	list($degrees, $minutes, $seconds) = $coordinate;
		return $degrees.'.'.sprintf("%02s",$minutes).'.'.sprintf("%02s",$seconds);
	}
		
	public static function getSrl($val)
        {
                $v = preg_split("/[\"_]+/",$val);
		$obj = new stdClass;
		$obj->module = $v[1];
		$obj->srl = $v[2];
                return $obj;
        }

	private function getFileSrl($file, $target_srl)
	{
		if(!$target_srl) return;
		$oFileModel = &getModel('file');
                $file_list = $oFileModel->getFiles($target_srl);
		if(count($file_list) <1) return false;
		foreach($file_list as $val)
		{
			if(str_replace('./','',$val->uploaded_filename) == $file)	 return $val->file_srl;
		}
		return false;
	}

	private function getExifDB($file_srl)
        {
		$oImageprocessModel = &getModel('imageprocess');
		if(!$oImageprocessModel) return;
                $args = new stdClass;
                $args->file_srl = $file_srl;
                $exif = @$oImageprocessModel->getEXIF($args);
		if(!$exif) return;
                $exif_info = unserialize($exif->exif);
		if(self::gps_display())
                {
                        $gps = unserialize($exif->gps);
                        $exif_info[] = $gps[0];
                }
                $new_exif = sprintf('<span class="exif_addon"><button onclick="jQuery(this).parent().toggleClass(\'on\')"><b title="사진의 정보를 봅니다">EXIF</b><span>X</span></button><strong>DBEXIF Viewer</strong>%s</span>',implode($exif_info));
                return  $new_exif;
        }


}
