/*<script>*/
var er123_converter = {
    gennodes: function () {
		var cntVal = document.getElementsByClassName('er123_input_value').length;
		this.nodes = [];
        for (var i = 0; i < cntVal; i++) {
            var id = 'er123_value_id_' + i;
            var node = document.getElementById(id);
 			if (node !== null) {
				node.rate = node.getAttribute('rate');
				this.nodes[i] = node;
			} else {
				break;
			}
        }
    },
    format: function (rate) {
        if (isNaN(rate)) return "0";
        rate = parseFloat(rate);
        if (rate > 10) {
			rate = rate.toFixed(2);
		} else {
			rate = rate.toFixed(5);
		}
        var i = Math.floor(rate).toFixed(0), r = rate - i;
        if (r != 0) {
            var pr = 3;
            if (i > 10) pr = 2;
            else for (var c = r; c < 1; c *= 10) pr++;
            r = r.toFixed(pr).toString().substr(1).replace(/0+$/, '');
        } else r = '';
        return i.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ") + r;
    },
    parse: function (str) {
        return parseFloat(str.replace(/[^0-9E\+\-\.]+/g, ''))
    },
    update: function (idx, self) {
		var cntVal = document.getElementsByClassName('er123_input_value').length;
        if (!this.nodes) this.gennodes();
        var usd = this.parse(this.nodes[idx].value) / this.nodes[idx].rate;
        if (isNaN(usd))return;
        for (var i = 0; i < cntVal; i++)
            if (i != idx || self) this.nodes[i].value = this.format(this.nodes[i].rate * usd);
    },
	text_hellow: "Hellow",
	sayHellow: function (idx, self) {
		alert( this.text_hellow + idx + self);
	}
};

jQuery(function($){
	$(document).ready(function(){
		var id = 'er123_converter_table';
		var base_low = document.getElementById(id).getAttribute('base_low');
		er123_converter.update(0, base_low);
	});
});
/*</script>*/
