<?php
/**
 * @Class:		exchangeRateXE123
 * @Author:		Keysung Chung (keysung2004@gmail.com)
 * @version:	1.1.0
 * @Copyright:	© 2018 Keysung Chung(keysung2004@gmail.com)
 * @Release:	under GPL-v2 License.
 * @License:	http://www.opensource.org/licenses/gpl-2.0.php
 * @RSS feed:	https://usd.fxexchangerate.com/rss.xml
 * @Brief:		Widget to display Foreign Exchange Rates
 */

class exchangeRateXE123 extends WidgetHandler 
{
	function proc($args) 
	{
		$XE_version = __XE_VERSION__;
		$proc_time = time();
		$er123_version = "exchangeRateXE123 Widget V1.1.0(" .$XE_version. "+".phpversion() . ")";

		if ($args->base_currency) 
		{
			$base_curr = $args->base_currency;
		} 
		else 
		{
			$base_curr = 'USD';
		}

		if ($args->local_currency) 
		{
			$local_curr = $args->local_currency;
		} 
		else 
		{
			$local_curr = 'KRW';
		}

		if ($args->target_currency) 
		{
			$target_currency = explode(",", $args->target_currency);
		} 
		else 
		{
			$target_currency = array('KRW','USD','JPY','CNY','VND','EUR','AUD','CAD');
		}

		$currency_others = trim(strtoupper($args->currency_others));
		if ($currency_others) 
		{
			$wrk_arr = explode(',', $currency_others);
			foreach ($wrk_arr as $key => $value) 
			{
				if (!in_array($value, $target_currency)) 
				{
					$target_currency[] = $value;
				}
			}
		}

		if (!in_array($base_curr, $target_currency))
		{
			$target_currency[] = $base_curr;
		}
		$seq_base_curr_arr = array_keys($target_currency, $base_curr);
		$count_target_currency = count($target_currency);

		//RSS 
		$lang_type = Context::getLangType();
		if ($lang_type == 'ko') 
		{
			$rss_url = 'https://kr.fxexchangerate.com/'.strtolower($base_curr).'/rss.xml';
			$rss_language = 'kr';
		} 
		else 
		{
			$rss_url = 'https://'.strtolower($base_curr).'.fxexchangerate.com/rss.xml';
			$rss_language = 'en';
		}

		//cache
		if ($args->cache_time == '')
		{
			$cache_time = 10; //default: 10분
		}
		else
		{
			$cache_time = $args->cache_time;
		}

		if ($cache_time == 'N') 
		{
			$rss_xml = $this->_getRssXML($rss_url);//Get xml
			$curr_exRate_arr = $this->_getCurr_exRate_arr($rss_xml, $target_currency, $proc_time);//Build exchange array
		}
		else
		{
			$cache_ind = '';
			$cache_key = "exchangeRate123";
			$curr_exRate_arr = $this->_getCache($cache_key, $cache_time);
			$time_gap = $proc_time - $curr_exRate_arr['channel']['proc_time_stamp']; 
			$cache_language = $curr_exRate_arr['channel']['language']; 
			if ($time_gap < $cache_time * 60 && count($curr_exRate_arr['item']) >= $count_target_currency && $cache_language == $rss_language) 
			{
				$cache_ind = '(C)';
			}
			else
			{
				$rss_xml = $this->_getRssXML($rss_url);//Get xml
				$curr_exRate_arr = $this->_getCurr_exRate_arr($rss_xml, $target_currency, $proc_time);//Build exchange array
				if (count($curr_exRate_arr['item']) < $count_target_currency) 
				{
					$curr_exRate_arr = $this->_getCache($cache_key, $cache_time);
				}
				else
				{
					$this->_putCache($cache_key, $curr_exRate_arr, $cache_time);
				}
			}
		}

		if ($args->rss_feed == 'adj_google') 
		{
			//Update exchange array by google data
			$curr_exRate_arr = $this->_updateCurr_exRate_arr($curr_exRate_arr);
		}

		//local currency amount
		foreach ($curr_exRate_arr['item'] as $key => $val) 
		{
			if ($key == $local_curr) 
			{
				if ($val['base_rate'] >= 1000) 
				{
					$local_amount = 1000;
				} 
				else 
				{
					$local_amount = 1;
				}
				$local_rate = (float)$local_amount / (float)$val['base_rate'];
			}
		}

		//calculate local rate
		foreach ($curr_exRate_arr['item'] as $key => $val) 
		{
			$curr_exRate_arr['item'][$key]['local_rate'] = substr(round( (float)$val['base_rate'] * $local_rate, 3) , 0, 7);
			$curr_exRate_arr['item'][$key]['local_desc'] = $local_amount.' '.$local_curr.' = '.$val['local_rate'].' '.$val['curr_text'];
		}

		//border color
		if (trim($args->border_color))
		{
			$border_color = trim($args->border_color);
		} 
		else 
		{
			$border_color = '#7CA5D6';
		}

		//Set variables for widget
		$widget_info->border_color = $border_color;
		$widget_info->er123_version = $er123_version;
		$widget_info->lang_type = $lang_type;
		$widget_info->base_curr = $base_curr;
		$wrk_arr = explode('(', $curr_exRate_arr['channel']['title']);
		$widget_info->base_curr_text = $wrk_arr[0];
		$widget_info->local_curr = $local_curr;
		$widget_info->local_amount = $local_amount;
		$widget_info->lastBuildDate = $curr_exRate_arr['channel']['lastBuildDate'];
		$widget_info->target_currency = $target_currency;
		$widget_info->er123_item = $curr_exRate_arr['item'];
		$widget_info->seq_base_curr = $seq_base_curr_arr[0];
		$widget_info->cache_ind = $cache_ind;
		$widget_info->colorset = $args->colorset;

		Context::set('widget_info', $widget_info);

		//style & path
		$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
		$default_style = $args->default_style;
		if ($default_style && $default_style != 'randum') 
		{
			$tpl_file = $default_style;
		} 
		else 
		{
			if (Context::get('is_logged')) 
			{
				$tpl_file = 'er123_converter';
			} 
			else 
			{
				$tpl_file = 'er123_list';
			}
		}

		//compile
		$oTemplate = &TemplateHandler::getInstance();
		$output = $oTemplate->compile($tpl_path, $tpl_file);
		return $output;

	} //end proc

	/* ========================= */
	/******************************
	 * @brief Get from cache
	 */
	function _getRssXML($rss_url)
	{
		$rss_url = str_replace('&amp;','&',Context::convertEncodingStr($rss_url));
		$rss_value = FileHandler::getRemoteResource($rss_url, null, 3, 'GET', 'application/xml');
		$rss_value = preg_replace( "/\r|\n|\r\n/", "", $rss_value); //removes all newlines and carriage returns

		$encoding = preg_match("/<\?xml.*encoding=\"(.+)\".*\?>/i", $rss_value, $matches);
        if ($encoding && stripos($matches[1], "UTF-8") === FALSE) 
		{
			$rss_value = Context::convertEncodingStr($rss_value);
		}
		$rss_value = preg_replace("/<\?xml.*\?>/i", "", $rss_value);
		$rss_xml = simplexml_load_string((string)$rss_value, null, LIBXML_NOCDATA);
		return $rss_xml; 
	}

	/******************************
	 * @brief Get curr_exRate_arr
	 */
	function _getCurr_exRate_arr($rss_xml,  $target_currency, $proc_time)
	{
		$rssItem_arr = $rss_xml->channel->item;
		$curr_exRate_arr['channel']['title'] = (string)$rss_xml->channel->title;
		$curr_exRate_arr['channel']['description'] = (string)$rss_xml->channel->description;
		$curr_exRate_arr['channel']['lastBuildDate'] = (string)$rss_xml->channel->lastBuildDate;
		$curr_exRate_arr['channel']['language'] = (string)$rss_xml->channel->language;
		$curr_exRate_arr['channel']['proc_time_stamp'] = $proc_time; 

		foreach ($rssItem_arr as $key => $val) 
		{
			$wrk_arr = explode("/", (string)$val->title);
			$curr_text =$wrk_arr[1];
			$curr_id = substr((string)$val->title, -4, 3);
			if (in_array($curr_id, $target_currency)) 
			{
				$wrk_arr = explode("=", (string)$val->description);
				$wrk_arr2 = explode(' ', $wrk_arr[1]);
				$base_rate = substr($wrk_arr2[1], 0, 7) + 0;
				$tmp_arr['title'] = (string)$val->title;
				$tmp_arr['pubDate'] = (string)$val->pubDate;
				$tmp_arr['description'] = (string)$val->description;
				$tmp_arr['category'] = (string)$val->category;
				$tmp_arr['curr_text'] = $curr_text; 
				$tmp_arr['base_rate'] = $base_rate; 
				$tmp_arr['proc_time_stamp'] = $proc_time; 
				$curr_exRate_arr['item'][$curr_id] = $tmp_arr; //make exchange rate arrary
			}
		}
		return $curr_exRate_arr; 
	}

	/******************************
	 * @brief Update $curr_exRate_arr
	 */
	function _updateCurr_exRate_arr($curr_exRate_arr)
	{
		$url_xml = 'https://spreadsheets.google.com/feeds/list/0Av2v4lMxiJ1AdE9laEZJdzhmMzdmcW90VWNfUTYtM2c/2/public/basic?alt=rss';
		$rss_xml = $this->_getRssXML($url_xml);
		if (count($rss_xml->channel->item) > 0) 
		{
			foreach ( $rss_xml->channel->item as $key => $val) 
			{
				$curr_id = (string)$val->title;
				if (array_key_exists($curr_id, $curr_exRate_arr['item'])) 
				{
					$wrk_arr = explode(" ", (string)$val->description);
					if ($wrk_arr[1] != '#N/A' && $wrk_arr[1] != "")
					{
						$curr_exRate_arr['item'][$curr_id]['base_rate'] = $wrk_arr[1];
					}
				}
			}
		}
		return $curr_exRate_arr; 
	}

	/******************************
	 * @brief Get from cache
	 */
	function _getCache($cache_key, $cache_time)
	{
		$oCacheHandler = CacheHandler::getInstance('object', NULL, TRUE);
		if($cache_time && $oCacheHandler->isSupport() && $oCacheHandler->isValid($cache_key,$cache_time))
		{
			$get_value = $oCacheHandler->get($cache_key,$cache_time); //get
		}
		return $get_value; 
	}

	/******************************
	 * @brief Put cache
	 */
	function _putCache($cache_key, $put_value, $cache_time)
	{
		$oCacheHandler = CacheHandler::getInstance('object', NULL, TRUE);
		if($oCacheHandler->isSupport())
		{
			$oCacheHandler->put($cache_key, $put_value, $cache_time * 60); //put
		}
	}
	/* ========================= */

} // end class

/* End of file exchangeRateXE123.class.php */
/* Location: ./widgets/exchangeRateXE123/exchangeRateXE123.class.php */
