<?php
/**
 * @class  geoipxe
 * @author KnDol (kndol@kndol.net)
 * @brief  geoipxe module's class 
 **/
class geoipxe extends ModuleObject {
	const TABLE14_NAME='geoipxe_db1_v4';
	const TABLE16_NAME='geoipxe_db1_v6';
	const TABLE34_NAME='geoipxe_db3_v4';
	const TABLE36_NAME='geoipxe_db3_v6';
	/**
	 * constructor
	 *
	 * @return void
	 */
	function geoipxe()
	{
	}

	/**
	 * @brief Install geoipxe module 
	 **/
	function moduleInstall() {
 		$oDB = &DB::getInstance();

		$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE14_NAME.'.xml');
		$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE16_NAME.'.xml');
		$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE34_NAME.'.xml');
		$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE36_NAME.'.xml');
	
		return $this->createObject();
	}

	/**
	 * @brief 설치가 이상이 없는지 체크하는 method
	 **/
	function checkUpdate() {
 		$oDB = &DB::getInstance();
		
		if(!$oDB->isColumnExists(self::TABLE14_NAME, "ip_from")) return true;
		if(!$oDB->isColumnExists(self::TABLE16_NAME, "ip_from")) return true;
		if(!$oDB->isColumnExists(self::TABLE34_NAME, "ip_from")) return true;
		if(!$oDB->isColumnExists(self::TABLE36_NAME, "ip_from")) return true;

		return false;
	}

	/**
	 * @brief 업데이트 실행
	 **/
	function moduleUpdate() {
		$oDB = &DB::getInstance();

		if(!$oDB->isColumnExists(self::TABLE14_NAME, "ip_from")) {
			$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE14_NAME.'.xml');
		}
		if(!$oDB->isColumnExists(self::TABLE16_NAME, "ip_from")) {
			$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE16_NAME.'.xml');
		}
		if(!$oDB->isColumnExists(self::TABLE34_NAME, "ip_from")) {
			$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE34_NAME.'.xml');
		}
		if(!$oDB->isColumnExists(self::TABLE36_NAME, "ip_from")) {
			$oDB->createTableByXmlFile($this->module_path.'schemas/'.self::TABLE36_NAME.'.xml');
		}

		return $this->createObject(0, 'success_updated');
	}

	/**
	 * @brief 삭제시 동작
	 */
	function moduleUninstall() {
		$oDB = &DB::getInstance();

		$oDB->DropTable(self::TABLE14_NAME);
		$oDB->DropTable(self::TABLE16_NAME);
		$oDB->DropTable(self::TABLE34_NAME);
		$oDB->DropTable(self::TABLE36_NAME);
	}

	/**
	 * @brief 캐시 파일 재생성
	 **/
	function recompileCache() {
	}
	
	/**
	 * XE 버전에 따라 Object, BaseObject 클래스 호환성을 보장하기 위한 메소드.
	 */
	public function createObject($error = 0, $message = 'success')
	{
		return class_exists('BaseObject') ? new BaseObject($error, $message) : new Object($error, $message);
	}

}
/* End of file geoipxe.class.php */
/* Location: ./modules/geoipxe/geoipxe.class.php */
