// 관리자 페이지 전용 cal.js

function cal_insert() {
  var params = new Array();
  params['title'] = $('#title').val();
  params['description'] = $('#description').val();
  params['date'] = $('#until').val();
  params['time'] = $('#time').val().trim();
  params['gc_srl'] = $('#gc_srl').val();
  data_check(params);
  var response_tags = new Array('error', 'message', 'info');
  exec_xml('google_calendar', 'getGoogle_calendarInsertSchedule', params, completeCalInsert, response_tags);
}

function completeCalInsert(ret_obj) {

  var info = ret_obj['info'];
  var bug = ret_obj['bug'];
  ifreamReload();
  if (info.state == 'insert') {
    $('#calendar_table > tbody:last').append('<tr id="gcTable_' + info.gc_srl + '"><td>' + info.title + '</td><td>' + info.date + '</td><td>' + info.time + '</td><td>' + info.description + '</td><td><a onClick="cal_update(' + info.gc_srl + ')"class="x_icon-cog"></a></td><td><a  onClick="cal_delete(' + info.gc_srl + ')" class="x_icon-remove"></a></td></tr>');
    input_clear();
  } else if (info.state == 'update') {
    $('#gcTable_' + info.gc_srl + ' > td:eq(0)').html(info.title);
    $('#gcTable_' + info.gc_srl + ' > td:eq(1)').html(info.date);
    $('#gcTable_' + info.gc_srl + ' > td:eq(2)').html(info.time);
    $('#gcTable_' + info.gc_srl + ' > td:eq(3)').html(info.description);
  }
  $('#cal_tab > li:eq(0)').removeClass('x_active');
  $('#cal_tab > li:eq(1)').addClass('x_active');
  $('#extra_var1').removeClass('x_active');
  $('#extra_var1').css('display', 'none');
  $('#extra_var2').addClass('x_active');
  $('#extra_var2').css('display', '');

}
function cal_delete(gc_srl) {
  if (confirm("캘린더 정보를 삭제하시겠습니까?") == true) { //확인
    var params = new Array();
    params['title'] = $('#gcTable_' + gc_srl + ' > td:eq(0)').html();
    params['date'] = $('#gcTable_' + gc_srl + ' > td:eq(1)').html();
    params['time'] = $('#gcTable_' + gc_srl + ' > td:eq(2)').html();
    params['description'] = $('#gcTable_' + gc_srl + ' > td:eq(3)').html();
    params['gc_srl'] = gc_srl;

    $('#title').val(params['title']);
    $('#until').val(params['date']);
    $('#time').val(params['time']);
    $('#description').val(params['description']);
    $('#gc_srl').val(gc_srl);

    var response_tags = new Array('error', 'message', 'info');
    exec_xml('google_calendar', 'getGoogle_calendarDeleteSchedule', params, completeCalDelete, response_tags);
  } else { //취소
    return;
  }
}

function completeCalDelete(ret_obj) {
  var info = ret_obj['info'];
  if (info.state == 'success') {
    $('#calendar_table > tbody > tr#gcTable_' + info.gc_srl).remove();
    ifreamReload();
    input_clear();
  } else {
    alert('삭제에 실패하였습니다.');
    console.log(info);
  }
}
function data_check(data) {
  var date_pattern = /^(19|20|21)\d{2}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[0-1])$/;
  var time_pattern = /^([1-9]|[01][0-9]|2[0-3]):([0-5][0-9])$/;
  if (!date_pattern.test(data['date'])) {
    alert('잘못된 날짜 입력. ex)2011-01-11');
    console.log(data['date']);
    throw "stop";
  }
  if (!time_pattern.test(data['time'])) {
    alert('잘못된 시간 입력. ex)13:34');
    console.log(data['time']);
    throw "stop";
  }
}
function ifreamReload() {
  var url = $('#gc_frame').attr('src');
  $('#gc_frame').attr('src', url);
}

function input_clear() {
  var dt = new Date();
  $('#title').val('');
  $('#description').val('');
  $('#until').val('');
  $('#time').val('');
  $('#gc_srl').val('');
}

function cal_update(gc_srl) {
  var params = new Array();
  params['title'] = $('#gcTable_' + gc_srl + ' > td:eq(0)').html();
  params['date'] = $('#gcTable_' + gc_srl + ' > td:eq(1)').html();
  params['time'] = $('#gcTable_' + gc_srl + ' > td:eq(2)').html();
  params['description'] = $('#gcTable_' + gc_srl + ' > td:eq(3)').html();

  $('#title').val(params['title']);
  $('#until').val(params['date']);
  $('#time').val(params['time']);
  $('#description').val(params['description']);
  $('#gc_srl').val(gc_srl);

  $('#cal_tab > li:eq(1)').removeClass('x_active');
  $('#cal_tab > li:eq(0)').addClass('x_active');
  $('#extra_var2').removeClass('x_active');
  $('#extra_var2').css('display', 'none');
  $('#extra_var1').addClass('x_active');
  $('#extra_var1').css('display', '');

}
