<?php

/**
 * google_calendar
 *dispGoogle_calendar
 * Copyright (c) Kants
 *
 * Generated with https://www.poesis.org/tools/modulegen/
 */
class Google_calendarModel extends Google_calendar
{
	function triggerModuleListInSitemap(&$obj){ array_push($obj,'google_calendar'); }
	
	
	public function getGoogle_calendarInsertSchedule(){
		$vars = Context::getRequestVars();
		$gcController = &getController('google_calendar');
		$info = $gcController->procGoogle_calendarInsertSchedule($vars);		
		$this->add('info', $info);
	}

	public function getGoogle_calendarDeleteSchedule(){
		$vars = Context::getRequestVars();
		$gcController = &getController('google_calendar');
		$info = $gcController->procGoogle_calendarDeleteSchedule($vars);
		if($info->gc_srl != null){
			$info->state = 'success';
			$this->add('info', $info);
		}
	}

	public function getPostRequest($postargs,$token, $cal, $method, $event_id, $APIKEY){
		$cal = $cal.'@gmail.com'; 
		$request = 'https://www.googleapis.com/calendar/v3/calendars/' . $cal . '/events?key=' . $APIKEY;
		switch($method){
			case 'POST':
				$request = 'https://www.googleapis.com/calendar/v3/calendars/' . $cal . '/events?key=' . $APIKEY;
				break;
			case 'del':
				$request = 'https://www.googleapis.com/calendar/v3/calendars/' . $cal . '/events/' . $event_id .'?key=' . $APIKEY;
				break;
			case 'put':
				$request = 'https://www.googleapis.com/calendar/v3/calendars/' . $cal . '/events/' . $event_id .'?sequence&key=' . $APIKEY;
				break;
		}
		$session = curl_init($request);
			switch($method) {
				case 'GET':
					break;
				case 'POST':
					curl_setopt($session, CURLOPT_POST, true);
					curl_setopt($session, CURLOPT_POSTFIELDS, $postargs);
					break;
				case 'put':
					curl_setopt($session, CURLOPT_CUSTOMREQUEST, 'PUT');
					curl_setopt($session, CURLOPT_POSTFIELDS, $postargs);
					break;
				case 'del':
					curl_setopt($session, CURLOPT_CUSTOMREQUEST, 'DELETE');
					break;
			}
		// Tell curl not to return headers, but do return the response
		curl_setopt($session, CURLOPT_HEADER, false);
		curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
		//curl_setopt($session, CURLOPT_VERBOSE, true);
		curl_setopt($session, CURLINFO_HEADER_OUT, true);
		curl_setopt($session, CURLOPT_HTTPHEADER, array('Content-Type:  application/json','Authorization:  Bearer ' . $token,'X-JavaScript-User-Agent:  Mount Pearl Tennis Club Bookings'));
		$response = curl_exec($session);
		curl_close($session);
		return $response;
	}

	public function getAccess(){
		$config = $this->getConfig();
		$tokenURL = 'https://accounts.google.com/o/oauth2/token';
		$postData = array(
			'client_secret'=>$config->client_secret,
			'grant_type'=>'refresh_token',
			'refresh_token'=>$config->refresh_token,
			'client_id'=>$config->client_id
		);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $tokenURL);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$tokenReturn = curl_exec($ch);
		$token = json_decode($tokenReturn);
		$accessToken = $token->access_token;
		return $accessToken;
	}
	public function getCreatePostArgsJSON($obj){
			$arg_list = func_get_args();
			foreach($arg_list as $key => $arg){
				$arg_list[$key] = urlencode($arg);
			}
			$json_arry = Array();

			$end_time = date("H:i",strtotime($obj->time."+1 hour"));
			$start['dateTime'] = $obj->date. 'T' .$obj->time. ':00.000+09:00';
			$end['dateTime'] = $obj->date. 'T' .$end_time. ':00.000+09:00';

			$json_arry['start'] = $start;
			$json_arry['end'] = $end;
			$json_arry['summary'] = $obj->title;
			$json_arry['description'] = $obj->description;
			if($obj->sequence){
				$json_arry['sequence'] = $obj->sequence;
			}

			$json_arry = json_encode($json_arry);
			return $json_arry;
	}

	public function getGC_srl2eventId($event_id){		
		$obj->event_id = $event_id; 			
		$output = executeQuery('google_calendar.getGC_srl2eventId', $obj);				
		return $output;  
	}

	public function getGC_srl2document($document_srl){
		$obj->document_srl = $document_srl; 
		$output = executeQuery('google_calendar.getGC_srl2document', $obj);
		return $output;
	}
	public function getGC_opt(){
		$output = executeQuery('google_calendar.getGC_opt');
		return $output->data;
	}
}
