<?php

/**
 * google_calendar
 *
 * Copyright (c) Kants
 *
 * Generated with https://www.poesis.org/tools/modulegen/
 */
class Google_calendar extends ModuleObject
{
	/**
	 * 등록할 트리거를 여기에 선언하면 자동으로 등록된다.
	 * checkUpdate(), moduleUpdate() 등에서 체크 및 생성 루틴을 중복으로 작성하지 않아도 된다.
	 */
	protected static $_insert_triggers = array(
		array('document.insertDocument', 'after', 'controller', 'triggerAfterInsertDocument'),
		array('document.updateDocument', 'after', 'controller', 'triggerAfterUpdateDocument'),
		array('document.deleteDocument', 'after', 'controller', 'triggerAfterDeleteDocument'),
	);

	/**
	 * 이전 버전에서 등록했던 트리거를 삭제하려면 위와 동일한 문법으로 여기에 선언하면 된다.
	 * 사용하지 않는 트리거는 삭제해 주는 것이 성능에 도움이 된다.
	 */
	protected static $_delete_triggers = array(
		array('document.insertDocument', 'after', 'controller', 'triggerAfterInsertDocument'),
		array('document.updateDocument', 'after', 'controller', 'triggerAfterUpdateDocument'),
		array('document.deleteDocument', 'after', 'controller', 'triggerAfterDeleteDocument'),
	);

	// ================== 이 부분 아래는 수정하지 않아도 된다 ==================

	/**
	 * 모듈 설정 캐시를 위한 변수.
	 */
	protected static $_config_cache = null;

	/**
	 * 캐시 핸들러 캐시를 위한 변수.
	 */
	protected static $_cache_handler_cache = null;

	/**
	 * 모듈 설정을 가져오는 함수. 캐시 처리되기 때문에 ModuleModel을 직접 호출하는 것보다 효율적이다.
	 * 모듈 내에서 설정을 불러올 때는 반드시 이 함수를 사용하도록 한다.
	 *
	 * @return object
	 */
	public function getConfig()
	{
		if (self::$_config_cache === null)
		{
			$oModuleModel = getModel('module');
			self::$_config_cache = $oModuleModel->getModuleConfig($this->module) ?: new stdClass;
		}
		return self::$_config_cache;
	}

	/**
	 * 모듈 설정을 저장하는 함수.
	 * 설정을 변경할 필요가 있을 때 ModuleController를 직접 호출하지 말고 이 함수를 사용한다.
	 *
	 * @param object $config
	 * @return object
	 */
	public function setConfig($config)
	{
		$oModuleController = getController('module');
		$result = $oModuleController->insertModuleConfig($this->module, $config);
		if ($result->toBool())
		{
			self::$_config_cache = $config;
		}
		return $result;
	}

	/**
	 * 오브젝트 캐시에서 값을 가져오는 함수.
	 * 그룹 키를 지정하지 않으면 자동으로 현재 모듈 이름이 그룹 키로 사용되므로 필요시 신속하게 캐시를 비울 수 있다.
	 *
	 * @param string $key
	 * @param int $ttl
	 * @param string $group_key (optional)
	 * @return mixed
	 */
	public function getCache($key, $ttl = 86400, $group_key = null)
	{
		if (self::$_cache_handler_cache === null)
		{
			self::$_cache_handler_cache = CacheHandler::getInstance('object');
		}

		if (self::$_cache_handler_cache->isSupport())
		{
			$group_key = $group_key ?: $this->module;
			return self::$_cache_handler_cache->get(self::$_cache_handler_cache->getGroupKey($group_key, $key), $ttl);
		}
		else
		{
			return false;
		}
	}

	/**
	 * 오브젝트 캐시에 값을 저장하는 함수.
	 * 그룹 키를 지정하지 않으면 자동으로 현재 모듈 이름이 그룹 키로 사용되므로 필요시 신속하게 캐시를 비울 수 있다.
	 *
	 * @param string $key
	 * @param mixed $value
	 * @param int $ttl
	 * @param string $group_key (optional)
	 * @return bool
	 */
	public function setCache($key, $value, $ttl = 86400, $group_key = null)
	{
		if (self::$_cache_handler_cache === null)
		{
			self::$_cache_handler_cache = CacheHandler::getInstance('object');
		}

		if (self::$_cache_handler_cache->isSupport())
		{
			$group_key = $group_key ?: $this->module;
			return self::$_cache_handler_cache->put(self::$_cache_handler_cache->getGroupKey($group_key, $key), $value, $ttl);
		}
		else
		{
			return false;
		}
	}

	/**
	 * 오브젝트 캐시에서 개별 키를 삭제하는 함수.
	 *
	 * @param string $key
	 * @param string $group_key (optional)
	 * @return bool
	 */
	public function deleteCache($key, $group_key = null)
	{
		if (self::$_cache_handler_cache === null)
		{
			self::$_cache_handler_cache = CacheHandler::getInstance('object');
		}

		if (self::$_cache_handler_cache->isSupport())
		{
			$group_key = $group_key ?: $this->module;
			self::$_cache_handler_cache->delete(self::$_cache_handler_cache->getGroupKey($group_key, $key));
		}
		else
		{
			return false;
		}
	}

	/**
	 * 오브젝트 캐시를 비우는 함수.
	 * 지정된 그룹 키에 소속된 데이터만 삭제한다. 현재 모듈에서 저장한 데이터만 삭제하는 것이 기본값이다.
	 *
	 * @param string $group_key (optional)
	 * @return bool
	 */
	public function clearCache($group_key = null)
	{
		if (self::$_cache_handler_cache === null)
		{
			self::$_cache_handler_cache = CacheHandler::getInstance('object');
		}

		if (self::$_cache_handler_cache->isSupport())
		{
			$group_key = $group_key ?: $this->module;
			return self::$_cache_handler_cache->invalidateGroupKey($group_key);
		}
		else
		{
			return false;
		}
	}

	/**
	 * XE Object를 생성하여 반환한다. XE 1.8 이하, XE 1.9 이상, PHP 7.1 이하, PHP 7.2 이상 모두 호환된다.
	 * 기본적인 사용법은 return new Object(-1, 'error'); 라고 쓸 자리에
	 * return $this->createObject(-1, 'error'); 라고 쓰면 된다.
	 *
	 * @param string $message
	 * @param $arg1, $arg2 ...
	 * @return object
	 */
	public function createObject($status, $message /* $arg1, $arg2 ... */)
	{
		$args = func_get_args();
		if (count($args) > 2)
		{
			global $lang;
			$message = vsprintf($lang->$message, array_slice($args, 2));
		}
		return class_exists('BaseObject') ? new BaseObject($status, $message) : new Object($status, $message);
	}

	/**
	 * 트리거 확인 함수. 위에서 선언한 트리거 목록을 참조한다. 웬만하면 수정할 필요 없음.
	 *
	 * @return bool
	 */
	public function checkTriggers()
	{
		$oModuleModel = getModel('module');
		foreach (self::$_insert_triggers as $trigger)
		{
			if (!$oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
			{
				return true;
			}
		}
		foreach (self::$_delete_triggers as $trigger)
		{
			if ($oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * 트리거 등록 함수. 위에서 선언한 트리거 목록을 참조한다. 웬만하면 수정할 필요 없음.
	 *
	 * @return object
	 */
	public function registerTriggers()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		foreach (self::$_insert_triggers as $trigger)
		{
			if (!$oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
			{
				$oModuleController->insertTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]);
			}
		}
		foreach (self::$_delete_triggers as $trigger)
		{
			if ($oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
			{
				$oModuleController->deleteTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]);
			}
		}
		return new Object(0, 'success_updated');
	}

	public function updaterTriggers($method)
	{		
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		$triggers = array(
			array('document.insertDocument', 'after', 'controller', 'triggerAfterInsertDocument'),
			array('document.updateDocument', 'after', 'controller', 'triggerAfterUpdateDocument'),
			array('document.deleteDocument', 'after', 'controller', 'triggerAfterDeleteDocument'),
		);
		if($method == 'del'){			
			foreach ($triggers as $trigger)
			{				
				if ($oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
				{
					$st = $oModuleController->deleteTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]);
					
				}
			}
		}elseif($method == 'insert'){
			foreach ($triggers as $trigger)
			{
				if (!$oModuleModel->getTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]))
				{
					$oModuleController->insertTrigger($trigger[0], $this->module, $trigger[2], $trigger[3], $trigger[1]);
				}
			}
		}		
		return new Object(0, 'success_updated');
	}


	/**
	 * 모듈 설치 콜백 함수. 웬만하면 수정할 필요 없음.
	 *
	 * @return object
	 */
	public function moduleInstall()
	{

		// return $this->registerTriggers();
	}

	/**
	 * 모듈 업데이트 확인 콜백 함수. 웬만하면 수정할 필요 없음.
	 *
	 * @return bool
	 */
	public function checkUpdate()
	{
		$oModuleModel = getModel('module'); if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'google_calendar', 'model', 'triggerModuleListInSitemap', 'after')) return true; return false;
		// return $this->checkTriggers();
		
	}

	/**
	 * 모듈 업데이트 콜백 함수. 웬만하면 수정할 필요 없음.
	 *
	 * @return object
	 */
	public function moduleUpdate()
	{
		$oModuleModel = getModel('module'); $oModuleController = getController('module'); if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'google_calendar', 'model', 'triggerModuleListInSitemap', 'after')) { $oModuleController->insertTrigger('menu.getModuleListInSitemap', 'google_calendar', 'model', 'triggerModuleListInSitemap', 'after'); } return new Object(0, 'success_updated');
		// return $this->registerTriggers();
	}

	/**
	 * 캐시파일 재생성 콜백 함수. 웬만하면 수정할 필요 없음.
	 *
	 * @return void
	 */
	public function recompileCache()
	{
		$this->clearCache();
	}
}
