<?php
/******************************************************************
 * @description		Theme Admin (관리자 페이지에 스킨을 적용하는 애드온입니다.)
 * @license			AFL v1 (MIT 호환)
 ******************************************************************/
if(!class_exists('theme_admin')) {
	class theme_admin {
		public $addon_info;
		public $addon_path = _XE_PATH_ . "addons/theme_admin/";
		public $skin_path;
		public $module_object = NULL;
		
		public function setModuleObject(&$oM) {
			$this->module_object = &$oM;
		}
			
		public function setInfo($i) {
			$this->addon_info = $i;
		}
		
		public function applyThemeAdmin() {
			$addon_info = $this->addon_info;
			$skin_path = $this->addon_path;
			$skin_path .= 'skins/';
			$skin_path .= $this->addon_info->skins;
			$skin_path .= '/';
			
			$oModuleObject = &$this->module_object;
			$oModuleObject->setLayoutPath($skin_path);
			if($oModuleObject->module == 'admin') {
				$oModuleObject->setTemplatePath($skin_path);
			}
			$skinInfo = $this->getSkinInfo($this->addon_info->skins);
			$oContext = Context::getInstance();
			
			foreach($skinInfo->baseCSS as $v){
				$file = $skin_path;
				$file .= $v;
				$oContext->loadFile($file);
			}
			
			foreach($skinInfo->baseJS as $v){
				$file = $skin_path;
				$file .= $v;
				$oContext->loadFile($file);
			}
			

		}
		public function setAdminPage() {
			$addon_info = Context::get('addon_info');
			$skinList = $this->getSkinList();
			
			$def = new stdClass;
			$def->title = '선택하세요';
			$def->value = '';
			$skins = array($def);
			unset($def);
			
			foreach($skinList as $v) {
				$skinRow = new stdClass();
				$skinRow->title=$v->name;
				$skinRow->title.=' ';
				$skinRow->title.=$v->version;
				$skinRow->title.=' (Author: ';
				$skinRow->title.=$v->author->name;
				$skinRow->title.=')';
				$skinRow->value=$v->skin_path;
				$skins[] = $skinRow;
				unset($skinRow);
			}
			unset($skinList);
			
			foreach($addon_info->extra_vars as &$v) 
				if($v->name == 'skins') $v->options = $skins;
			
			Context::set("addon_info", $addon_info);
			unset($addon_info);
		}
		
		public function getSkinList() {
			$addon_info = Context::get('addon_info');
			
			$skin_path = $this->addon_path;
			$skin_path .= '/skins/';
			$this->skin_path = $skin_path;
			
			if(!is_dir($skin_path)) return array();
			
			$tmpArr = scandir($skin_path);
			$skinList = array();
			foreach($tmpArr as $v) {
				if(!preg_match("/^\./i", $v)) {
					$skin_json_path = $skin_path;
					$skin_json_path .= $v;
					$skin_json_path .= '/info.json';
					if(!is_file($skin_json_path)) continue;
					unset($skin_json_path);
					
					$skinInfo = $this->getSkinInfo($v);
					$skinInfo->skin_path = $v;
					
					$skinList[] = $skinInfo;
				}
			}
			
			return $skinList;
		}
		
		public function getSkinInfo($s) {
			
			$skin_json_path = $this->addon_path;
			$skin_json_path .= 'skins/';
			$skin_json_path .= $s;
			$skin_json_path .= '/info.json';
			if(!is_file($skin_json_path)) return array();
		
			$fp = fopen($skin_json_path, "r");
			$fs = filesize($skin_json_path);
			$buff = fread($fp, $fs);
			fclose($fp);
			unset($fs);
			unset($fp);
			unset($skin_json_path);
			
			return json_decode($buff);
		}
	}
}

if(!class_exists('TA_HTMLDisplayHandler')) {
	class TA_HTMLDisplayHandler extends HTMLDisplayHandler {
		function _loadJSCSS()
		{
			$oContext = Context::getInstance();
			$lang_type = Context::getLangType();
			
			if(__DEBUG__ || !__XE_VERSION_STABLE__)
			{
				$oContext->loadFile(array('./common/js/jquery-1.x.js', 'head', 'lt IE 9', -1110000), true);
				$oContext->loadFile(array('./common/js/jquery.js', 'head', 'gte IE 9', -1100000), true);
				$oContext->loadFile(array('./common/js/modernizr.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/x.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/URI.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/blankshield.min.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/common.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/js_app.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/xml2json.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/xml_handler.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/xml_js_filter.js', 'head', '', -1000000), true);
				if(!__DISABLE_DEFAULT_CSS__)
				{
					$oContext->loadFile(array('./common/css/xe.css', '', '', -10000000), true);
				}
				else
				{
					$oContext->unloadFile(array('./common/css/xe.css', '', '', -10000000), true);
				}
			}
			else
			{
				$oContext->loadFile(array('./common/js/jquery-1.x.min.js', 'head', 'lt IE 9', -1110000), true);
				$oContext->loadFile(array('./common/js/jquery.min.js', 'head', 'gte IE 9', -1100000), true);
				$oContext->loadFile(array('./common/js/x.min.js', 'head', '', -1000000), true);
				$oContext->loadFile(array('./common/js/xe.min.js', 'head', '', -1000000), true);
				if(!__DISABLE_DEFAULT_CSS__)
				{
					$oContext->loadFile(array('./common/css/xe.min.css', '', '', -10000000), true);
				}
				else
				{
					$oContext->unloadFile(array('./common/css/xe.min.css', '', '', -10000000), true);
				}
			}
			
			if(Context::get('module') == 'admin' || strpos(Context::get('act'), 'Admin') > 0)
			{
				if(__DEBUG__ || !__XE_VERSION_STABLE__)
				{
					$oContext->loadFile(array('./modules/admin/tpl/js/jquery.tmpl.js', '', '', 1), true);
					$oContext->loadFile(array('./modules/admin/tpl/js/jquery.jstree.js', '', '', 1), true);
					$oContext->loadFile(array("./modules/admin/tpl/css/admin_{$lang_type}.css", '', '', 10), true);
				}
				else
				{					
					$oContext->loadFile(array('./modules/admin/tpl/js/jquery.tmpl.js', '', '', 1), true);
					$oContext->loadFile(array('./modules/admin/tpl/js/jquery.jstree.js', '', '', 1), true);
				}
			}
			
		}
	}
}

if(!$GLOBALS['theme_admin_addon']) $GLOBALS['theme_admin_addon'] = new theme_admin;
$oThemeAdmin = &$GLOBALS['theme_admin_addon'];
if($called_position == 'before_module_proc') {
	// 관리자 페이지 후킹
	if(Context::get('module') == 'admin' || strpos(Context::get('act'), 'Admin') > 0) {
		if($addon_info->skins) {
			$oThemeAdmin->setModuleObject($this); 
			$oThemeAdmin->setInfo($addon_info);
			$oThemeAdmin->applyThemeAdmin();
		}
	}
}

if($called_position == 'before_display_content') {
	// 관리자 페이지 후킹 (Handler 후킹 기능 추가)
	if(Context::get('module') == 'admin' || strpos(Context::get('act'), 'Admin') > 0) {
		$skinInfo = $oThemeAdmin->getSkinInfo($addon_info->skins);
		$oThemeAdmin->setModuleObject($this); 
		$oThemeAdmin->setInfo($addon_info);
		
		// Hook Handler
		if($skinInfo->HookHTMLHandler == true) {
			if(Context::get('xeVirtualRequestMethod') == 'xml') {}
			else if(Context::getRequestMethod() == 'XMLRPC') {}
			else if(Context::getRequestMethod() == 'JSON') {}
			else if(Context::getRequestMethod() == 'JS_CALLBACK') {}
			else $handler = new TA_HTMLDisplayHandler();
		}
		
	}
}

if($called_position == 'after_module_proc') {

	// 설정 페이지 후킹
	if($this->module == 'addon' && $this->act=='dispAddonAdminSetup') {
		if(Context::get('selected_addon') == 'theme_admin') {
			$oThemeAdmin->setModuleObject($this); 
			$oThemeAdmin->setInfo($addon_info);
			$oThemeAdmin->setAdminPage();
		}
	}
}



