<?php

/**
 * Project: Hankookhospital.co.kr.
 * User: Kyeongdae
 * Date: 2015-07-12
 * Time: 오후 11:59
 */
class admin_menuController extends admin_menu {
	public function __construct($error = 0, $message = 'success') {
		if (class_exists('BaseObject')) {
			parent::__construct($error, $message);
		} else {
			parent::Object($error, $message);
		}
	}

	function onAfterModuleProc($arg) {
		if (!$this->isAdminMenuReset($arg))
			return;

		/** @var adminAdminView $adminAdminView */
		$adminAdminView = getAdminView('admin');
		$adminAdminView->makeGnbUrl();

		$adminMenu = $this->findAdminMenu($adminAdminView);
//        $adminGnb  = $this->getContext()->get('gnbUrlList');

		$adminMenuSrl = $adminMenu->menu_srl;
		$dashBoardSrl = $adminMenuSrl + 1;

		/** @var menuAdminController $menuAdminController */
		$menuAdminController = getAdminController('menu');
		$oModuleModel = getModel('module');


		foreach ($this->getConfig() as $module_name => $module) {
			foreach ($module as $menuName) {
				$this->addMenu($oModuleModel, $menuAdminController, $adminMenuSrl, $dashBoardSrl, $module_name, $menuName);
			}
		}
	}


	private function addMenu(moduleModel $oModuleModel, menuAdminController $controller, $adminMenuSrl, $dashBoardSrl, $module_name, $menuName)
	{
		$info = $oModuleModel->getModuleActionXml($module_name);


		$args = new stdClass();
		$args->menu_item_srl = getNextSequence();
		$args->parent_srl = $dashBoardSrl;
		$args->menu_srl = $adminMenuSrl;
		$args->name = sprintf('{$lang->menu_gnb_sub[\'%s\']}', $menuName);
		$args->url =  sprintf("?module=admin&act=%s", $info->admin_index_act);
		$args->open_window = 'N';
		$args->expand = 'N';
		$args->normal_btn = '';
		$args->hover_btn = '';
		$args->active_btn = '';
		$args->group_srls = 1;
		$args->listorder = -1 * $args->menu_item_srl;

		$output = executeQuery('menu.insertMenuItem', $args);
		if (!$output->toBool()) return $output;

		// Update the xml file and get its location
		$controller->makeXmlFile($args->menu_srl);

		return $output;
	}

	/**
	 * @param admin $admin
	 *
	 * @return object
	 */
	private function findAdminMenu(admin $admin) {
		$args = new stdClass();
		$args->title = $admin->getAdminMenuName();

		$row = executeQuery('menu.getMenuByTitle', $args);

		return $row->data;
	}

	private function isAdminMenuReset($arg) {
		return
			$arg->module == 'admin'
			&& $arg->act == 'procAdminMenuReset';
	}
}