var alertify = null;

function empty(mixed_var) {
  var undef, key, i, len;
  var emptyValues = ['undefined', undef, null, false, 0, '', '0'];
  
  for (i = 0, len = emptyValues.length; i < len; i++) {
    if (mixed_var === emptyValues[i]) {
      return true;
    }
  }

  if (typeof mixed_var === 'object') {
    for (key in mixed_var) {
      // TODO: should we check for own properties only?
      //if (mixed_var.hasOwnProperty(key)) {
      return false;
      //}
    }
    return true;
  }

  return false;
}

//

function isInteger(x) {
return Math.round(x) === x;
}

/**
 * Number.prototype.format(n, x)
 * 
 * @param integer n: length of decimal
 * @param integer x: length of sections
 */
Number.prototype.format = function(n, x) {
	if( isInteger(this.valueOf()) )
	{
		var re = '\\d(?=(\\d{' + (x || 3) + '})+$)';
		return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
	}
	else
	{
		n = (n || 5);
		var re = '\\d(?=(\\d{' + (x || 3) + '})+\\.)';
		return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,').replace( /(0*$)/g, '' );
	}
	//return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,').replace( /(^0*)|(0*$)/g, '' );
};
//1234..format();           // "1,234"
//12345..format(2);         // "12,345.00"
//123456.7.format(3, 2);    // "12,34,56.700"
//123456.789.format(2, 4);  // "12,3456.79"

// 문자열 타입에서 쓸 수 있도록 format() 함수 추가
String.prototype.format = function(){
    var num = parseFloat(this);
    if( isNaN(num) ) return "0";
 
    return num.format();
};

//

function arrayKeys(input) {
	var output = new Array();
	var counter = 0;
	for (i in input) {
		output[counter++] = i;
	}
	
	return output; 
}

//

//var colors = ['red','pink','purple','indigo','blue','cyan','teal','green','lime','yellow','amber','orange','brown','grey','black'];
var colors = new Array('blue','teal','orange','purple','indigo','brown','green','pink','lime','cyan','grey','red','blue');

var _GA_mode = null;
var _GACharts_title = null;
var _GACharts = null
var _GAResult = null;
var _GATarget = null;
var _GATarget_value = null;
var $_GACharts = null
var $_GADatatable = null

;(function($){

	$.fn.serializeObject = function() {
		var o = Object.create(null),
			elementMapper = function(element) {
				element.name = $.camelCase(element.name);
				return element;
			},
			appendToResult = function(i, element) {
				var node = o[element.name];

				if ('undefined' != typeof node && node !== null) {
					o[element.name] = node.push ? node.push(element.value) : [node, element.value];
				} else {
					o[element.name] = element.value;
				}
			};

		$.each($.map(this.serializeArray(), elementMapper), appendToResult);
		return o;
	};
	
	//
	
	$.fn.extend({
		getReports: function( params, callback ) {
			_GAResult = null;
			
			try {
				params.module = 'qstatistics';
				params.act = 'getReports';
				
				var _this = $(this);
				
				_this.siblings( '.loader' ).show();
				
				$.ajax({
					type: 'POST',
					dataType: 'json',
					url: request_uri,
					contentType: 'application/json',
					data: $.param(params),
				})
				.done(function( result ) {
					_GAResult = result;
					callback( _this, result );
				})
				.fail(function( jqXHR, textStatus ) {
//console.log(textStatus);
				})
				.always(function( jqXHR, textStatus ) {
//console.log(textStatus);
					_this.siblings( '.loader' ).hide();
				});
			} catch(e) {
				console.error(e);
			} finally {
			}
			
			return this;
		}
	});
	
	//
	
	/*$.shuffle = window.shuffle = function( array ) {
		for(var j, x, i = array.length; i; j = parseInt(Math.random() * i), x = array[--i], array[i] = array[j], array[j] = x);
		return array;
	}
	
	$.objectSort = window.objectSort = function( datas ) {
		var sortable =[];

		$.each(datas, function(index, value){
		});
	}*/

	//
	
	$.drawCharts = window.drawCharts = function( element, result )
	{
		if( empty(_GATarget_value) || (-1 == $.inArray( _GATarget_value, [ 'sessions', 'users', 'newUsers', 'pageviews', 'uniquePageviews' ] )) ) _GATarget_value = 'sessions';
		
		if( !empty(result) ) _GAResult = result;
		if( _GACharts ) _GACharts.destroy();
		$_GADatatable.find( 'tbody' ).empty();
		$_GADatatable.find( 'thead' ).find( '.ga-target' ).html( _GACharts_title );
		
		if( empty(_GAResult.error) ) {
			var labels = [];
			var datasets = [];
			var targets = {};
			var datas = {};
			var sortable = [];
			var max = 0;
			
			var idx = 0;
			
			$.each( _GAResult.reports, function( index, value ) {
				var target = value[ _GATarget ];
				if( -1 == $.inArray( target, arrayKeys( targets ) ) ) {
					targets[ target ] = [];
					
					datas[ target ] = [];
					datas[ target ][ 'sessions' ] = 0;
					datas[ target ][ 'users' ] = 0;
					datas[ target ][ 'newUsers' ] = 0;
					datas[ target ][ 'pageviews' ] = 0;
					datas[ target ][ 'uniquePageviews' ] = 0;
				}
				
				var sessions = new Number( value['sessions'] );
				var users = new Number( value['users'] );
				var newUsers = new Number( value['newUsers'] );
				var pageviews = new Number( value['pageviews'] );
				var uniquePageviews = new Number( value['uniquePageviews'] );
				var GATarget_value = new Number( value[_GATarget_value] );
				
				datas[ target ][ 'sessions' ] += sessions.valueOf();
				datas[ target ][ 'users' ] += users.valueOf();
				datas[ target ][ 'newUsers' ] += newUsers.valueOf();
				datas[ target ][ 'pageviews' ] += pageviews.valueOf();
				datas[ target ][ 'uniquePageviews' ] += uniquePageviews.valueOf();
				
				var date = moment( value['date'] ).format( 'YYYY-MM-DD' );
				if( -1 == $.inArray( date, labels ) ) {
					labels.push( date );
				}
				
				if( 'undefined' === typeof targets[ target ][ date ] ) targets[ target ][ date ] = GATarget_value.valueOf();
				else targets[ target ][ date ] += GATarget_value.valueOf();
			});
			
			$.each( targets, function( index, value ) {
				var total = 0;
				var data = [];
				$.each( labels, function( key, val ) {
					var v = empty(value[val]) ? 0 : parseInt(value[val]);
					data.push( v );
					
					total += v;
					
					if( max < v ) max = v;
				});
				
				datasets.push({
					data: data,
					label: index,
					backgroundColor: colors[idx%colors.length],
					borderColor: colors[idx%colors.length],
					fill: false
				});
				
				idx++;
				
				sortable.push({
					key: index,
					val: total
				});
			});
			
			_GACharts = new Chart(element, {
				type: 'line',
				data: {
					labels: labels,
					datasets: datasets,
				},
				options: {
					legend: { display: true },
					title: {
						display: true,
						text: _GACharts_title
					},
					scales: {
						yAxes: [{
							display: true,
							ticks: {
								//max: Math.floor(max * (1 + (max*0.03))),
								suggestedMin: 0,    // minimum will be 0, unless there is a lower value.
								// OR //
								beginAtZero: true   // minimum value will be 0.
							}
						}]
					},
					responsive: true,
					maintainAspectRatio: false
				}
			});
			
			//
			
			sortable.sort(function (a, b) { 
				return a.val < b.val ? -1 : a.val > b.val ? 1 : 0;  
			});
			
			sortable.reverse();
			
			if( empty(sortable.length) ) $_GADatatable.find('tbody').append( '<tr><td colspan="8" class="text-center">검색된 데이터가 없습니다.</td></tr>' );
			
			idx = 0;
			$.each( sortable, function( index, value ) {
				idx++;
				
				$_GADatatable.find('tbody').append( 
					'<tr>' + 
						'<td class="text-center">' + idx + '</td>' +
						'<td>' + value.key + '</td>' +
						'<td class="text-center sessions">' + datas[ value.key ][ 'sessions' ].format() + '</td>' +
						'<td class="text-center users">' + datas[ value.key ][ 'users' ].format() + '</td>' +
						'<td class="text-center newUsers">' + datas[ value.key ][ 'newUsers' ].format() + '</td>' +
						'<td class="text-center">' + (datas[ value.key ][ 'users' ] - datas[ value.key ][ 'newUsers' ]).format() + '</td>' +
						'<td class="text-center pageviews">' + datas[ value.key ][ 'pageviews' ].format() + '</td>' +
						'<td class="text-center uniquePageviews">' + datas[ value.key ][ 'uniquePageviews' ].format() + '</td>' +
					'</tr>'
				);
			});
			
			$_GADatatable.find('.' + _GATarget_value).addClass( 'ga-value' );
		}
	};
	
	//
	
	$(document).on( 'click', '#ga-target.dTab li > span', function(e) {
		
		var event = e || window.event;
		event.preventDefault();
		if(event.stopPropagation) {
			event.stopPropagation();  // W3C 표준
		}
		else { 
			event.cancelBubble = true; // 인터넷 익스플로러 방식
		}
		event.stopImmediatePropagation();
		
		var _this = $(this);
		
		_this.closest( 'li' ).addClass( 'active' ).siblings().removeClass( 'active' );
		
		_GATarget = _this.data( 'target' );
		_GACharts_title = _this.data( 'title' );
		if( empty(_GACharts_title) ) _GACharts_title = _this.text();
		
		drawCharts( $_GACharts, null );
		
		return false;
	});
	
	// 함수
	
	$(function(){
		//
	});
	
	// 문서준비
	
	$(document).ready(function() {
		//
	});
	
	// 윈도우 로드
	
	$(window).load(function() {
		//
	});
	
	$(window).resize(function() {
		//
	});
	
})(jQuery);
