<?php
/**
 * @class  qstatisticsController
 * @author NHN (developers@xpressengine.com)
 * Controller class of qstatistics module
 */

class qstatisticsController extends qstatistics {

	/**
	 * Initialization
	 *
	 * @return void
	 */
	function init() {}
	
	//
	
	/**
	 * @brief 모듈 핸들러 초기화 후 트리거 (애드온의 before_module_init 에 대응)
	 **/
	function triggerModuleHandlerInitBefore(&$oModule) {
	
		return new Object();
	}
	
	function triggerModuleHandlerInitAfter(&$oModule){
	
		return new Object();
	}
	
	/**
	 * @brief 모듈핸들러 실행 후 트리거 (애드온의 before_module_proc 에 대응)
	 **/
	function triggerModuleHandlerProcBefore(&$oModule) {
		
		return new Object();
	}
	function triggerModuleHandlerProcAfter(&$oModule) {
		
		return new Object();
	}
	
	/**
	* @brief 출력 전 트리거 (애드온의 before_display_content에 대응)
	**/
	function triggerDisplayBefore(&$output){
		$module = Context::get('module');
		
		if( in_array($module, array('admin','manager')) || ('XMLRPC' == Context::getResponseMethod()) || ('JSON' == Context::getResponseMethod()) ) return;
		
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig( $this->module );
		
		if( empty($config->google_analytics_trackingID) ) return;
		
		$tag = <<<EOD
<!-- Global Site Tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=%s"></script>
<script>
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments)};
gtag('js', new Date());

gtag('config', '%s');
</script>

EOD;
		Context::addHtmlHeader( sprintf( $tag, $config->google_analytics_trackingID, $config->google_analytics_trackingID ) );
		
		return new Object();
	}

	function triggerDisplayAfter(&$output){

		return new Object();
	}
	
}
/* End of file qstatistics.controller.php */
/* Location: ./modules/qstatistics/qstatistics.controller.php */
