<?php
/**
 * @class  qstatistics
 * @author NHN (developers@xpressengine.com)
 * high class of the qstatistics module
 */

class qstatistics extends ModuleObject {

	/**
	 * constructor
	 *
	 * @return void
	 */
	function qstatistics() {
	
		if(!Context::isInstalled()) return;
	}

	/**
	 * Implement if additional tasks are necessary when installing
	 *
	 * @return Object
	 */
	function moduleInstall() {

		return new Object();
	}

	/**
	 * a method to check if successfully installed
	 *
	 * @return boolean
	 */
	function checkUpdate() {
		$oDB = DB::getInstance();
		$oModuleModel = getModel('module');
		
		// 트리거 체크
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitBefore', 'before'))   return TRUE;
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitAfter', 'after'))   return TRUE;
		
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcBefore', 'before'))   return TRUE;
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcAfter', 'after'))   return TRUE;
		
		if(!$oModuleModel->getTrigger('display', 'qstatistics', 'controller', 'triggerDisplayBefore', 'before'))   return TRUE;
		if(!$oModuleModel->getTrigger('display', 'qstatistics', 'controller', 'triggerDisplayAfter', 'after'))   return TRUE;
		
		return false;
	}

	/**
	 * Execute update
	 *
	 * @return Object
	 */
	function moduleUpdate() {
		$oDB = DB::getInstance();
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		
		// 트리거 추가
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitBefore', 'before'))
			$oModuleController->insertTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitBefore', 'before');
		if(!$oModuleModel->getTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitAfter', 'after'))
			$oModuleController->insertTrigger('moduleHandler.init', 'qstatistics', 'controller', 'triggerModuleHandlerInitAfter', 'after');
		
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcBefore', 'before'))
			$oModuleController->insertTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcBefore', 'before');
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcAfter', 'after'))
			$oModuleController->insertTrigger('moduleHandler.proc', 'qstatistics', 'controller', 'triggerModuleHandlerProcAfter', 'after');
		
		if(!$oModuleModel->getTrigger('display', 'qstatistics', 'controller', 'triggerDisplayBefore', 'before'))
			$oModuleController->insertTrigger('display', 'qstatistics', 'controller', 'triggerDisplayBefore', 'before');
		if(!$oModuleModel->getTrigger('display', 'qstatistics', 'controller', 'triggerDisplayAfter', 'after'))
			$oModuleController->insertTrigger('display', 'qstatistics', 'controller', 'triggerDisplayAfter', 'after');
		
		return new Object(0, 'success_updated');
	}

	/**
	 * Re-generate the cache file
	 *
	 * @return void
	 */
	function recompileCache() {
	
	}

}
/* End of file qstatistics.class.php */
/* Location: ./modules/qstatistics/qstatistics.class.php */
