<?php
/**
 * @class  qstatisticsAdminController
 * @author NHN (developers@xpressengine.com)
 * qstatistics module of the admin controller class
 */

class qstatisticsAdminController extends qstatistics {

	/**
	 * Initialization
	 * @return void
	 */
	function init() {
		
		if( defined('__TEST__') ) return $this->stop( '테스트 모드에서는 요청한 기능을 사용할 수 없습니다.' );
	}
	
	//
	
	function procQstatisticsAdminConfig()
	{
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig( $this->module );
		
		$oModuleController = getController('module');

		$vars = Context::getRequestVars();
		$vars->google_service_account_key_filename = $config->google_service_account_key_filename;
		
		$keyfile_path = './files/google/service-account/';
		if( !FileHandler::makeDir( $keyfile_path ) ) return new Object (-1, sprintf('msg_not_permitted_create : %s, %s', __FUNCTION__, __LINE__) );
		
		if( empty($vars->google_api_php_client_path) ) $vars->google_api_php_client_path = '';
		if( empty($vars->google_analytics_trackingID) ) $vars->google_analytics_trackingID = '';
		if( empty($vars->google_analytics_viewID) ) $vars->google_analytics_viewID = '';
		
		clearstatcache();
		if( !empty($vars->google_service_account_key_file) && is_uploaded_file($vars->google_service_account_key_file['tmp_name']) && checkUploadedFile($vars->google_service_account_key_file['tmp_name']) )
		{
			$google_service_account_key_filename = md5_file( $vars->google_service_account_key_file['tmp_name'] );
			$vars->google_service_account_key_filename = $keyfile_path . $google_service_account_key_filename;
			@move_uploaded_file( $vars->google_service_account_key_file['tmp_name'], $vars->google_service_account_key_filename );
		}
		
		$vars->layout_srl = $vars->layout_srl ? $vars->layout_srl : NULL;
		$vars->mlayout_srl = $vars->mlayout_srl ? $vars->mlayout_srl : NULL;
		
		$output = $oModuleController->updateModuleConfig($this->module, $vars);

		// default setting end
		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', $vars->module, 'act', 'dispQstatisticsAdminConfig');
		$this->setRedirectUrl($returnUrl);
	}

}
/* End of file qstatistics.admin.controller.php */
/* Location: ./modules/qstatistics/qstatistics.admin.controller.php */
