var alertify = null;

function empty(mixed_var) {
// git : https://github.com/kvz/phpjs/blob/master/functions/var/empty.js
  //  discuss at: http://phpjs.org/functions/empty/
  // original by: Philippe Baumann
  //    input by: Onno Marsman
  //    input by: LH
  //    input by: Stoyan Kyosev (http://www.svest.org/)
  // bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
  // improved by: Onno Marsman
  // improved by: Francesco
  // improved by: Marc Jansen
  // improved by: Rafal Kukawski
  //   example 1: empty(null);
  //   returns 1: true
  //   example 2: empty(undefined);
  //   returns 2: true
  //   example 3: empty([]);
  //   returns 3: true
  //   example 4: empty({});
  //   returns 4: true
  //   example 5: empty({'aFunc' : function () { alert('humpty'); } });
  //   returns 5: false
  
  //if( typeof mixed_var !== "undefined" ) return true;
  
  var undef, key, i, len;
  var emptyValues = ['undefined', undef, null, false, 0, '', '0'];
  
  for (i = 0, len = emptyValues.length; i < len; i++) {
    if (mixed_var === emptyValues[i]) {
      return true;
    }
  }

  if (typeof mixed_var === 'object') {
    for (key in mixed_var) {
      // TODO: should we check for own properties only?
      //if (mixed_var.hasOwnProperty(key)) {
      return false;
      //}
    }
    return true;
  }

  return false;
}

//

;(function($){

	$.setup_plugin = window.setup_plugin = function( _this, plugin, params ) {
	
		try {
			params.module = 'qpay';
			params.act = 'procQpayAdminPluginSetup';
			params.timestamp = new Date().getTime();
			
			$.ajax({
				type: "POST",
				dataType: "json",
				url: request_uri,
				contentType: "application/json",
				data: $.param(params)
			})
			.done(function( result ) {
				if( empty(result.error) ) {
					
					if( empty(result.checked) ) _this.attr( 'value', '' );
					else _this.attr( 'value', plugin );
					_this.prop( 'checked', result.checked );
					alert( '성공적으로 변경되었습니다.' );
					
					return true;
				}
				else {
					alert( result.message );
					
					return false;
				}
			})
			.fail(function( jqXHR, textStatus ) {
			})
			.always(function( jqXHR, textStatus ) {
			});
		} catch(e) {
			console.error(e);
		} finally {
		}
	}
	
	//
	
	$(document).on( 'click', '#qpay-plugins [name="is_pc"]', function(e) {
		
		var _this = $(this);
		
		var title = _this.attr( 'title' );
		var plugin = _this.data( 'plugin' );
		var checked = (_this.val() == plugin) ? 'N' : 'Y';
		
		if( !empty(alertify) ) {
			alertify.confirm( title + '을(를) PC용 결제시 사용하' + (('N' == checked) ? '지않으' : '') + '시겠습니까?',
			function (e) {
				var params = {};
				
				params.is_pc = checked;
				params.plugin = plugin;
				
				setup_plugin( _this, plugin, params );
			},
			function(e) {
			});
		}
		else
		{
			if( confirm( title + '을(를) PC용 결제시 사용하' + (('N' == checked) ? '지않으' : '') + '시겠습니까?' ) ) {
				var params = {};
				
				params.is_pc = checked;
				params.plugin = plugin;
				
				setup_plugin( _this, plugin, params );
			}
		}
		
		return false;
	});
	
	$(document).on( 'click', '#qpay-plugins [name="is_mobile"]', function(e) {
		
		var _this = $(this);
		
		var title = _this.attr( 'title' );
		var plugin = _this.data( 'plugin' );
		var checked = (_this.val() == plugin) ? 'N' : 'Y';
		
		if( !empty(alertify) ) {
			alertify.confirm( title + '을(를) Mobile용 결제시 사용하' + (('N' == checked) ? '지않으' : '') + '시겠습니까?',
			function (e) {
				var params = {};
				
				params.is_mobile = checked;
				params.plugin = plugin;
				
				setup_plugin( _this, plugin, params );
			},
			function(e) {
			});
		}
		else
		{
			if( confirm( title + '을(를) Mobile용 결제시 사용하' + (('N' == checked) ? '지않으' : '') + '시겠습니까?' ) ) {
				var params = {};
				
				params.is_mobile = checked;
				params.plugin = plugin;
				
				setup_plugin( _this, plugin, params );
			}
		}
		
		return false;
	});
	
	//
	
	// 문서준비
	
	$(document).ready(function() {
		//
	});
	
	// 윈도우 로드
	
	$(window).load(function() {
		//
	});
	
	$(window).resize(function() {
		//
	});
	
	// http://cssdesign.kr/forum/viewtopic.php?id=3379
	$(window).scroll(function() {
		//
	});

})(jQuery);
