<?php
/**
 * @class  qpayModel
 * @author NHN (developers@xpressengine.com)
 * @brief Model class of the qpay module
 */

class qpayModel extends qpay {

	/**
	 * Initialization
	 * @return void
	 */
	function init()
	{
	}
	
	function getQpayPaymethod($amounts, $is_free='N')
	{
		$tpl = NULL;
		
		Context::set('amounts', $amounts);
		Context::set('is_free', $is_free);
		
		$logged_info = Context::get('logged_info');
		Context::set('logged_info', $logged_info);
		
		if( Mobile::isMobileCheckByAgent() ) $plugin = $this->getActiveMobilePluginDeposit();
		else $plugin = $this->getActivePCPluginDeposit();
		
		if( !empty($plugin) )
		{
			$extra_vars = unserialize($plugin->extra_vars);
			unset($plugin->extra_vars);
			
			$plugin_info = (object) array_merge( (array) $extra_vars, (array) $plugin );
			Context::set('plugin_info', $plugin_info);
			
			$template_path = sprintf( "%s/plugins/%s/tpl", $this->module_path, $plugin_info->plugin );
			$oTemplate = TemplateHandler::getInstance();
			$tpl = $oTemplate->compile($template_path, 'paymethod');
		}

		if( Mobile::isMobileCheckByAgent() ) $plugin = $this->getActiveMobilePlugin();
		else $plugin = $this->getActivePCPlugin();
		
		if( !empty($plugin) && !(empty($amounts) && ('Y' == $is_free)) )
		{
			$extra_vars = unserialize($plugin->extra_vars);
			unset($plugin->extra_vars);
			
			$plugin_info = (object) array_merge( (array) $extra_vars, (array) $plugin );
			Context::set('plugin_info', $plugin_info);
			
			$template_path = sprintf( "%s/plugins/%s/tpl", $this->module_path, $plugin_info->plugin );
			$oTemplate = TemplateHandler::getInstance();
			$tpl .= $oTemplate->compile($template_path, 'paymethod');
		}
		
		if( (empty($amounts) && ('Y' == $is_free)) )
		{
$script = <<<EOD
<script>
;(function($){
	var _guide_message = '';
	$(document).ready(function() {
		var _guide_message = $( 'input[name="paymethod"]:checked', '.paymethods' ).siblings( 'em' ).html();
		$( '.paymethods' ).siblings( '.guide-message' ).html( _guide_message );
	});
})(jQuery);
</script>
EOD;
		}
		else
		{
$script = <<<EOD
<script>
;(function($){
	var _guide_message = '';
	$(document).on( 'change', '.paymethods input[name="paymethod"]', function(e) {
		var _this = $(this);
		_guide_message = $( 'input[name="paymethod"]:checked', '.paymethods' ).siblings( 'em' ).html();
		_this.closest( '.paymethods' ).siblings( '.guide-message' ).html( _guide_message );
		_this.closest( '.paymethods' ).siblings( '.guide-message' ).find( '[disabled]' ).attr( 'disabled', '' ).prop( 'disabled', false );
	});
	$(document).ready(function() {
		_guide_message = $( '.paymethods' ).siblings( '.guide-message' ).html();
		$( '.paymethods > label' )
		.mouseenter (function () {
			var _this = $(this);
			var msg = _this.find( 'em' ).html();
			_this.closest( '.paymethods' ).siblings( '.guide-message' ).html( msg );
			_this.closest( '.paymethods' ).siblings( '.guide-message' ).find( '[disabled]' ).attr( 'disabled', '' ).prop( 'disabled', false );
		})
		.mouseleave(function () {
			var _this = $(this);
			_this.closest( '.paymethods' ).siblings( '.guide-message' ).html( _guide_message );
			_this.closest( '.paymethods' ).siblings( '.guide-message' ).find( '[disabled]' ).attr( 'disabled', '' ).prop( 'disabled', false );
		});
	});
})(jQuery);
</script>
EOD;
		}
		
		$output = sprintf( '<div class="paymethods">%s</div><div class="guide-message">&nbsp;</div>%s', $tpl, $script );
		return $output;
	}
	
	function getQpayPayForm()
	{
		$logged_info = Context::get('logged_info');
		Context::set('logged_info', $logged_info);
		
		if( Mobile::isMobileCheckByAgent() ) $plugin = $this->getActiveMobilePlugin();
		else $plugin = $this->getActivePCPlugin();
		
		if( empty($plugin) ) return;
		
		$extra_vars = unserialize($plugin->extra_vars);
		unset($plugin->extra_vars);
		
		$plugin_info = (object) array_merge( (array) $extra_vars, (array) $plugin );
		Context::set('plugin_info', $plugin_info);
		
		$template_path = sprintf( "%s/plugins/%s/tpl", $this->module_path, $plugin_info->plugin );
		$oTemplate = TemplateHandler::getInstance();
		$output = $oTemplate->compile($template_path, 'payform');
		
		return $output;
	}
	
	function getQpayResult( $qtransaction_srl )
	{
		$logged_info = Context::get('logged_info');
		Context::set('logged_info', $logged_info);
		
		$args = new stdClass();
		$args->qtransaction_srl = $qtransaction_srl;
		$output = executeQuery('qpay.getTransactionInfo', $args);
		
		$results = unserialize($output->data->results);
		unset($output->data->results);
		
		$results = (object) array_merge( (array) $results, (array) $output->data );
		Context::set('results', $results);
		
		$args = new stdClass();
		$args->plugin = $results->plugin;
		
		if( 'DEPOSIT' == $args->plugin ) $output = executeQuery('qpay.getPluginDepositInfo', $args);
		else $output = executeQuery('qpay.getPluginInfo', $args);
		
		$plugin = $output->data;
		
		if( empty($plugin) ) return;
		
		$extra_vars = unserialize($plugin->extra_vars);
		unset($plugin->extra_vars);
		
		$plugin_info = (object) array_merge( (array) $extra_vars, (array) $plugin );
		Context::set('plugin_info', $plugin_info);
		
		$template_path = sprintf( "%s/plugins/%s/tpl", $this->module_path, $plugin_info->plugin );
		$oTemplate = TemplateHandler::getInstance();
		$output = $oTemplate->compile($template_path, 'result');
		
		return $output;
	}
	
	/**
	 * @brief 
	 */
	function getActivePCPluginDeposit()
	{
		$args = new stdClass();
		$output = executeQuery('qpay.getActivePCPluginDeposit', $args);
		
		return $output->data;
	}

	/**
	 * @brief 
	 */
	function getActiveMobilePluginDeposit()
	{
		$args = new stdClass();
		$output = executeQuery('qpay.getActiveMobilePluginDeposit', $args);
		
		return $output->data;
	}

	/**
	 * @brief 
	 */
	function getActivePCPlugin()
	{
		$args = new stdClass();
		$output = executeQuery('qpay.getActivePCPlugin', $args);
		
		return $output->data;
	}

	/**
	 * @brief 
	 */
	function getActiveMobilePlugin()
	{
		$args = new stdClass();
		$output = executeQuery('qpay.getActiveMobilePlugin', $args);
		
		return $output->data;
	}

	/**
	 * @brief 
	 */
	function getPluginInfo( $plugin )
	{
		$args = new stdClass();
		$args->plugin = $plugin;
		$output = executeQuery('qpay.getPluginInfo', $args);
		
		$extra_vars = unserialize($output->data->extra_vars);
		
		$plugin_info = $this->getPluginInfoXml($plugin, $extra_vars);
		
		return $plugin_info;
	}

	/**
	 * @brief parse xml, retrieve plugin info.
	 **/
	function getPluginInfoXml( $plugin, $values )
	{
		$plugin_info = new stdClass();
		
		$plugin_path = sprintf( "%s/plugins/", $this->module_path, $plugin );
		$xml_file = sprintf( "%s/plugins/%s/info.xml", $this->module_path, $plugin );
		if(!file_exists($xml_file)) return $plugin_info;

		$oXmlParser = new XmlParser();
		$xml = $oXmlParser->loadXmlFile($xml_file);
		$xml_plugin = $xml->plugin;

		if( empty($xml_plugin) ) return $plugin_info;

		$plugin_info->title        = $xml_plugin->title->body;
		$plugin_info->description  = $xml_plugin->description->body;
		$plugin_info->version      = $xml_plugin->version->body;
		$plugin_info->date         = $xml_plugin->date->body;
		$plugin_info->license      = $xml_plugin->license->body;
		$plugin_info->license_link = $xml_plugin->license->attrs->link;
		
		$author_list = array();
		if( is_array($xml_plugin->author) ) $author_list = $xml_plugin->author;
		else array_push( $author_list, $xml_plugin->author );
		
		$plugin_info->author = array();
		foreach( $author_list as $author )
		{
			$obj = new stdClass();
			
			$obj->name          = $author->name->body;
			$obj->email_address = $author->attrs->email_address;
			$obj->homepage      = $author->attrs->link;
			array_push( $plugin_info->author, $obj );
		}

		// 추가 변수 (템플릿에서 사용할 제작자 정의 변수)
		$extra_var_groups = $xml_plugin->extra_vars->group;
		if( empty($extra_var_groups) ) $extra_var_groups = $xml_plugin->extra_vars;
		if( !is_array($extra_var_groups) ) $extra_var_groups = array($extra_var_groups);
		
		$plugin_info->extra_var = new stdClass();
		foreach( $extra_var_groups as $group )
		{
			$extra_vars = $group->var;
			
			if( $extra_vars )
			{
				if( !is_array($extra_vars) ) $extra_vars = array($extra_vars);

				foreach( $extra_vars as $extra_var )
				{
					$name = $extra_var->attrs->name;
					
					$obj = new stdClass();
					$obj->group = $group->title->body;
					$obj->title = $extra_var->title->body;
					$obj->type = $extra_var->attrs->type;
					$obj->default = $extra_var->attrs->default;
					
					if( 'image' == $extra_var->attrs->type && $extra_var->attrs->location ) $obj->location = $extra_var->attrs->location;
					$obj->value = $values->{$name};
					$obj->description = htmlspecialchars($extra_var->description->body, ENT_QUOTES, 'UTF-8');

					$options = $extra_var->options;
					if( $options )
					{
						$thumbnail_exist = false;
						
						if( !is_array($options) ) $options = array($options);
						
						foreach( $options as $option )
						{
							$thumbnail = $option->attrs->src;
							if( $thumbnail )
							{
								$thumbnail = $plugin_path.$thumbnail;
								if( file_exists($thumbnail) )
								{
									$obj->options[$option->attrs->value]->thumbnail = $thumbnail;
									if( empty($thumbnail_exist) )
									{
										$obj->thumbnail_exist = true;
										$thumbnail_exist = true;
									}
								}
							}
							
							$obj->options[$option->attrs->value]->val = $option->title->body;
						}
					}
					
					if( empty($plugin_info->extra_var->{$name}) )
					{
						$plugin_info->extra_var->{$name} = $obj;
					}
					else
					{
						if( is_array($plugin_info->extra_var->{$name}) ) array_push($plugin_info->extra_var->{$name}, $obj);
						else $plugin_info->extra_var->{$name} = array($plugin_info->extra_var->{$name}, $obj);
					}
				}
			}
		}
		
		$plugin_info->plugin = $plugin;
		
		return $plugin_info;
	}

	/**
	 * @brief
	 */
	function getQpayPrePayment()
	{
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header("Cache-Control: no-store");
		header("Pragma: no-cache");

		$extra_vars = Context::getRequestVars();
		unset($extra_vars->error_return_url);
		unset($extra_vars->_filter);
		unset($extra_vars->ruleset);
		
		$oQpayModel = getModel('qpay');

		if( Mobile::isMobileCheckByAgent() ) $plugin = $oQpayModel->getActiveMobilePlugin();
		else $plugin = $oQpayModel->getActivePCPlugin();
		
		$plugin_path = sprintf( "%s/plugins/%s/", $this->module_path, $plugin->plugin );
		
		require_once( $plugin_path . '/' . $plugin->plugin . '.plugin.php' );
		
		$oPlugin = new $plugin->plugin();
		
		$result = $oPlugin->getPrePayment( $extra_vars );
		
		$this->add( 'txt', $result );
	}

}
/* End of file qpay.model.php */
/* Location: ./modules/qpay/qpay.model.php */
