<?php
/**
 * @class  qpayController
 * @author NHN (developers@xpressengine.com)
 * Controller class of qpay module
 */

class qpayController extends qpay {

	/**
	 * Initialization
	 *
	 * @return void
	 */
	function init() {}

	/**
	 * @brief
	 */
	function procQpayPostPayment()
	{
		$vars = Context::getRequestVars();
		unset($vars->error_return_url);
		unset($vars->_filter);
		unset($vars->ruleset);
		
		$oQpayModel = getModel('qpay');
		
		if( Mobile::isMobileCheckByAgent() )
		{
			if( in_array($vars->paymeth, array('DEPOSIT','FREE')) ) $plugin = $oQpayModel->getActiveMobilePluginDeposit();
			else $plugin = $oQpayModel->getActiveMobilePlugin();
		}
		else
		{
			if( in_array($vars->paymeth, array('DEPOSIT','FREE')) ) $plugin = $oQpayModel->getActivePCPluginDeposit();
			else $plugin = $oQpayModel->getActivePCPlugin();
		}
		
		if( empty($plugin) ) return;
		
		$plugin_path = sprintf( "%s/plugins/%s/", $this->module_path, $plugin->plugin );
		
		require_once( $plugin_path . '/' . $plugin->plugin . '.plugin.php' );
		
		$oPlugin = new $plugin->plugin();
		
		$result = $oPlugin->doPayment( $vars );
		
		$this->add( 'result', $result );
	}
	
	/**
	 * @brief
	 */
	function procQpayDepositPayment()
	{
		$vars = Context::getRequestVars();
		unset($vars->error_return_url);
		unset($vars->_filter);
		unset($vars->ruleset);
		
		$oQpayModel = getModel('qpay');
		
		if( Mobile::isMobileCheckByAgent() )
		{
			$plugin = $oQpayModel->getActiveMobilePluginDeposit();
		}
		else
		{
			$plugin = $oQpayModel->getActivePCPluginDeposit();
		}
		
		if( empty($plugin) ) return;
		
		$plugin_path = sprintf( "%s/plugins/%s/", $this->module_path, $plugin->plugin );
		
		require_once( $plugin_path . '/' . $plugin->plugin . '.plugin.php' );
		
		$oPlugin = new $plugin->plugin();
		
		$result = $oPlugin->doPayment( $vars );
		
		$this->add( 'result', $result );
	}
	
	//
	
}
/* End of file qpay.controller.php */
/* Location: ./modules/qpay/qpay.controller.php */
