<?php	
/**
 * @class  qpayAdminView
 * @author NHN (developers@xpressengine.com)
 * qpay module's admin view class
 */

class qpayAdminView extends qpay {

	/**
	 * initialization
	 *
	 * @return void
	 */
	function init() {
		
		$this->setTemplatePath(sprintf("%stpl/",$this->module_path));
		$this->setTemplateFile(strtolower(str_replace('disp'.ucfirst($this->module).'Admin','',$this->act)));
	}

	/**
	 * @brief list transactions.
	 */
	function dispQpayAdminTransactions()
	{
		$vars = Context::getRequestVars();
		
		$args = new stdClass();
		$args->order_type = 'ASC';
		$args->page = empty($vars->page) ? 1 : $vars->page;
		
		$output = executeQuery('qpay.getTransactionList', $args);
		
		Context::set('transactions', $output->data);
		Context::set('total_count', $output->total_count);
		Context::set('total_page', $output->total_page);
		Context::set('page', $output->page);
		Context::set('page_navigation', $output->page_navigation);
	}

	/**
	 * @brief list plugins.
	 */
	function dispQpayAdminPlugins()
	{
		$oQpayModel = getModel('qpay');
		
		$dirs = FileHandler::readDir($this->module_path.'/plugins');
		
		$plugins = array();
		foreach( $dirs as $dir )
		{
			$plugin_info = $oQpayModel->getPluginInfoXml( $dir );
			
			$args = new stdClass();
			$args->plugin = $dir;
			if( 'DEPOSIT' == $args->plugin ) $output = executeQuery('qpay.getPluginDepositInfo', $args);
			else $output = executeQuery('qpay.getPluginInfo', $args);
			
			$extra_vars = unserialize($output->data->extra_vars);
			unset($output->data->extra_vars);
			
			$data = (object) array_merge( (array)$output->data, (array)$extra_vars );
			
			$plugin_info = (object) array_merge( (array)$data, (array)$plugin_info );
			
			array_push( $plugins, $plugin_info );
		}
		
		Context::set('plugins', $plugins);
	}

	/**
	 * @brief plugin setup.
	 */
	function dispQpayAdminPluginInstall()
	{
		$plugin = Context::get( 'plugin' );
		if( empty($plugin) ) return new Object(-1, 'msg_invalid_request');
		
		$oQpayModel = getModel('qpay');
		$plugin_info = $oQpayModel->getPluginInfoXml( $plugin );
		
		$args = new stdClass();
		$args->plugin = $plugin;
		if( 'DEPOSIT' == $args->plugin ) $output = executeQuery('qpay.getPluginDepositInfo', $args);
		else $output = executeQuery('qpay.getPluginInfo', $args);
		
		$extra_vars = unserialize($output->data->extra_vars);
		unset($output->data->extra_vars);
		
		$data = (object) array_merge( (array)$output->data, (array)$extra_vars );
		
		Context::set('plugin_info', (object) array_merge( (array)$data, (array)$plugin_info ));
	}

	function dispQpayAdminDesignSetup()
	{
		$oModuleModel = getModel('module');
		$oLayoutModel = getModel('layout');
		
		$config = $oModuleModel->getModuleConfig( $this->module );
		Context::set('config', $config);
		
		$layout_list = $oLayoutModel->getLayoutList();

		Context::set('layout_list', $layout_list);

		$mlayout_list = $oLayoutModel->getLayoutList(0, 'M');

		Context::set('mlayout_list', $mlayout_list);
	}

}
/* End of file qpay.admin.view.php */
/* Location: ./modules/qpay/qpay.admin.view.php */
