<?php
/**
 * @class  qpayAdminController
 * @author NHN (developers@xpressengine.com)
 * qpay module of the admin controller class
 */

class qpayAdminController extends qpay {

	/**
	 * Initialization
	 * @return void
	 */
	function init() {}

	/**
	 * @brief setup plugin.
	 */
	function procQpayAdminPluginInstall()
	{
		$oQpayModel = getModel('qpay');

		$vars = Context::getRequestVars();
		unset($vars->error_return_url);
		unset($vars->_filter);
		unset($vars->ruleset);
		
		$vars->extra_vars = serialize($vars);
		
		if( 'Y' != $vars->allow_pc ) $vars->is_pc = 'N';
		if( 'Y' != $vars->allow_mobile ) $vars->is_mobile = 'N';
		
		$args = new stdClass();
		$args->plugin = $vars->plugin;
		
		if( 'DEPOSIT' == $args->plugin ) $output = executeQuery('qpay.getPluginDepositInfo', $args);
		else $output = executeQuery('qpay.getPluginInfo', $args);
		
		if( empty($output->data->plugin) || ($output->data->plugin != $vars->plugin) )
		{
			if( 'DEPOSIT' == $vars->plugin ) $output = executeQuery('qpay.insertPluginDeposit', $vars);
			else $output = executeQuery('qpay.insertPlugin', $vars);
		}
		else
		{
			if( 'DEPOSIT' == $vars->plugin ) $output = executeQuery('qpay.updatePluginDeposit', $vars);
			else $output = executeQuery('qpay.updatePlugin', $vars);
		}
		
		if(!$output->toBool()) return $output;
		
		FileHandler::makeDir( sprintf( 'files/qpay/%s/log', $vars->plugin ) );
		
		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module',Context::get('module'), 'act','dispQpayAdminPlugins');
		$this->setRedirectUrl($returnUrl);
	}

	function procQpayAdminPluginSetup()
	{
		//return $this->stop('msg_invalid_request');
		$vars = Context::getRequestVars();
		if( empty($vars->plugin) ) return $this->stop('msg_invalid_request');
		
		$args = new stdClass();
		$args->plugin = $vars->plugin;
		if( 'DEPOSIT' == $args->plugin ) $output = executeQuery('qpay.getPluginDepositInfo', $args);
		else $output = executeQuery('qpay.getPluginInfo', $args);
		
		if( empty($output->data->plugin) || ($output->data->plugin != $vars->plugin) ) return $this->stop('msg_invalid_request');
		
		// begin transaction
		$oDB = DB::getInstance();
		$oDB->begin();
		
		if( 'DEPOSIT' == $vars->plugin ) $table = 'qpay_plugin_deposit';
		else $table = 'qpay_plugins';
		
		if( isset($vars->is_pc) )
		{
			$sql = sprintf( "UPDATE	`%s%s` SET `is_pc`='N' WHERE 1", $oDB->prefix, $table );
		}
		else if( isset($vars->is_mobile) )
		{
			$sql = sprintf( "UPDATE	`%s%s` SET `is_mobile`='N' WHERE 1", $oDB->prefix, $table );
		}
		
		$result = $oDB->_query($sql);
		if($oDB->isError())
		{
			$oDB->rollback();
			$oDB_output = $oDB->getError();
			$oDB_output->setMessage( sprintf('%s %s : %s, %s', $oDB_output->getMessage(), $sql, __FUNCTION__, __LINE__ ) );
			return $oDB_output;
		}
		
		$fields = array(
			'is_pc',
			'is_mobile'
		);
		
		$expression = array();
		foreach( $fields as $field )
		{
			if( isset($vars->{$field}) && $oDB->isColumnExists( $table, $field ) ) $expression[] = sprintf( "`%s`='%s'", $field, addslashes($vars->{$field}) );
		}
		if( empty($expression) ) return $this->stop('msg_invalid_request');
		
		$sql = sprintf( "UPDATE	`%s%s` SET %s WHERE `plugin`='%s'", $oDB->prefix, $table, implode(', ', $expression), $vars->plugin );
		$result = $oDB->_query($sql);
		if($oDB->isError())
		{
			$oDB->rollback();
			$oDB_output = $oDB->getError();
			$oDB_output->setMessage( sprintf('%s %s : %s, %s', $oDB_output->getMessage(), $sql, __FUNCTION__, __LINE__ ) );
			return $oDB_output;
		}
		
		// commit
		$oDB->commit();
		
		$this->add('checked', (('Y'==$vars->is_pc) || ('Y'==$vars->is_mobile)) ? TRUE : FALSE);
		$this->add('plugin', $vars->plugin);
		
		return $output;
	}

	function procQpayAdminDesignSetup()
	{
		$oModuleController = getController('module');

		$vars = Context::getRequestVars();
		
		$vars->layout_srl = $vars->layout_srl ? $vars->layout_srl : NULL;
		$vars->mlayout_srl = $vars->mlayout_srl ? $vars->mlayout_srl : NULL;
		
		$output = $oModuleController->updateModuleConfig($this->module, $vars);

		// default setting end
		$this->setMessage('success_updated');

		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', $vars->module, 'act', 'dispQpayAdminPlugins');
		$this->setRedirectUrl($returnUrl);
	}

}
/* End of file qpay.admin.controller.php */
/* Location: ./modules/qpay/qpay.admin.controller.php */
