<?php

class DEPOSIT {

	var $plugin_info = NULL;
	
	function pluginInstall() 
	{
	}

	function DEPOSIT()
	{
		$this->init();
	}

	function init()
	{
		$args = new stdClass();
		$args->plugin = 'DEPOSIT';
		$output = executeQuery('qpay.getPluginDepositInfo', $args);
		
		$extra_vars = unserialize($output->data->extra_vars);
		unset($output->data->extra_vars);
		
		$data = (object) array_merge( (array)$output->data, (array)$extra_vars );
		
		$this->plugin_info = (object) array_merge( (array)$data, (array)$plugin_info );
	}

	function getPrePayment( &$vars )
	{
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header("Cache-Control: no-store");
		header("Pragma: no-cache");
	}
	
	function doPayment( &$vars )
	{
		$logged_info = Context::get( 'logged_info' );
		
		$vars->status = 1;
		if( empty($vars->qorder_srl) ) $vars->qorder_srl = getNextSequence();
		
		$results = new stdClass();
		$results->fails = array();
		
		$time = microtime(TRUE);
		$ordr_idxx                = $time;
		
		$results->orderid         = $ordr_idxx;            // 쇼핑몰 주문번호
		$results->pay_method      = $vars->paymethod;      // 결제방식
		
		$results->result_code     = '0000';                // 결과 코드
		$results->result_message  = '정상처리';            // 결과 메시지
		
		$results->etime = mktime( 23, 59, 59, date('n', strtotime( '+2 days' )), date('j', strtotime( '+2 days' )), date('Y', strtotime( '+2 days' )) );
		
		$results->db_success = TRUE; // DB 작업 실패 또는 금액 불일치의 경우 "false" 로 세팅
		
		$args = (object) array_merge( (array) $vars, (array) $results );
		
		$args->qtransaction_srl = getNextSequence();
		$args->list_order = $args->qtransaction_srl * -1;
		
		$args->member_srl = $logged_info->member_srl;
		$args->plugin = $this->plugin_info->plugin;
		$args->mode = $this->plugin_info->service_mode;
		
		$args->params = serialize($vars);
		$args->results = serialize($results);
		
		$args->useragent = $_SERVER['HTTP_USER_AGENT'];

		$browser = new Browser();
		$args->platform = $browser->getPlatform();
		$args->browser = $browser->getBrowser();
		
		if( empty($args->amounts) ) $args->status = 65535;
		
		$output = executeQuery('qpay.insertTransaction', $args);
		
		if(!$output->toBool())
		{
			$results->db_success = FALSE;
		}
		
		if( empty($results->db_success) )
		{
			$args->etime = time();
			$args->is_expired = 'Y';
			$args->status = 2;
			
			$output = executeQuery('qpay.updateTransaction', $args);
		}
		
		return $args;
	}

}
/* End of file payplus6.plugin.php */
/* Location: ./modules/epay/plugins/payplus6/payplus6.plugin.php */
