<?php

class voteextendAdminController extends voteextend
{
	
	function init()
	{
		
	}
	
	function isAdmin()
	{
		$logged_info = Context::get('logged_info');
		if($logged_info->is_admin!=='Y') return new Object(-1, 'msg_invalid_request');
	}
	
	function redirectIndex()
	{
		$this->setRedirectUrl(getNotEncodedUrl('','module','admin','act','dispVoteextendAdminIndex')); 
	}
	
	function procVoteextendAdminSetup()
	{
		$this->isAdmin();
		
		$oModuleModel = getModel('module');
		
		$args = Context::getRequestVars();
		$args->module = 'voteextend';
		$args->module_srl = $oModuleModel->getModuleSrlByMid($args->module);
		$output = getController('module')->insertModuleConfig('voteextend', $args);
		
		$this->redirectIndex(); 
	}
	
	function procVoteextendAdminDeleteVote()
	{
		$this->isAdmin();
		
		$type = Context::get('type');
		if(!$type) return new Object(-1, '타입을 입력해주세요');
			
		$args = new stdClass();
		$args->type = $type;
		$output = executeQuery('voteextend.deleteVote', $args);
		if(!$output->toBool()) return $output;
		
		$args = new stdClass();
		$args->type = $type;
		$output = executeQuery('voteextend.deleteVoteTable', $args);
		if(!$output->toBool()) return $output;
		
		$this->redirectIndex(); 
	}
	
	function procVoteextendAdminAddVote()
	{
		$this->isAdmin();
		
		$label = Context::get('label');
		if(!$label) return new Object(-1, '라벨을 입력해주세요');
		
		$type = Context::get('type');
		if(!$type) return new Object(-1, '타입을 입력해주세요');
		
		$args = new stdClass();
		$args->vote_srl = getNextSequence();
		$args->type = $type;
		$args->label = $label;
		$output = executeQuery('voteextend.insertVoteList', $args);
		if(!$output->toBool()) return $output;
		
		$this->redirectIndex(); 
	}
	
}