<?php

class voteextendController extends voteextend
{

	function init()
	{
	}

	function getConfigs($config_name, $module)
	{
		$oModuleModel = getModel('module');
		$this->config = $oModuleModel->getModuleConfig($module);
		Context::set($config_name,$this->config);
	}

	function isVoted($document_srl, $member_srl, $req_set)
	{
		$args = new stdClass();
		$args->member_srl = $member_srl;
		$args->document_srl = $document_srl;
		
		$output = executeQuery('voteextend.getDocumentVotedLogInfo', $args);
		return $output;
	}
	
	function isExistVoteTable($type)
	{
		$args = new stdClass();
		$args->type = $type;
		$output = executeQuery('voteextend.getVoteExtendCount', $args);
		
		return $output;
	}
	
	function isExtendVoted($document_srl, $member_srl, $type)
	{
		$args = new stdClass();
		$args->document_srl = $document_srl;
		$args->type = $type;
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.getVotedExistCount', $args);
		return $output;
	}
	
	function isExtendVotedWithoutType($document_srl, $member_srl)
	{
		$args = new stdClass();
		$args->document_srl = $document_srl;
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.getVotedExistCountwithoutType', $args);
		return $output;
	}
	
	function updateExtendVotedCount($document_srl, $voted_count, $type)
	{
		$args = new stdClass();
		$args->type = $type;
		$args->document_srl = $document_srl;
		$args->voted_count = $voted_count;
		
		$output = executeQuery('voteextend.updateVotedCount', $args);
		return $output;
	}
	
	function insertExtendVotedLog($document_srl, $member_srl, $voted_count, $type)
	{
		$args = new stdClass();
		$args->vote_srl = getNextSequence();
		$args->document_srl = $document_srl;
		$args->voted_count = $voted_count;
		$args->type = $type;
		$args->ipaddress = $_SERVER['REMOTE_ADDR'];
		$args->regdate = date('YmdHis');
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.insertVotedLog', $args);
		return $output;
	}
	
	function triggerProcess($oDocument, $voted_count, $point)
	{
		$oDB = DB::getInstance();
		$oDB->begin();
			
		$obj = new stdClass;
		$obj->member_srl = $oDocument->get('member_srl');
		$obj->module_srl = $oDocument->get('module_srl');
		$obj->document_srl = $oDocument->get('document_srl');
		$obj->update_target = 'voted_count';
		$obj->point = $point;
		$obj->before_point = $oDocument->get('voted_count');
		$obj->after_point = $voted_count;
		$trigger_output = ModuleHandler::triggerCall('document.updateVotedCount', 'after', $obj);
		if(!$trigger_output->toBool())
		{
			$oDB->rollback();
			return FALSE;
		}

		$oDB->commit();
	}
	
	function resetCache($document_srl, $voted_count)
	{
		$oCacheHandler = CacheHandler::getInstance('object');
		if($oCacheHandler->isSupport())
		{
			$cache_key = 'document_item:'. getNumberingPath($document_srl) . $document_srl;
			$oCacheHandler->delete($cache_key);
		}

		$_SESSION['voted_document'][$document_srl] = true;
	}
	
	function updateVotedCount($document_srl, $member_srl, $oDocument, $point)
	{
		$args = new stdClass;
		$args->document_srl = $document_srl;
		$args->member_srl = $member_srl;
		$args->voted_count = $oDocument->get('voted_count') + $point;
		
		$output = executeQuery('document.updateVotedCount', $args);
		return $output;
	}
	
	function insertDocumentVotedLog($document_srl, $member_srl, $oDocument, $point)
	{
		$args = new stdClass;
		$args->document_srl = $document_srl;
		$args->member_srl = $member_srl;
		$args->point = $point;
		
		$output = executeQuery('document.insertDocumentVotedLog', $args);
		return $output;
	}
	
	function insertExtendVoteTable($document_srl, $type)
	{
		$args = new stdClass();
		$args->type = $type;
		$args->document_srl = $document_srl;
		
		$output = executeQuery('voteextend.insertVoteTable', $args);
		return $output;
	}
	
	function procVoteextendUserVote()
	{
		$logged_info = Context::get('logged_info');
		if(!$logged_info) return new Object(-1, '로그인 후 추천가능합니다.');
		
		$member_srl = $logged_info->member_srl ? $logged_info->member_srl : 0;
		$document_srl = Context::get('document_srl');
		$type = Context::get('type');
		
		$this->module_id = 'voteextend';
		$this->getConfigs('config', $this->module_id);
		$req_set = Context::get('config');
		
		$output = $this->isVoted($document_srl, $member_srl, $req_set);
		if(!$output->toBool()) return $output;
		if($req_set->usedef == 1 && $output->data->count > 0)
		{
			return new Object(-1, '이미 추천하셨습니다.');
		}
		
		$output = $this->isExistVoteTable($type);
		if(!$output->toBool()) return $output;
		if($output->data->count === 0) return new Object(-1, '허용되지 않은 접근입니다.');
		
		$output = $this->isExtendVoted($document_srl, $member_srl, $type);
		if(!$output->toBool()) return $output;
		if($output->data->count > 0) return new Object(-1, '이미 추천하셨습니다.');
		
		$output = $this->isExtendVotedWithoutType($document_srl, $member_srl);
		if(!$output->toBool()) return $output;
		if($output->data->count > 0) return new Object(-1, '이미 추천하셨습니다.');
		
		
		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl);
		$module_srl = $oDocument->get('module_srl');
		
		if($oDocument->get('member_srl')==$member_srl && $logged_info->is_admin=='N') return new Object(-1, '자신의 글에 추천할 수 없습니다.');
		if(!$module_srl) return new Object(-1, '모듈을 찾을 수 없습니다.');
		if(!$oDocument->isExists()) return new Object(-1, '문서가 존재하지 않습니다.');
		
		$args = new stdClass();
		$args->type = $type;
		$args->document_srl = $document_srl;
		$output = executeQuery('voteextend.getVotedListCount', $args);
		if(!$output->toBool()) return $output;
		
		if($output->data->count === 0 || !($output->data->count))
		{
			$ouptut = $this->insertExtendVoteTable($document_srl, $type);
			if(!$output->toBool()) return $output;
			
			$voted_count = 0;
		}
		else
		{
			$args = new stdClass();
			$args->type = $type;
			$args->document_srl = $document_srl;
			$output = executeQuery('voteextend.getVotedList', $args);
			if(!$output->toBool()) return $output;

			$voted_count = $output->data->voted_count;
		}
		
		$voted_count = $voted_count + 1;
		
		$output = $this->updateExtendVotedCount($document_srl, $voted_count, $type);
		if(!$output->toBool()) return $output;
		
		$output = $this->insertExtendVotedLog($document_srl, $member_srl, $voted_count, $type);
		if(!$output->toBool()) return $output;
		
		if($req_set->usevote == 1)
		{
			$point = 1;
			
			$oDocumentModel = getModel('document');
			$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
			
			$output = $this->updateVotedCount($document_srl, $member_srl, $oDocument, $point);
			if(!$output->toBool()) return $output;
			
			$output = $this->insertDocumentVotedLog($document_srl, $member_srl, $oDocument, $point);
			if(!$output->toBool()) return $output;
			
			$trigger = $this->triggerProcess($oDocument, $args->voted_count, $point);
			if($trigger === FALSE) return new Object(-1, '트리거를 실패하였습니다.');
				
			$this->resetCache($document_srl, $voted_count);
		}
		
		$this->add('voted_count',$voted_count);
		$this->add('type',$type);
	}
	
}