<?php

class voteextendController extends voteextend
{

	function init()
	{
	}

	function isDefVoted($member_srl, $document_srl)
	{
		$args = new stdClass();
		$args->member_srl = $member_srl;
		$args->document_srl = $document_srl;
		
		$output = executeQuery('voteextend.getDocumentVotedLogInfo', $args);
		if(!$output->toBool()) return $output;
		
		return $output->data->count;
	}
	
	function getConfigs($config_name, $module)
	{
		$oModuleModel = getModel('module');
		$this->config = $oModuleModel->getModuleConfig($module);
		Context::set($config_name,$this->config);
	}

	function procVoteextendUserVote()
	{
		$logged_info = Context::get('logged_info');
		$member_srl = $logged_info->member_srl ? $logged_info->member_srl : 0;
		$document_srl = Context::get('document_srl');
		$type = Context::get('type');
		
		if(!$logged_info) return new Object(-1, 'msg_invalid_request');
		
		$this->module_id = 'voteextend';
		$this->getConfigs('config', $this->module_id);
		$req_set = Context::get('config');
		
		$defVoted = $this->isDefVoted($document_srl, $member_srl);
		if($req_set->usedef == 1 && $defVoted > 0)
		{
			return new Object(-1, '이미 추천하셨습니다.');
		}
		
		$args = new stdClass();
		$args->type = $type;
		
		$output = executeQuery('voteextend.getVoteExtendCount', $args);
		if(!$output->toBool()) return $output;
		if($output->data->count === 0) return new Object(-1, 'msg_invalid_request');
		
		
		$args = new stdClass();
		$args->document_srl = $document_srl;
		$args->type = $type;
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.getVotedExistCount', $args);
		if(!$output->toBool()) return $output;
		if($output->data->count > 0) return new Object(-1, '이미 추천하셨습니다.');
		
		
		$args = new stdClass();
		$args->document_srl = $document_srl;
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.getVotedExistCountwithoutType', $args);
		if(!$output->toBool()) return $output;
		if($output->data->count > 0) return new Object(-1, '이미 추천하셨습니다.');
		
		
		$oDocumentModel = getModel('document');
		$oDocument = $oDocumentModel->getDocument($document_srl);
		
		$module_srl = $oDocument->get('module_srl');
		if(!$module_srl) return new Object(-1, 'msg_invalid_request');
		if(!$oDocument->isExists() || $oDocument == null || !$oDocument->isGranted()) return new Object(-1, 'msg_invalid_request');
		
		$args = new stdClass();
		$args->type = $type;
		$args->document_srl = $document_srl;
		
		$output = executeQuery('voteextend.getVotedListCount', $args);
		if(!$output->toBool()) return $output;
		
		if($output->data->count === 0){
			
			$args = new stdClass();
			$args->type = $type;
			$args->document_srl = $document_srl;
			
			$output = executeQuery('voteextend.insertVoteTable', $args);
			if(!$output->toBool()) return $output;
			
			$voted_count = 0;
		}else{
			
			$args = new stdClass();
			$args->type = $type;
			$args->document_srl = $document_srl;
			
			$output = executeQuery('voteextend.getVotedList', $args);
			if(!$output->toBool()) return $output;

			$voted_count = $output->data->voted_count;
		}
		
		$voted_count = $voted_count+1;
		
		$args = new stdClass();
		$args->type = $type;
		$args->document_srl = $document_srl;
		$args->voted_count = $voted_count;
		
		$output = executeQuery('voteextend.updateVotedCount', $args);
		if(!$output->toBool()) return $output;

		
		$args = new stdClass();
		$args->vote_srl = getNextSequence();
		$args->document_srl = $document_srl;
		$args->voted_count = $voted_count;
		$args->type = $type;
		$args->ipaddress = $_SERVER['REMOTE_ADDR'];
		$args->regdate = date('YmdHis');
		$args->member_srl = $member_srl;
		
		$output = executeQuery('voteextend.insertVotedLog', $args);
		if(!$output->toBool()) return $output;
		
		if($req_set->usevote == 1)
		{
			$point = 1;
			
			$oDB = DB::getInstance();
			$oDB->begin();
		
			$oDocumentModel = getModel('document');
			$oDocument = $oDocumentModel->getDocument($document_srl, false, false);
			
			$args = new stdClass;
			$args->document_srl = $document_srl;
			$args->member_srl = $member_srl;
			$args->voted_count = $oDocument->get('voted_count') + $point;
			$output = executeQuery('document.updateVotedCount', $args);
			if(!$output->toBool()) return $output;
			
			$args->point = $point;
			$output = executeQuery('document.insertDocumentVotedLog', $args);
			if(!$output->toBool()) return $output;
			
			$obj = new stdClass;
			$obj->member_srl = $oDocument->get('member_srl');
			$obj->module_srl = $oDocument->get('module_srl');
			$obj->document_srl = $oDocument->get('document_srl');
			$obj->update_target = 'voted_count';
			$obj->point = $point;
			$obj->before_point = $oDocument->get('voted_count');
			$obj->after_point = $args->voted_count;
			$trigger_output = ModuleHandler::triggerCall('document.updateVotedCount', 'after', $obj);
			if(!$trigger_output->toBool())
			{
				$oDB->rollback();
				return $trigger_output;
			}

			$oDB->commit();
			
			$oCacheHandler = CacheHandler::getInstance('object');
			if($oCacheHandler->isSupport())
			{
				$cache_key = 'document_item:'. getNumberingPath($document_srl) . $document_srl;
				$oCacheHandler->delete($cache_key);
			}

			$_SESSION['voted_document'][$document_srl] = true;

			$output = new Object();
			$output->add('voted_count', $obj->after_point);
			
			return $output;
		}
		else
		{
			$this->add('voted_count',$voted_count);
		}
	}
	
}