<?php

class voteextendAdminController extends voteextend
{
	function init()
	{
		
	}
	
	function isAdmin()
	{
		$logged_info = Context::get('logged_info');
		if($logged_info->is_admin!=='Y') return new Object(-1, 'msg_invalid_request');
	}
	
	function procVoteextendAdminSetup()
	{
		$this->isAdmin();
		
		$oModuleModel = getModel('module');
		
		$args = Context::getRequestVars();
		$args->module = 'voteextend';
		$args->module_srl = $oModuleModel->getModuleSrlByMid($args->module);

		$output = getController('module')->insertModuleConfig('voteextend', $args);
		
		$this->setRedirectUrl(getNotEncodedUrl('','module','admin','act','dispVoteextendAdminIndex')); 
	}
	
	function procVoteextendAdminDeleteVote()
	{
		$this->isAdmin();
		
		$type = Context::get('type');
		
		$args = new stdClass();
		$args->type = $type;
		
		$output = executeQuery('voteextend.deleteVote', $args);
		if(!$output->toBool()) return $output;
		
		$args = new stdClass();
		$args->type = $type;
		
		$output = executeQuery('voteextend.deleteVoteTable', $args);
		if(!$output->toBool()) return $output;
		
		$this->setRedirectUrl(getNotEncodedUrl('','module','admin','act','dispVoteextendAdminIndex')); 
	}
	
	function procVoteextendAdminAddVote()
	{
		$this->isAdmin();
		
		$label = Context::get('label');
		$type = Context::get('type');
		
		$args = new stdClass();
		$args->vote_srl = getNextSequence();
		$args->type = $type;
		$args->label = $label;
		
		$output = executeQuery('voteextend.insertVoteList', $args);
		if(!$output->toBool()) return $output;
		
		$this->setRedirectUrl(getNotEncodedUrl('','module','admin','act','dispVoteextendAdminIndex')); 
	}
	
}