<?php

class etorrent extends ModuleObject
{
	public function getConfig()
	{
		$oModuleModel = getModel('module');
		$config = $oModuleModel->getModuleConfig('etorrent');
		if(!is_object($config)) $config = new stdClass();
		if(!$config->skin) $config->skin = 'default';
		if(!is_array($config->mid_list)) $config->mid_list = array();
		return $config;
	}
	public function moduleInstall()
	{
		return new object();
	}
	public function checkUpdate()
	{
		return FALSE;
	}
	public function triggerAfterModuleProc($oModule)
	{
		if($oModule->module_info->module=='admin') return;
		static $loaded = 0;
		if($loaded) return;
		$loaded = 1;

		// view 화면만 가능.
		if(strpos($oModule->act, 'disp')!==0) return;
		if(in_array($oModule->act, array('dispBoardWrite','dispWidgetAdminAddContent'))) return;

		$oDocument = Context::get('oDocument');
		if(!is_object($oDocument) || !$oDocument->document_srl) return;

		$uploaded_files = (array)$oDocument->getUploadedFiles();
		if(!count($uploaded_files)) return;

		$config = $this->getConfig();
		if(count($config->mid_list) && !in_array($oModule->mid, $config->mid_list)) return;
		Context::set('config', $config);
		$skin = $config->skin;

		$torrent_content = '';
		$load_files = array();
		$image_auto_insert = FALSE;
		foreach($uploaded_files as $file_info)
		{
			// 본문에 삽입될 torrent 내용
			if(preg_match('/\.torrent$/i', $file_info->source_filename))
			{
				include_once(dirname(__FILE__).'/libs/Torrent.php');
				$filename = _XE_PATH_ . $file_info->uploaded_filename;
				$torrent = new Torrent($filename);
				/*
				ob_start();
				?>
				<div class="eTorrent">
					<h3 class="title"><a href="<?php echo getUrl().$file_info->download_url; ?>"><?php echo htmlspecialchars($file_info->source_filename); ?></a></h3>
					<div class="content">
						<ol><?php
							foreach($torrent->content() as $name => $size)
							{
								echo '<li>';
								echo htmlspecialchars($name);
								echo sprintf(' <sup>%s</sup>', static::formatBytes($size));
								echo '</li>';
							}
						?></ol>
					</div>
				</div>
				<?php
				$torrent_content .= ob_get_clean();
				*/
				$torrent->creation_date = $torrent->{'creation date'};
				Context::set('file_info', $file_info);
				Context::set('torrent', $torrent);
				$oTemplate = &TemplateHandler::getInstance();
				$torrent_content .= $oTemplate->compile($this->module_path."skins/$skin", 'skin');
			}
			// 자동 삽입할 이미지가 있는지 검사
			if(!$image_auto_insert && $config->auto_image && preg_match('/\.(jpe?g|png|gif)$/i', $file_info->source_filename))
			{
				$image_auto_insert = TRUE;
			}
		}

		// 위젯 캐싱 위해 load_files 변수로 넘겨진 것을 처리함.
		$load_files = array_unique(Context::get('load_files'));
		foreach($load_files as $val)
		{
			if(preg_match('/\.js/i', $val))
			{
				Context::addJsFile($val, FALSE, '', 0, 'body');
			}
			else
			{
				Context::addCssFile($val);
			}
		}

		// 첨부 이미지 자동 삽입
		$image_content = '';
		if($config->auto_image && $image_auto_insert)
		{
			$images = array();

			// 본문 첨부된 이미지들을 주소만 파싱하여 $images 배열에 넣어두기
			if(preg_match_all('/<img[^>]*?[\s\t\r\n]src[\s\t]*=([\'"])([^\'">]*)\1(?:[^>]*)>/i', $oDocument->get('content'), $matches))
			{
				foreach($matches[2] as $img_src)
				{
					// Context::pathToUrl(_XE_PATH_)
					$images[] = str_replace(getUrl(), '', $img_src);
				}
			}
			// 첨부파일 목록에서 본문 삽입할 이미지들을 가려내서 변수에 넣어두기
			foreach($uploaded_files as $file_info)
			{
				// 현재 파일이 이미지가 아니면 패스.
				if(!preg_match('/\.(jpe?g|png|gif)$/i', $file_info->uploaded_filename)) continue;

				// 첨부 파일 경로에서 ./ 제거
				$uploaded_filename = preg_replace('#^\./#', '', $file_info->uploaded_filename);

				// 첨부파일이 본문에 삽입 되어 있다면 패스
				if(in_array($uploaded_filename, $images)) continue;

				$image_content .= sprintf(
					'<div class="auto_insert" style="text-align:center"><img src="%s" alt="%s" /></div>'
					,htmlspecialchars(getUrl().$uploaded_filename)
					,htmlspecialchars($file_info->source_filename)
				);
			}
		}

		$oDocument->add('content', $image_content . $oDocument->get('content') . $torrent_content);
	}

	/*function triggerBeforeProcFileDownload($obj)
	{
		if(!preg_match('/\.torrent$/i', $obj->source_filename)) return;
		$logged_info = Context::get('logged_info');
		if($logged_info->is_admin=='Y' || ($logged_info->member_srl && $logged_info->member_srl == $obj->member_srl)) return;
		if($o

		return new object(-1);
	}*/

	function triggerAfterProcFileDownload($obj)
	{
		// file_srl 값을 기록
		if(!$obj->file_srl) return;
		$file_srl = $obj->file_srl;

		// torrent 파일만 기록
		if(!preg_match('/\.torrent$/i', $obj->source_filename)) return;

		// 자기자신이 첨부파일 받는 경우 패스
		$logged_info = Context::get('logged_info');
		if(is_object($logged_info) && $logged_info->member_srl == $obj->member_srl) return;


		if(/*(!is_object($logged_info) || !$logged_info->member_srl) && */isCrawler()) return;
		//if(!__DEBUG__) return;

		/*
		if($obj->upload_target_type!='COM')
		{
			$oDocumentModel = &getModel('document');
			$oDocument = $oDocumentModel->getDocument($obj->upload_target_srl, FALSE, FALSE);
			// 존재하지 않는 글 or 임시저장글
			if($oDocument->isExists() && $oDocument->get('member_srl') == $oDocument->get('module_srl')) return;
			$document_srl = $oDocument->document_srl;
		}
		if(!isset($document_srl))
		{
			$oCommentModel = getModel('comment');
			$oComment = $oCommentModel->getComment($obj->upload_target_srl);
			if(is_object($oComment))
			{
				$document_srl = $oComment->get('document_srl');
			}
		}
		if(!isset($file_srl) || !$file_srl) return;
		*/

		if(!isset($_SESSION[__FILE__])) $_SESSION[__FILE__] = array();
		if(!in_array($file_srl, $_SESSION[__FILE__]))
		{
			$_SESSION[__FILE__][] = $file_srl;
			$args = new stdClass();
			$args->file_srl = $file_srl;
			$args->regdate = date('ymdHi');
			$args->module_srl = $obj->module_srl;
			$args->document_srl = $obj->upload_target_srl;

			//$args->module_srl = $oDocument->get('module_srl');
			executeQuery('etorrent.insertDownloadLog', $args);
		}
	}
	// http://stackoverflow.com/questions/2510434/format-bytes-to-kilobytes-megabytes-gigabytes
	static function formatBytes($size, $precision = 2)
	{
		$base = log($size, 1024);
		$suffixes = array('B', 'KB', 'MB', 'GB', 'TB');

		return round(pow(1024, $base - floor($base)), $precision) .' '. $suffixes[floor($base)];
	}

	public function moduleUpdate()
	{
		return $this->moduleInstall();
	}
	/*
	final public function moduleUninstall()
	{
		return new object();
	}

	final public function recomplieCache()
	{
	}
	*/
}
