<?php
class blindController extends blind
{
	public function init()
	{
		$logged_info = Context::get('logged_info');
		if(!is_object($logged_info) || !$logged_info->member_srl)
		{
			return $this->stop('로그인 후 이용하실 수 있습니다.');
		}

		// 보안 처리
		if(!in_array(Context::getRequestMethod(),array('JSON'), 'XMLRPC'))
		{
			return $this->stop('잘못된 요청입니다.');
		}
	}
	public function procBlindInsert()
	{
		$logged_info = Context::get('logged_info');
		$target_srl = Context::get('target_srl');
		$oMemberModel = getModel('member');
		$member_info = $oMemberModel->getMemberInfoByMemberSrl($target_srl);
		if(!is_object($member_info) || !$member_info->member_srl)
		{
			return $this->stop('회원 정보가 존재하지 않습니다');
		}

		$args = new stdClass();
		$args->target_member_srl = $member_info->member_srl;
		$args->member_srl = $logged_info->member_srl;

		// 이미 등록된 경우 삭제
		$output = executeQueryArray('blind.getBlind', $args);
		if(count($output->data))
		{
			$output = executeQuery('blind.deleteBlind', $args);
			return new object(0, '해당 회원을 블라인드 취소 하였습니다.');
		}

		$oBlind = getClass('blind');
		$config = $oBlind->config();
		if($config->max_blind <= $oBlind->blidCount())
		{
			return $this->stop('더 이상 블라인드 추가할 수 없습니다.');
		}

		$args->regdate = time();

		$output = executeQuery('blind.insertBlind', $args);
		if($output->error)
		{
			return $this->stop($output->message);
		}

		$this->setMessage('해당 회원이 블라인드 처리 되었습니다.');
	}
}
