<?php

class blind extends ModuleObject
{
	static function quit($url)
	{
		header("Location: $url");
		exit;
	}

	public function config()
	{
		$oModuleModel = getModel('module');
		$config = new stdClass();
		$config->status = $oModuleModel->getTrigger('moduleHandler.proc', 'blind', 'class', 'triggerModuleProc', 'after');
		$config->trigger_before = $oModuleModel->getTrigger('member.getMemberMenu', 'blind', 'class', 'triggerMemberMenu', 'before');
		$config->trigger_after = $oModuleModel->getTrigger('member.getMemberMenu', 'blind', 'class', 'triggerMemberMenu', 'after');

		$_config = $oModuleModel->getModuleConfig('blind');
		if(!is_object($_config) || !$_config->max_blind)
		{
			$config->max_blind = 100;
		}
		else
		{
			$config->max_blind = $_config->max_blind;
		}

		return $config;
	}
	public function moduleInstall()
	{
		/*$oModuleModel = getModel('module');
		$oModuleController = getController('module');
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'blind', 'class', 'triggerModuleProc', 'after'))
		{
			$oModuleController->insertTrigger('moduleHandler.proc', 'blind', 'class', 'triggerModuleProc', 'after');
		}
		if(!$oModuleModel->getTrigger('member.getMemberMenu', 'blind', 'class', 'triggerMemberMenu', 'after'))
		{
			$oModuleController->insertTrigger('member.getMemberMenu', 'blind', 'class', 'triggerMemberMenu', 'after');
		}*/
		return new object();
	}
	public function checkUpdate()
	{
		/*
		$oModuleModel = getModel('module');
		if(!$oModuleModel->getTrigger('moduleHandler.proc', 'blind', 'class', 'triggerModuleProc', 'after')) return true;
		if(!$oModuleModel->getTrigger('member.getMemberMenu', 'blind', 'class', 'triggerMemberMenu', 'after')) return true;
		*/

		return FALSE;
	}
	public function triggerModuleProc($oModule)
	{
		$logged_info = Context::get('logged_info');
		// 비회원은 금지
		if(!is_object($logged_info) || !$logged_info->member_srl)
		{
			return;
		}
		$args = new stdClass();
		$args->member_srl = $logged_info->member_srl;
		$output = executeQueryArray('blind.getBlind', $args);
		$blind_list = array();
		foreach($output->data as $val)
		{
			$blind_list[] = $val->target_member_srl;
		}
		if(!count($blind_list)) return;
		if(strpos($oModule->act, 'disp')===0)
		{
			$document_list = Context::get('document_list');
			if(!is_array($document_list)) $document_list = array();
			$oDocument = Context::get('oDocument');

			if(is_object($oDocument) && $oDocument->document_srl)
			{
				$document_list[] = $oDocument;
				$blid_comments = array();
				foreach($oDocument->getComments() as $oComment)
				{
					if(!in_array($oComment->get('member_srl'), $blind_list)) continue;
					$blid_comments[] = '.comment_'.$oComment->get('comment_srl').'_'.$oComment->get('member_srl');
				}
				if(count($blid_comments))
				{
					Context::addHtmlHeader('<script type="text/javascript">window.blid_comments='
					.json_encode($blid_comments).
					'</script>');
					Context::addJsFile('modules/blind/tpl/blind_comment.js');
				}
				/*foreach($oDocument->getComments() as $oComment)
				{
					$oComment->add('content','<span style="color:#FF8D00">블라인드 처리된 댓글입니다.</span>');
					$oComment->content = '<span style="color:#FF8D00">블라인드 처리된 댓글입니다.</span>';
				}*/
			}
			foreach($document_list as $oDocument)
			{
				if(!is_object($oDocument)) continue;
				if(!in_array($oDocument->get('member_srl'), $blind_list)) continue;
				$oDocument->add('title','블라인드 처리된 글입니다.');
				$oDocument->add('title_color','FF8D00');
				$oDocument->add('content','<span style="color:#FF8D00">블라인드 처리된 글입니다.</span>');
			}
		}
		/*if($oModule->act=='getMemberMenu')
		{
			$oMemberController = getController('member');
			$oMemberController->addMemberPopupMenu('javascript:;','test');
		}*/
	}
	public function triggerMemberMenu($obj)
	{
		$logged_info = Context::get('logged_info');
		// 비회원은 금지
		if(!is_object($logged_info) || !$logged_info->member_srl)
		{
			return;
		}
		// 타 회원은 블라인드
		$target_srl = Context::get('target_srl');
		$oMemberController = getController('member');
		/*if($logged_info->member_srl!=$target_srl)
		{
			if($this->isBlind($target_srl))
			{
				$txt = '블라인드 취소';
			}
			else
			{
				$txt = '블라인드';
			}
			$oMemberController->addMemberPopupMenu('javascript:;','<span onclick="jQuery.getScript(request_uri+\'modules/blind/api.php?target_srl='.$target_srl.'\')" style="display:block">'.$txt.'</span>');
		}
		// 내 자신은 블라인드 리스트
		else
		{
			$oMemberController->addMemberPopupMenu(getNotEncodedUrl('', 'mid',Context::get('cur_mid'),'act','dispBlindList'),'블라인드 보기','','_self');
		}*/
		$oMemberController->addMemberPopupMenu(getNotEncodedUrl('', 'mid',Context::get('cur_mid'),'act','dispBlindList','target_srl',$target_srl),'블라인드','','_self');
	}
	public function isBlind($target_member_srl)
	{
		$logged_info = Context::get('logged_info');
		if(!is_object($logged_info) || !$logged_info->member_srl)
		{
			return 0;
		}

		$member_srl = $logged_info->member_srl;

		$args = new stdClass();
		$args->target_member_srl = $target_member_srl;
		$args->member_srl = $member_srl;

		// 이미 등록된 경우 삭제
		$output = executeQueryArray('blind.getBlind', $args);

		return count($output->data);
	}
	function blidCount()
	{
		$logged_info = Context::get('logged_info');
		if(!is_object($logged_info) || !$logged_info->member_srl)
		{
			return 0;
		}
		$args = new stdClass();
		$args->member_srl = $logged_info->member_srl;
		$output = executeQueryArray('blind.getBlind', $args);

		return count($output->data);
	}

	public function moduleUpdate()
	{
		return $this->moduleInstall();
	}
/*
	final public function moduleUninstall()
	{
		return new object();
	}

	final public function recomplieCache()
	{
	}*/
}
