<?php

define('__XE__',   TRUE);
define('__ZBXE__',   TRUE);
require dirname(__FILE__) . '/../../config/config.inc.php';

function api_blind_exit($msg, $error = -1)
{
	echo 'alert(' . json_encode($msg). ');';
	if(!$error)
	{
		echo 'location.reload(true);';
	}
	exit;
}
/**
 * @brief Initialize by creating Context object
 * Set all Request Argument/Environment variables
 **/
$oContext = Context::getInstance();
$oContext->init();
$logged_info = Context::get('logged_info');
if(!is_object($logged_info) || !$logged_info->member_srl)
{
	api_blind_exit('로그인 바랍니다.');
}

$oMemberModel = &getModel('member');
$member_info = $oMemberModel->getMemberInfoByMemberSrl($_REQUEST['target_srl']);
if(!is_object($member_info) || !$member_info->member_srl)
{
	api_blind_exit('올바르지 않은 요청입니다.');
}

$args = new stdClass();
$args->target_member_srl = $member_info->member_srl;
$args->member_srl = $logged_info->member_srl;

// 이미 등록된 경우 삭제
$output = executeQueryArray('blind.getBlind', $args);
if(count($output->data))
{
	$output = executeQuery('blind.deleteBlind', $args);
	api_blind_exit('해당 회원을 블라인드 취소 하였습니다.', 0);
}

$oBlind = getClass('blind');
$config = $oBlind->config();
if($config->max_blind <= $oBlind->blidCount())
{
	api_blind_exit('더 이상 블라인드 추가할 수 없습니다.');
}

$args->regdate = time();

$output = executeQuery('blind.insertBlind', $args);
if($output->error)
{
	api_blind_exit($output->message);
}

api_blind_exit('해당 회원이 블라인드 처리 되었습니다.', 0);

