<?php
    /**
     * @class  exampleAdminView
     * @author XE스쿨 모듈 만들기 예제
     * @brief  example 모듈의 admin view class
     **/

    class layout_managerAdminView extends layout_manager {

        /**
         * @brief 초기화
         **/
        function init() {
            // module_srl이 있으면 미리 체크하여 존재하는 모듈이면 module_info 세팅
            $module_srl = Context::get('module_srl');
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set('module_srl', $module_srl);
            }

            // module model 객체 생성 
            $oModuleModel = &getModel('module');

            // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                if(!$module_info) {
                    Context::set('module_srl','');
                    $this->act = 'list';
                } else {
                    ModuleModel::syncModuleToSite($module_info);
                    $this->module_info = $module_info;
                    $this->module_info->use_status = explode('|@|', $module_info->use_status);
                    Context::set('module_info',$module_info);
                }
            }

            if($module_info && $module_info->module != 'layout_manager') return $this->stop("msg_invalid_request");

            // javascript를 로드
            Context::addJsFile($this->module_path.'tpl/js/editor.js');

            // 관리자 템플릿 파일의 경로 설정 (tpl)
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
        }

        /**
         * @brief 관리자 목록 & 에디터
         **/
        function dispLayout_managerAdminIndex() {
            $oLayout_managerAdminModel = &getAdminModel('layout_manager');
            $docs = $oLayout_managerAdminModel->getLayout_managerAdminDocs();
            
            $idx = Context::get('idx');
            if($idx == NULL) $idx = 0;

            $contents = $docs->contents->{$idx};
            $snb_list = $docs->snb_list;

            Context::set('snb_list', $snb_list);
            Context::set('snb_index', $idx);
            Context::set('contents', $contents);
            $this->setTemplateFile('index');
        }

        function dispLayout_managerAdminEditor() {
            $oLayout_managerAdminModel = &getAdminModel('layout_manager');
            $docs = $oLayout_managerAdminModel->getLayout_managerAdminDocs();

            $idx = Context::get('idx');
            if($idx == NULL) $idx = 0;

            $snb_list = $docs->snb_list;

            Context::set('snb_list', $snb_list);
            Context::set('snb_index', $idx);

            $oDocumentModel = getModel('document');

            /* 
                Editor 설정 및 초기화
                -- board 의 dispBoardWrite 를 참고함
            */

            // GET parameter document_srl from request
            $document_srl = Context::get('document_srl');
            $oDocument = $oDocumentModel->getDocument(0, $this->grant->manager);
            $oDocument->setDocument($document_srl);

            if($oDocument->get('module_srl') == $oDocument->get('member_srl')) $savedDoc = TRUE;
            $oDocument->add('module_srl', $this->module_srl);

            if($oDocument->isExists() && $this->module_info->protect_content=="Y" && $oDocument->get('comment_count')>0 && $this->grant->manager==false)
            {
                return new Object(-1, 'msg_protect_content');
            }

            // if the document is not granted, then back to the password input form
            $oModuleModel = getModel('module');
            if($oDocument->isExists()&&!$oDocument->isGranted())
            {
                return $this->setTemplateFile('input_password_form');
            }

            if(!$oDocument->isExists())
            {
                $point_config = $oModuleModel->getModulePartConfig('point',$this->module_srl);
                $logged_info = Context::get('logged_info');
                $oPointModel = getModel('point');
                $pointForInsert = $point_config["insert_document"];
                if($pointForInsert < 0)
                {
                    if( !$logged_info )
                    {
                        return $this->setMessage('msg_not_permitted');
                    }
                    else if (($oPointModel->getPoint($logged_info->member_srl) + $pointForInsert )< 0 )
                    {
                        return $this->setMessage('msg_not_enough_point');
                    }
                }
            }

            if(!$oDocument->get('status')) $oDocument->add('status', $oDocumentModel->getDefaultStatus());

            $statusList = $this->_getStatusNameList($oDocumentModel);
            if(count($statusList) > 0) Context::set('status_list', $statusList);

            // get Document status config value
            Context::set('document_srl',$document_srl);
            Context::set('oDocument', $oDocument);


            // apply xml_js_filter on header
            $oDocumentController = getController('document');
            $oDocumentController->addXmlJsFilter($this->module_info->module_srl);

            // if the document exists, then setup extra variabels on context
            if($oDocument->isExists() && !$savedDoc) Context::set('extra_keys', $oDocument->getExtraVars());

            /**
             * add JS filters
             **/
            if(Context::get('logged_info')->is_admin=='Y') Context::addJsFilter($this->module_path.'tpl/filter', 'insert_admin.xml');
            else Context::addJsFilter($this->module_path.'tpl/filter', 'insert.xml');

            $this->setTemplateFile('editor');
        }

        function _getStatusNameList(&$oDocumentModel)
        {
            $resultList = array();
            if(!empty($this->module_info->use_status))
            {
                $statusNameList = $oDocumentModel->getStatusNameList();
                $statusList = explode('|@|', $this->module_info->use_status);

                if(is_array($statusList))
                {
                    foreach($statusList as $key => $value)
                    {
                        $resultList[$value] = $statusNameList[$value];
                    }
                }
            }
            return $resultList;
        }


    }
?>