<?php
    class layout_managerAdminController extends layout_manager {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief layout_manager 문서 추가
         **/
		function procLayout_managerAdminInsert($args = null) {
			// check grant
			if($this->module_info->module != "layout_manager")
			{
				return new Object(-1, "msg_invalid_request");
			}

			if(!$this->module_srl)
			{
				return new Object(-1, "msg_invalid_module");
			}

			$logged_info = Context::get('logged_info');

			// setup variables
			$obj = Context::getRequestVars();
			$obj->module_srl = $this->module_srl;

			settype($obj->title, "string");
			if($obj->title == '') $obj->title = cut_str(trim(strip_tags(nl2br($obj->content))),20,'...');
			
			//setup dpcument title tp 'Untitled'
			if($obj->title == '') $obj->title = 'Untitled';

			// generate document module model object
			$oDocumentModel = getModel('document');

			// generate document module의 controller object
			$oDocumentController = getController('document');

			// check if the document is existed
			$oDocument = $oDocumentModel->getDocument($obj->document_srl, true);

			// update the document if it is existed
			$is_update = false;
			if($oDocument->isExists() && $oDocument->document_srl == $obj->document_srl)
			{
				$is_update = true;
			}

			// update the document if it is existed
			if($is_update)
			{
				if(!$oDocument->isGranted())
				{
					return new Object(-1,'msg_not_permitted');
				}
				
				// modify list_order if document status is temp
				if($oDocument->get('status') == 'TEMP')
				{
					$obj->last_update = $obj->regdate = date('YmdHis');
					$obj->update_order = $obj->list_order = (getNextSequence() * -1);
				}

				$output = $oDocumentController->updateDocument($oDocument, $obj, true);
				$msg_code = 'success_updated';

			// insert a new document otherwise
			} else {
				$output = $oDocumentController->insertDocument($obj);
				$msg_code = 'success_registed';
			}

			// if there is an error
			if(!$output->toBool())
			{
				return $output;
			}

			// return the results
			$this->add('mid', Context::get('mid'));
			$this->add('document_srl', $output->get('document_srl'));

			// alert a message
			if(Context::get('xeVirtualRequestMethod') !== 'xml')
			{
				$this->setMessage($msg_code);
			}
		}
		

        /**
         * @brief layout_manager 모듈(mid) 삭제
         **/
        function procLayout_managerAdminDelete() {
			// 삭제를 요청하는 module_srl 확인
            $module_srl = Context::get('module_srl');

            // 원본을 찾아 삭제
            $oModuleController = &getController('module');
            $output = $oModuleController->deleteModule($module_srl);
            if(!$output->toBool()) return $output;

			// 메시지 등록
			$msg_code = 'success_deleted';
  			$this->setMessage($msg_code);

			// success_return_url의 존재여부에 따라 URL 재지정
			if (Context::get('success_return_url')){
				$this->setRedirectUrl(Context::get('success_return_url'));
			}else{
				$this->setRedirectUrl(getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLayout_managerAdminList', 'module_srl', ''));
			}
	
		}
	}
?>