<?php
    /**
     * @class  rouletteView
     * @brief  roulette 모듈의 View class
     **/

    class rouletteView extends roulette {

        /**
         * @brief 초기화
         * board 모듈은 일반 사용과 관리자용으로 나누어진다.
         **/
        function init() {
            $oModuleModel = &getModel('module');

            // 설정 정보 가져오기
            $roulette_config = $oModuleModel->getModuleConfig('roulette');

            // 브라우저 타이틀 설정
            Context::addBrowserTitle($roulette_config->title);

            // 설정 변수 지정
            Context::set('roulette_config', $roulette_config);

            // template path지정
            $template_path = sprintf("%sskins/%s/",$this->module_path, $roulette_config->skin);
            if(!is_dir($template_path)||!$roulette_config->skin) {
                $roulette_config->skin = 'default';
                $template_path = sprintf("%sskins/%s/",$this->module_path, $roulette_config->skin);
            }
            $this->setTemplatePath($template_path);


        }


        function dispRouletteBuy() {
            $this->setLayoutFile('popup_layout');
            $oPointModel = &getModel('point');
            $oRouletteModel = &getModel('roulette');

            // 로그인정보 가져오기
            $logged_info = Context::get('logged_info');
            if(!$logged_info->member_srl) return $this->stop('msg_not_permitted');
            
            // 포인트/레벨을 구해옴
            $logged_info->point = $oPointModel->getPoint($logged_info->member_srl);
            Context::set('logged_info',$logged_info);

            // 오늘 참여횟수 구해옴
            $my_today_count = $oRouletteModel->MyLogCount($logged_info->member_srl,1);
            Context::set('my_today_count',$my_today_count);


            $oModuleModel = &getModel('module');
            $roulette_config = $oModuleModel->getModuleConfig('roulette');
            Context::set('roulette_config',$roulette_config);

            $this->setTemplateFile('index');
        }


    }
?>
