<?php
    /**
     * @class  rouletteController
     * @brief  roulette 모듈의 Controller class
     **/

    class rouletteController extends roulette {

        /**
         * @brief 초기화
         **/
        function init() {
        }



       function procRoulettePointUse() {

            $oModuleModel = &getModel('module');
            $oPointModel = &getModel('point');
            $oRouletteModel = &getModel('roulette');

            // 로그인정보 가져오기
            $logged_info = Context::get('logged_info');
            if(!$logged_info->member_srl) return $this->stop('msg_not_permitted');

            // 설정 정보 가져오기
            $roulette_config = $oModuleModel->getModuleConfig('roulette');
            
            // 포인트를 구해옴
            $logged_info->point = $oPointModel->getPoint($logged_info->member_srl);


            // 오늘 참여횟수 구해와서 검사함
            $my_today_count = $oRouletteModel->MyLogCount($logged_info->member_srl,1);
            if($roulette_config->today_max_count && $my_today_count >= $roulette_config->today_max_count) return new Object(-1,sprintf(Context::getLang('today_count_overflow'),$roulette_config->today_max_count));

            // 포인트검사
            if($roulette_config->price > $logged_info->point) return new Object(-1,'roulette_point_error');


            // 포인트차감
            if($roulette_config->price) {
                $oPointController = &getController('point');
                $oPointController->setPoint($logged_info->member_srl,$roulette_config->price, 'minus');
            }

            // 구입로그 남기기
            $args = null;
            $args->data_srl = getNextSequence();
            $args->member_srl = $logged_info->member_srl;
            $args->category_srl = 1;
            $args->point = $roulette_config->price;
            $args->content = '룰렛게임 포인트사용';

			//print_r($args);
            $this->InsertLog($args);

            // 성공 메세지 등록
            //$this->add('data',$data);
            //$this->setMessage("confirm_roulette_buy");
        }



       function procRoulettePointReceive() {

			$oModuleModel = &getModel('module');
            $oPointModel = &getModel('point');
            $oRouletteModel = &getModel('roulette');

            // 로그인정보 가져오기
            $logged_info = Context::get('logged_info');
            if(!$logged_info->member_srl) return $this->stop('msg_not_permitted');

            // 설정 정보 가져오기
            $roulette_config = $oModuleModel->getModuleConfig('roulette');
			
			$rank = Context::get('rank');
			if(!$rank) return new Object(-1,'roulette_receive_error');

			$point = "point".$rank;
			$label = "label".$rank;

			//echo $point;
			//echo $label;
			
			$point = $roulette_config->$point;
			$label = $roulette_config->$label;
			
            // 포인트증가
			if($point){

				$oPointController = &getController('point');
				$oPointController->setPoint($logged_info->member_srl, $point, 'add');

				// 당첨금수령 로그 남기기
				$args = null;
				$args->data_srl = getNextSequence();
				$args->member_srl = $logged_info->member_srl;
				$args->category_srl = 2;
				$args->point = $point;
				$args->content = sprintf("%s(%s) 당첨금 수령", $logged_info->user_id, $logged_info->nick_name);
				$this->InsertLog($args);

			}

			// 성공 메세지 등록
			$this->add('reload',1);
			if($point)
				$this->setMessage( sprintf(Context::getLang('roulette_receive_message'), $label, $point));
			else
				$this->setMessage(Context::getLang('roulette_fail_message'));
        }

        /**
         * @brief 로그처리 함수
         * category_srl (1구매 2수령)
         **/
        function InsertLog($args) {
            if(!$args->data_srl) return;
            $output = executeQuery("roulette.insertLog",$args);
            if(!$output->toBool()) return $output;
        }

	}
?>
