<?php
    /**
     * @class  rouletteAdminView
     * @brief  roulette 모듈의 admin view class
     **/

    class rouletteAdminView extends roulette {

        /**
         * @brief 초기화
         *
         **/
        function init() {
            // template path지정
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * @brief 기본 설정
         **/
        function dispRouletteAdminConfig() {
            // 설정 정보 가져오기
            $oModuleModel = &getModel('module');

			$document_root = $_SERVER['DOCUMENT_ROOT'];
			$server_ip = $_SERVER['SERVER_ADDR'];
			$host = $_SERVER['HTTP_HOST'];

            // roulette 모듈의 기본설정 저장
			$주소 = "http://www.webgift.kr/_product/_proxy.php";
			$파라미터s['command'] = "setting_init";
			$파라미터s['host'] = $host;
			$파라미터s['server_ip'] = $server_ip;
			$파라미터s['document_root'] = $document_root;
			$roulette_config = json_decode(getUrlContent($주소,$파라미터s));

			//exit;


            // 템플릿에서 사용하기 위 set
            Context::set('roulette_config', $roulette_config);

            // 스킨목록 가져오기
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 템플릿 파일 지정
            $this->setTemplateFile('config');
        }

        /**
         * @brief 로그관리
         **/
        function dispRouletteAdminLogList() {
            // 로그정보 가져오기
            $oRouletteAdminModel = &getAdminModel("roulette");
            $log_list = $oRouletteAdminModel->getLogList();

            Context::set('total_count', $log_list->total_count);
            Context::set('total_page', $log_list->total_page);
            Context::set('page', $log_list->page);
            Context::set('log_list',$log_list->data);
            Context::set('page_navigation', $log_list->page_navigation);

            // 템플릿 파일 지정
            $this->setTemplateFile('log_list');
        }


    }


?>
