<?php
    /**
     * @class  roulette
     * @brief  roulette 모듈의 high class
     **/

    class roulette extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // roulette 모듈의 기본설정 저장
			$주소 = "http://www.webgift.kr/_product/_proxy.php";
			$파라미터s['command'] = "setting_init";
			$config = json_decode(getUrlContent($주소,$파라미터s));


            $oModuleController->insertModuleConfig('roulette', $config);

            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');

            // roulette 모듈의 기본설정이 없으면...
            $roulette_config = $oModuleModel->getModuleConfig('roulette');
            if(!$roulette_config) return true;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oDB = &DB::getInstance();
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // roulette 모듈의 기본설정 저장
            $roulette_config = $oModuleModel->getModuleConfig('roulette');

            if(!$roulette_config) {

				$config = null;

				$주소 = "http://www.webgift.kr/_product/_proxy.php?command=setting";
				$결과 = json_decode(curl($url));
				print_r($결과);



                $oModuleController->insertModuleConfig('roulette', $config);
            }

            return new Object(0, 'success_updated');
        }

		function moduleUninstall() {
            return new Object();
		}

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }

    }


	function getUrlContent($url,$post=array())
	{
		$resource = curl_init();
		curl_setopt($resource, CURLOPT_URL, $url);
		//curl_setopt($resource, CURLOPT_REFERER, "http://jiebademo.ap01.aws.af.cm/extract");
		if(count($post)) {
			curl_setopt($resource, CURLOPT_POST, 1);
			curl_setopt($resource, CURLOPT_POSTFIELDS, $post);
		}
		curl_setopt($resource, CURLOPT_TIMEOUT, 0);
		curl_setopt($resource, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($resource, CURLOPT_BINARYTRANSFER, 1);
		$content = curl_exec($resource);
		curl_close($resource);
		return $content;
	}
?>
