<?php
    /**
     * @class  rouletteAdminController
     * @brief  roulette 모듈의 admin controller class
     **/

    class rouletteAdminController extends roulette {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 기본설정
         **/
        function procRouletteAdminConfig() {
            // 설정 정보 가져오기
            $oModuleModel = &getModel('module');
            $roulette_config = $oModuleModel->getModuleConfig('roulette');

            // 변수 정리
            $args = Context::getRequestVars();

			for($i=1;$i<=8;$i++){
				$idx = "idx".$i;
				$type = "type".$i;
				$label = "label".$i;
				$percent = "percent".$i;
				$point = "point".$i;
				$image = "image".$i;
				


				$roulette_config->$idx = $args->$idx;
				$roulette_config->$type = $args->$type;
				$roulette_config->$label = $args->$label;
				$roulette_config->$percent = $args->$percent;
				$roulette_config->$point = $args->$point;


				

				if($type=='꽝'){
					$꽝확률 += (int)$percent;
					echo $꽝확률;
				}
			}



            
			$fail_per = $꽝확률;

            // 확률이 100을 넘을경우...
            if($fail_per > 100) return new Object(-1,'roulette_per_overflow');

            $roulette_config->title = trim($args->title);
            $roulette_config->skin = $args->skin;
            $roulette_config->price = (int)$args->price;
            $roulette_config->today_max_count = (int)$args->today_max_count;
			$roulette_config->fail_per = $꽝확률;

			//print_r($roulette_config);
			
			$document_root = $_SERVER['DOCUMENT_ROOT'];
			$server_ip = $_SERVER['SERVER_ADDR'];
			$host = $_SERVER['HTTP_HOST'];

            // roulette 모듈의 기본설정 저장
			$주소 = "http://www.webgift.kr/_product/_proxy.php";
			$파라미터s['command'] = "setting_update";
			$파라미터s['host'] = $host;
			$파라미터s['server_ip'] = $server_ip;
			$파라미터s['document_root'] = $document_root;
			$파라미터s['setting'] = json_encode($roulette_config);
			$roulette_config = json_decode(getUrlContent($주소,$파라미터s));
			//print_r($roulette_config);
			//print_r($파라미터s);exit;
            // 저장
            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('roulette', $roulette_config);


			$this->setMessage('success_updated', 'info');

			$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispRouletteAdminConfig');
			$this->setRedirectUrl($returnUrl);
        }

        /**
         * @brief 로그삭제
         **/
        function procRouletteAdminLogDelete() {
            $data_srls = Context::get('data_srls');
            if(!$data_srls) return new Object(-1,'msg_cart_is_null');

            $data_srl_list = explode(",",$data_srls);
            foreach($data_srl_list as $key => $val) {
                // 데이터 삭제
                $args = null;
                $args->data_srl = $val;
                $this->DeleteLog($args);
            }
            $this->setMessage('success_deleted');
        }
        /**
         * @brief 로그초기화
         **/
        function procRouletteAdminLogReset() {
            $this->ResetLog();
            $this->setMessage('success_deleted');
        }


        function DeleteLog($args) {
            $output = executeQuery("roulette.deleteLog",$args);
            if(!$output->toBool()) return $output;
        }


        function ResetLog() {
            $output = executeQuery("roulette.deleteLog");
            if(!$output->toBool()) return $output;
        }

    }


?>
