<?php
/* Copyright (C) QNOTES <http://qnotes.co.kr> */

/**
 * @class  phizeditormobile
 * @author QNOTES (qnotes@nate.com)
 * @brief  phizeditormobile module high class
 **/

require_once(_XE_PATH_.'modules/board/board.class.php');
class phizeditormobile extends board
{

	/**
	 * @brief install the module
	 **/
	function moduleInstall()
	{
	}

	/**
	 * @brief chgeck module method
	 **/
	function checkUpdate()
	{
		$oModuleModel = getModel('module');

		if(!$oModuleModel->getTrigger('document.insertDocument', 'phizeditormobile', 'controller', 'triggerInsertDocument', 'after')) return true;
		if(!$oModuleModel->getTrigger('document.updateDocument', 'phizeditormobile', 'controller', 'triggerUpdateDocument', 'after')) return true;
		if(!$oModuleModel->getTrigger('comment.insertComment', 'phizeditormobile', 'controller', 'triggerInsertComment', 'after')) return true;
		if(!$oModuleModel->getTrigger('comment.updateComment', 'phizeditormobile', 'controller', 'triggerUpdateComment', 'after')) return true;

		// 2011. 09. 20 when add new menu in sitemap, custom menu add
		if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'phizeditormobile', 'model', 'triggerModuleListInSitemap', 'after')) return true;

		return false;
	}

	/**
	 * @brief update module
	 **/
	function moduleUpdate()
	{
		$oModuleModel = getModel('module');
		$oModuleController = getController('module');

		if(!$oModuleModel->getTrigger('document.insertDocument', 'phizeditormobile', 'controller', 'triggerInsertDocument', 'after'))
			$oModuleController->insertTrigger('document.insertDocument', 'phizeditormobile', 'controller', 'triggerInsertDocument', 'after');
		if(!$oModuleModel->getTrigger('document.updateDocument', 'phizeditormobile', 'controller', 'triggerUpdateDocument', 'after'))
			$oModuleController->insertTrigger('document.updateDocument', 'phizeditormobile', 'controller', 'triggerUpdateDocument', 'after');
		if(!$oModuleModel->getTrigger('comment.insertComment', 'phizeditormobile', 'controller', 'triggerInsertComment', 'after'))
			$oModuleController->insertTrigger('comment.insertComment', 'phizeditormobile', 'controller', 'triggerInsertComment', 'after');
		if(!$oModuleModel->getTrigger('comment.updateComment', 'phizeditormobile', 'controller', 'triggerUpdateComment', 'after'))
			$oModuleController->insertTrigger('comment.updateComment', 'phizeditormobile', 'controller', 'triggerUpdateComment', 'after');

		// 2011. 09. 20 when add new menu in sitemap, custom menu add
		if(!$oModuleModel->getTrigger('menu.getModuleListInSitemap', 'phizeditormobile', 'model', 'triggerModuleListInSitemap', 'after'))
		{
			$oModuleController->insertTrigger('menu.getModuleListInSitemap', 'phizeditormobile', 'model', 'triggerModuleListInSitemap', 'after');
		}

		return new Object(0, 'success_updated');
	}

	function moduleUninstall()
	{
		return new Object();
	}

	/**
	 * @brief 캐시 파일 재생성
	 **/
	function recompileCache() {
	}

}
