
MySQL UTF-8 이모티콘 지원 애드온
--------------------------------

XE에서 MySQL이나 MariaDB를 사용할 경우 모든 테이블이 `utf8` 문자셋으로 생성되어서
이모티콘이나 일부 한자가 입력되지 않는 문제를 우회하는 애드온입니다.
(MySQL의 `utf8` 문자셋은 4바이트 문자를 인식하지 못합니다.
우리가 알고 있는 UTF-8을 MySQL에서는 `utf8mb4`라고 부릅니다.)

가장 확실한 해결책은 문서 및 댓글 테이블의 문자셋을 `utf8mb4`로 변경하는 것이지만,
테이블에 이미 많은 데이터가 저장되어 있어 변경하기 곤란하거나 DB 서버가 `utf8mb4` 문자셋을 지원하지 않는 경우
이 애드온을 사용하여 임시로 해결할 수 있습니다.

UTF-8에서 4바이트로 인코딩되는 이모티콘 등의 문자를 입력할 경우
`&#x1f603;` 등의 HTML 엔티티 코드로 변환하여 저장합니다.
웹상에서는 원래의 문자로 표시됩니다.

[Rhymix](https://github.com/rhymix/rhymix/pull/116)에서 가져온 코드가 포함되어 있습니다.
라이선스는 GPLv2입니다.
