<?php
	@date_default_timezone_set('Asia/Seoul');
    class yeyakView extends yeyak {

	     function init() {
   			$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
			if(!is_dir($template_path)||!$this->module_info->skin)
			{
				$this->module_info->skin = 'default';
				$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);
			}

			if(strpos(Context::get('act'), "dispYeyakAdmin") !== false) {
				$this->setTemplatePath($this->module_path . 'tpl');
				$this->setLayoutPath($this->getTemplatePath()."layout/");
				if(strpos(Context::get('act'), "Pop") !== false) {
					$this->setLayoutFile('pop.html');
				}else{
					$this->setLayoutFile('layout.html');
				}
			}

			Context::set('sImgPath',$this->module_path . 'tpl/images/cl/');
			Context::set('sCssPath',$this->module_path . 'tpl/css/cl/');
			Context::set('sTplPath',$this->module_path . 'tpl/');

			$this->setTemplatePath($template_path);
        }

		function dispYeyakSinglePay(){
			if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			Context::set('yeyak_config',$yeyak_config);
			Context::set('reqvar',$args);

			$output = executeQueryArray('yeyak.getCartContent',$args);
			if(!$output->data){
				$returnUrl =  getNotEncodedUrl('', 'mid', 'yeyak');
				return $this->alertMessageBackGoUrl('y_error_no_cart',$returnUrl);
				exit;
			}

			$cart_info=$oYeyakModel->arrangeDataInfo($output);
			$pass_filed=array("add_point");
			foreach($cart_info as $k=>$val){
				if(in_array($k,$pass_filed)){
					$cart_info->{$k}=unserialize($cart_info->{$k});	
				}
				if(strpos("options_",$k)){
					$cart_info->{$k}=unserialize($cart_info->{$k});	
				}
			}

			Context::set('cart_info',$cart_info);
			Context::set('add_point',$cart_info->add_point);

			$etc_config=$oYeyakModel->getEtcConfig();
			$logged_info = Context::get('logged_info');
			$mem_info=$oYeyakModel->getUinfo($logged_info);

			Context::set('nameValue',$mem_info->name);
			Context::set('emailValue',$mem_info->email);
			Context::set('telArray',$mem_info->tel);
			Context::set('etc_config',$etc_config);

			$output = executeQueryArray('yeyak.getPayContent',$args);
			$pay_info=$oYeyakModel->arrangeDataInfo($output);
			Context::set('pay_set',$pay_info);
			$yeyak_path = _XE_PATH_."/modules/yeyak";
			$pg=$oYeyakModel->getPgConfig();
			
	
			Context::set('pg',$pg);
			Context::set('yeyak_path',$yeyak_path);
			$this->setTemplateFile('pay');

		}

        function dispYeyakMySch() {

			if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');
            $args = Context::getRequestVars();
            if(!$args->setyear){
                $args->setyear=date("Y");
            }
            if(!$args->setmonth){
				$args->setmonth=date("m");
			}

			Context::set('info',$args);
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			Context::set('yeyak_config',$oYeyakAdminModel->getYeyakConfig());


			$thisY=$args->setyear;
			$thisM=$args->setmonth;
		
			$args->start_date=$thisY."-".$thisM."-01";
			$args->end_date=$thisY."-".$thisM."-31";
				
			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl){
				$args->member_srl = $logged_info->member_srl;
			}
			
			$args->start_date=str_replace('-','',$args->start_date);
			$args->end_date=str_replace('-','',$args->end_date);

		

	
			$output =  $oYeyakModel->getMemberResedList($args);
	
			$resLogByMember=null;
			
			if(count($output->data)){
				foreach($output->data as $k=>$val) {
						$resLogByMember[(string)$val->start_date][count($resLogByMember[(string)$val->start_date])+1] = array("cateInfo"=>$val->cate_srl,"cateTitle"=>$val->cate_title,"roomTitle"=>$val->title,"keyNum"=>$val->keynum);
				}
			}

			Context::set('resInfo',$resLogByMember);	

			$this->setMessage('success');
			$this->setTemplateFile('my_sch.html');

		}


		 /**
         * @brief 목록
         **/
        function dispYeyakInsert() {

			if(!$this->grant->access || !$this->grant->list) return $this->dispYeyakMessage('msg_not_permitted');
			$args = Context::getRequestVars();
			if(!$args->setyear){
				$args->setyear=date("Y");
			}
			if(!$args->setmonth){
				$args->setmonth=date("m");
			}

			Context::set('yeyak_tpl',$this->module_path."tpl/");
			$oYeyakModel = getModel('yeyak');
			Context::set('oYeyakModel',$oYeyakModel);
			
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			$yeyak_config->nowork_day=explode(PHP_EOL,$yeyak_config->bday_nowork);
		
			$etc_config=$oYeyakModel->getEtcConfig();
	
			$args->month_limit_status="blue";
			if($etc_config->yskin['month_limit'] != "" && $etc_config->yskin['month_limit'] != "0"){
				$thisLm=(float)$args->setyear.$args->setmonth;
				$endLm=(float)date("Ym", strtotime(date("Y-m")." +".$etc_config->yskin['month_limit']." month"));
				if($yeyak_config->bday_use != 'Y'){
					$yeyak_config->bday_use="Y";
					$yeyak_config->bday_sdate=date("Ymd");
					$yeyak_config->bday_edate=date("Ymd", strtotime(date("Y-m-d")." +".$etc_config->yskin['month_limit']." month"));
				}
				if($thisLm == $endLm){
					$args->month_limit_status="red";
				}
				if($thisLm > $endLm){
					$args->month_limit_status="over";
					$this->alertMessageBack("y_error_month_limit");
					return;
				}
			}

		
			Context::set('yeyak_config',$yeyak_config);
			$yeyak_config_obj=$oYeyakModel->objectToArray($yeyak_config);
			Context::set('yeyak_config_obj',$yeyak_config_obj);



			Context::set('etc_config',$etc_config);
			Context::set('info',$args);


			if($yeyak_config->idx){
				if($yeyak_config->bday_week_data != ""){
					$week_data=explode(",",$yeyak_config->bday_week_data );

					Context::set('week_data',$week_data);
				}
			}else{
				Context::set('week_data',"");
			}

			$res_args=new stdClass;
			$res_args->start_date = $args->setyear.$args->setmonth."01";
			$res_args->end_date = $args->setyear.$args->setmonth."31";

			$output = executeQueryArray('yeyak.getYeyakHdayList',$res_args);
			$resLogByHday=null;
			if(count($output->data)){
			foreach($output->data as $k=>$val) {
					$vas =$val->hday_srl.",".$val->day_color.",".$val->title.",".$val->day_type.",".$val->add_amount;
					$resLogByHday[(string)$val->use_date]= $vas;
			}
			}

			Context::set('hdayInfo',$resLogByHday);			
			


			$output = executeQueryArray('yeyak.getMonthResCate',$res_args);
			$resLogByCate=null;
			
			if(count($output->data)){
				foreach($output->data as $k=>$val) {
						$resLogByCate[(string)$val->use_date][(string)$val->cate_srl] = $val->ct;
				}
			}

			Context::set('cateCount',$resLogByCate);			
			
			$i=0;
			$cateArray=null;
			$output = executeQueryArray('yeyak.getRoomByCate',$res_args);
			$cbsin=array();
			if(count($output->data)){
		
				
				foreach($output->data as $k=>$val) {
					$cateArray[$i]=array((string)$val->cate_srl,$val->cate_title,$val->cnt);
					$i++;

					if($val->cate_title == ""){
						continue;
					}
					if(in_array($val->cate_srl,$cbsin)){
						continue;
					}
					array_push($cbsin,$val->cate_srl);
				
				}
			}
			Context::set('viewCateAr',$cbsin);
			Context::set('cateInfo',$cateArray);

			$output = executeQueryArray('yeyak.getMonthResRoom',$res_args);
			$resLogByRoom=null;
			$resLogByRoomStatus=array();
	
			if(count($output->data)){
				foreach($output->data as $k=>$val) {
						$resLogByRoom[(string)$val->use_date][(string)$val->info_srl] = $val->ct;
				}
			}
			Context::set('roomCount',$resLogByRoom);

			$res_args->start_date =date("Ymd",strtotime($args->setyear."-".$args->setmonth."-01 -11 day"));
			$output = executeQueryArray('yeyak.getMonthRoomStatus',$res_args);
			if(count($output->data)){
				foreach($output->data as $k=>$val) {
						if($val->status == "3"){
							continue;
						}
						if($val->stay_length == "1"){	
						$resLogByRoomStatus[(string)$val->start_date][(string)$val->info_srl]=$val->status;
						}else{
							for($i=0;$i<$val->stay_length;$i++){
							
								$seekSetDay= date("Ymd", strtotime($val->start_date."+".$i."day"));

								$resLogByRoomStatus[(string)$seekSetDay][(string)$val->info_srl]=$val->status;
							}
						}
				}
			}


			Context::set('roomStatus',$resLogByRoomStatus);

			$i=0;
			$roomArray=null;
			$room_args = new stdClass;
			$room_args->is_use="Y";
			$output = executeQueryArray('yeyak.getYeyakRoomList',$room_args);
			if(count($output->data)){
				foreach($output->data as $k=>$val) {
					$roomArray[$i]=array((string)$val->info_srl,$val->title,$val->cate_title,$val);
					
					$i++;
				}
			}

			Context::set('roomInfo',$roomArray);
			$seasons=$oYeyakAdminModel->getAdminYeyakSeaonsLists();
			Context::set('seasons',$seasons);

			$seasons_list=$oYeyakAdminModel->getAdminSeasonsInfoLists();
			$seasons_list=$oYeyakModel->objectToArray($seasons_list->data);
	
			Context::set('seasons_list',$seasons_list);

			$this->setMessage('success');
			$this->setTemplateFile('insert');


		}

		function dispYeyakMultiPay(){
			if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			Context::set('yeyak_config',$yeyak_config);
			Context::set('reqvar',$args);

			$output = executeQueryArray('yeyak.getCartContent',$args);
			if(!$output->data){
				$returnUrl =  getNotEncodedUrl('', 'mid', 'yeyak');
				return $this->alertMessageBackGoUrl('y_error_no_cart',$returnUrl);
				exit;
			}
			$cart_info=$oYeyakModel->arrangeDataInfo($output);
			$pass_filed=array("rescartid","start_date","sel_cate","total_amount","regdate","grp_total_amount","use_point","use_point_amount");
			foreach($cart_info as $k=>$val){
				if(in_array($k,$pass_filed)){
						continue;
				}
				$cart_info->{$k}=unserialize($cart_info->{$k});
			}

			Context::set('cart_info',$cart_info);
			Context::set('add_point',$cart_info->add_point);
			$etc_config=$oYeyakModel->getEtcConfig();

			$logged_info = Context::get('logged_info');
			$mem_info=$oYeyakModel->getUinfo($logged_info);

			
	
			Context::set('nameValue',$mem_info->name);
			Context::set('emailValue',$mem_info->email);
			Context::set('telArray',$mem_info->tel);


			Context::set('etc_config',$etc_config);

			$output = executeQueryArray('yeyak.getPayContent',$args);
			$pay_info=$oYeyakModel->arrangeDataInfo($output);
			Context::set('pay_set',$pay_info);
			$yeyak_path = _XE_PATH_."/modules/yeyak";
			$pg=$oYeyakModel->getPgConfig();
			Context::set('pg',$pg);
			Context::set('yeyak_path',$yeyak_path);

			$this->setTemplateFile('multi_pay');
		}

		function dispYeyakMultiOrder(){
			if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			Context::set('yeyak_tpl',$this->module_path."tpl/");
			Context::set('oYeyakModel',$oYeyakModel);
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			Context::set('yeyak_config',$yeyak_config);
			$etc_config=$oYeyakModel->getEtcConfig();
			
			$logged_info = Context::get('logged_info');
			$mem_info=$oYeyakModel->getUinfo($logged_info);
			if($logged_info->member_srl){
				$oPointModel = &getModel('point');
				$etc_config->member_point = $oPointModel->getPoint($logged_info->member_srl);
			
			}else{
				$etc_config->member_point =0;
			}

		
			if(isset($etc_config->yskin['month_limit'])){

			}else{
				$etc_config->yskin['month_limit']="100";
			}
			if($etc_config->yskin['month_limit'] != "" && $etc_config->yskin['month_limit'] != "0"){
			}else{
				$etc_config->yskin['month_limit']="100";
			}
			Context::set('etc_config',$etc_config);

			if($yeyak_config->idx ){
				if($yeyak_config->bday_week_data != "" && $yeyak_config->bday_week_use=='Y'){
					$week_data=$yeyak_config->bday_week_data;
					Context::set('week_data',$week_data);
				}else{
					Context::set('week_data',"");
				}
			}else{
				Context::set('week_data',"");
			}

			$oDB = &DB::getInstance();
			$leftDay = date("YmdHis",strtotime(date("Y-m-d")." -1 days"));
			$sql = "DELETE FROM ".$oDB->prefix."yeyak_res_cart WHERE  regdate <=  ".$leftDay;
			$oDB->_query($sql);

			//getMultiRoomByCate
			$c_args = new stdClass;
			$c_args->sel_cate=$args->sel_cate;
			$c_args->cate_srl=$args->sel_cate;
			$c_args->is_use=0;
			
			$daysToWeek=array('일','월','화','수','목','금','토');
			$wsekDay=date("Y-m-d", strtotime($args->start_date));
			$wsekDayNum = date("w",strtotime($wsekDay));
			$args->start_w=$daysToWeek[$wsekDayNum];
			$args->start_j=$wsekDayNum;

			$output = executeQueryArray('yeyak.getAdminYeyakCateContent',$c_args);
			$output_cate=$oYeyakModel->arrangeDataInfo($output);
			Context::set('cate_info',$output_cate);

			$output_options =  $oYeyakModel->getOptionsList($args);
			Context::set('options_list',$output_options->data);

			if($args->sel_cate == ""){
				$output = executeQueryArray('yeyak.getMultiRoomByNoCate',$c_args);

			}else{
				$output = executeQueryArray('yeyak.getMultiRoomByCate',$c_args);
				
			}
			$seasons_list=$oYeyakAdminModel->getAdminYeyakSeaonsLists();
			 if(count($output->data)){
				
					for($i=0;$i<count($output->data);$i++ ) {

						$leftDay = array();
						for($j=($yeyak_config->min_days-1);$j<$yeyak_config->max_days;$j++){

							$sekDay=date("Y-m-d", strtotime($args->start_date."+".$j."day"));
							$seekArgs=new stdClass;
							$seekArgs->use_date=$sekDay;
							$seekArgs->info_srl=$output->data[$i]->info_srl;

							if(!$oYeyakModel->CheckBday($seekArgs,$yeyak_config)){
								break;
							}

							if($oYeyakModel->getResLogsOneDay($seekArgs)){
								array_push($leftDay,($j+1));
							}else{
								break;
							}
						}
						if( count($leftDay) == 0){ // 상태를 구한다
							$sekDay=date("Y-m-d", strtotime($args->start_date));
							$seekArgs=new stdClass;
							$seekArgs->use_date=$sekDay;
							$seekArgs->info_srl=$output->data[$i]->info_srl;
							$output->data[$i]->status=$oYeyakModel->getResLogsOneDayStatus($seekArgs);
						}else{
							$output->data[$i]->status="";
						}
						$output->data[$i]->leftDay=$leftDay;
						$grm_args=new stdClass;
						if((int)$args->res_length < count($leftDay)){
							$grm_args->stayLength=$args->res_length;
						}else{
							$grm_args->stayLength=count($leftDay);
						}

						if($grm_args->stayLength <= 0){
							$grm_args->stayLength=1;
						}
						$grm_args->start_date=$args->start_date;
						$room_exvar=$oYeyakModel->getRoomMore($yeyak_config,$output->data[$i],$grm_args,$seasons_list,$oYeyakAdminModel->getAdminSeasonsInfo($output->data[$i]));
						$output->data[$i]->days=$room_exvar->ds;
						$output->data[$i]->days_total_amount=$room_exvar->total_amount;
						$output->data[$i]->discount_longday=$room_exvar->discount_longday;
					}
					Context::set('room_list',$output);
			 }
			Context::set('yeyak_info',$args);
			
			Context::set('roomStatus',$resLogByRoomStatus);
			$this->setTemplateFile('multi_order');
		}

		
        function dispYeyakCateList() {
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			$etc_config=$oYeyakModel->getEtcConfig();
			Context::set('etc_config',$etc_config);
			$output=null;
			if($etc_config->yskin['show_empty_cate']=="N"){
				$output = executeQueryArray('yeyak.getYeyakCateList',$args);
			}else{
				$output = executeQueryArray('yeyak.getAdminYeyakCateList',$args);
			}
			$this->add('cate_list',$output->data);
			
			$this->setMessage('success');

		}


		function dispYeyakOrder(){

				if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');

				$daysToWeek=array('일','월','화','수','목','금','토');
				$args = Context::getRequestVars();
				$room_args = new stdClass;
				$room_args->info_srl=$args->sel_room;
		
				if(!$args->sel_room){
					return;
				}

				$oYeyakModel = getModel('yeyak');
				$oYeyakAdminModel = &getAdminModel('yeyak');
				$output =  $oYeyakModel->getRoomContent($room_args);
				$output_room=$oYeyakModel->arrangeDataInfo($output);
			
				
				$info_args= new stdClass;
				$amount = $output_room->amount*$args->res_length;
				$info_args->weekDay = $daysToWeek[date('w', strtotime($args->start_date))];
				$info_args->stayLength =$args->res_length;
				$info_args->info_srl = $args->sel_room;
				$info_args->start_date = $args->start_date;
				$info_args->amount=$amount;
				$info_args->day_num=date('w', strtotime($args->start_date));
				$info_args->sel_cate=$args->sel_cate;

				$info_args->total_amount=0;
				$info_args->room_amount=0;

				$output_options =  $oYeyakModel->getOptionsList($args);
				Context::set('options_list',$output_options->data);
				$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
				
			
				$grm_args=new stdClass;
				$grm_args->stayLength=$info_args->stayLength;
				$grm_args->start_date=$args->start_date;
				$oYeyakAdminModel = &getAdminModel('yeyak');
				
				$room_exvar=$oYeyakModel->getRoomMore($yeyak_config,$output_room,$grm_args,$oYeyakAdminModel->getAdminYeyakSeaonsLists(),$oYeyakAdminModel->getAdminSeasonsInfo($output_room));

				$info_args->total_amount=$room_exvar->total_amount;
				$output_room->discount_longday=$room_exvar->discount_longday;
				$info_args->room_amount=$room_exvar->total_amount;

				$varDays=serialize($room_exvar->ds);
				$etc_config=$oYeyakModel->getEtcConfig();
				$logged_info = Context::get('logged_info');
				$mem_info=$oYeyakModel->getUinfo($logged_info);
				if($logged_info->member_srl){
					$oPointModel = &getModel('point');
				    $etc_config->member_point = $oPointModel->getPoint($logged_info->member_srl);
				
				}else{
					$etc_config->member_point =0;
				}

				if($etc_config->set_point['use'] == "Y"){
					if((int)$etc_config->set_point['use_min_amount'] > (int)$info_args->room_amount){
						$etc_config->set_point['use']="N";
					}
				}

				if(!isset($etc_config->yskin['month_limit'])){
					$etc_config->yskin['month_limit']="100";
				}
				
				if($etc_config->yskin['month_limit'] != "" && $etc_config->yskin['month_limit'] != "0"){
				}else{
					$etc_config->yskin['month_limit']="100";
				}
				
				Context::set('etc_config',$etc_config);

				if($yeyak_config->idx ){
					if($yeyak_config->bday_week_data != "" && $yeyak_config->bday_week_use=='Y'){
						$week_data=$yeyak_config->bday_week_data;
						Context::set('week_data',$week_data);
					}else{
						Context::set('week_data',"");
					}
				}else{
					Context::set('week_data',"");
				}

				Context::set('days',$room_exvar->ds);
				Context::set('varDays',$varDays);
				Context::set('room_info',$output_room);
				Context::set('yeyak_config',$yeyak_config);
				Context::set('yeyak_info',$info_args);
				$url = getUrl('','mid','yeyak');
				Context::set('gurl',$url);
				
		
				$leftDay = array();
				for($i=($yeyak_config->min_days-1);$i<$yeyak_config->max_days;$i++){
					$sekDay=date("Y-m-d", strtotime($args->start_date."+".$i."day"));
					$seekArgs=new stdClass;
					$seekArgs->use_date=$sekDay;
					$seekArgs->info_srl=$info_args->info_srl;
					
					if(!$oYeyakModel->CheckBday($seekArgs,$yeyak_config)){
						break;
					}

					if($oYeyakModel->getResLogsOneDay($seekArgs)){
						array_push($leftDay,($i+1));
					}else{
						break;
					}
				}

				Context::set('leftDay',$leftDay);

				$oDB = &DB::getInstance();
				$dleftDay = date("YmdHis",strtotime(date("Y-m-d")." -1 days"));
				$sql = "DELETE FROM ".$oDB->prefix."yeyak_res_cart WHERE  regdate <=  ".$dleftDay;
				$oDB->_query($sql);

				$this->setMessage('success');
				$this->setTemplateFile('order');
		}

		function dispYeyakPay(){
			if(!$this->grant->access || !$this->grant->view) return $this->dispYeyakMessage('msg_not_permitted');
				$daysToWeek=array('일','월','화','수','목','금','토');
				$args = Context::getRequestVars();
				$oYeyakModel = getModel('yeyak');
				if(!$args->use_point || $args->use_point==""){
					$args->use_point=0;
				}else{
					$args->use_point=str_replace(",","",$args->use_point);
				}
	

				$room_args = new stdClass;
				$room_args->info_srl=$args->info_srl;
				if(!$args->info_srl){
					return;
				}

				$args->end_date = date("Y-m-d", strtotime($args->start_date."+".$args->stayLength."day"));

				$args->weekDay = $daysToWeek[$args->day_num];

				$output =  $oYeyakModel->getRoomContent($room_args);
				$output_room=$oYeyakModel->arrangeDataInfo($output);
				Context::set('room_info',$output_room);
				$output_options =  $oYeyakModel->getOptionsList($args);
				Context::set('options_list',$output_options->data);
				$oYeyakAdminModel = &getAdminModel('yeyak');
				Context::set('yeyak_config',$oYeyakAdminModel->getYeyakConfig());
				
				

				$logged_info = Context::get('logged_info');
				$etc_config=$oYeyakModel->getEtcConfig();
				$mem_info=$oYeyakModel->getUinfo($logged_info);
				if($logged_info->member_srl){
					$oPointModel = &getModel('point');
				    $member_point = $oPointModel->getPoint($member_srl);
				}
				$room_list=array();
				$stl_list=array();
				array_push($room_list,$room_args);
				array_push($stl_list,(int)$args->stayLength);
				$add_point=$oYeyakModel->getSavePoint($logged_info,$room_list,$stl_list,$args->total_amount);
			
				
				Context::set('add_point',$add_point);
				Context::set('nameValue',$mem_info->name);
				Context::set('emailValue',$mem_info->email);
				Context::set('telArray',$mem_info->tel);
				Context::set('etc_config',$etc_config);


				$output = executeQueryArray('yeyak.getPayContent',$args);
				$pay_info=$oYeyakModel->arrangeDataInfo($output);
				Context::set('pay_set',$pay_info);
				$yeyak_path = _XE_PATH_."/modules/yeyak";
				$pg=$oYeyakModel->getPgConfig();
				
				if($pay_info->use_card == "Y" && $pay_info->pg_name == "inicis"){
					require_once('pg/inicis/libs/INIStdPayUtil.php');
					$SignatureUtil = new INIStdPayUtil();
					$pg->timestamp = $SignatureUtil->getTimestamp();
					$pg->orderNumber = $pg->mid . "_" . $pg->timestamp ; // 가맹점 주문번호(가맹점에서 직접 설정)
					$pg->mKey = $SignatureUtil->makeHash($pg->signkey, "sha256");
					$params = array(
					"oid" => $pg->orderNumber,
					"price" => $args->total_amount,
					"timestamp" => $pg->timestamp
					);

					$pg->sign = $SignatureUtil->makeSignature($params, "sha256");
					$pg->skinPath=	$template_path = sprintf("%sskins/%s/",$this->module_path, $this->module_info->skin);

				}


				Context::set('pg',$pg);
				Context::set('yeyak_path',$yeyak_path);
				Context::set('order_info',$args);
				Context::set('order_post',$_POST);




				$this->setMessage('success');
				$this->setTemplateFile('pay');

		}

		function dispYeyakMresult(){
			$args=Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			
			if($args->isinfo == "Y"){
				$output = executeQueryArray('yeyak.getResContentByInfo',$args);
			}else{
				$res_output =  $oYeyakModel->getResContent($args);
				if($res_output->data){
					return $this->dispYeyakResult();
				}else{
					$output = executeQueryArray('yeyak.getResContentByGrp',$args);
				}

			}
			if($output->data){
				Context::set('res_list',$output->data);
			}

			$output = executeQueryArray('yeyak.getPayContent',$args);
			$pay_info=$oYeyakModel->arrangeDataInfo($output);
			Context::set('pay_set',$pay_info);
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			Context::set('yeyak_config',$yeyak_config);
			Context::set('order',$args);

			$this->setTemplateFile('result_mview');
		}

		function dispYeyakResult(){
			$args=Context::getRequestVars();
			Context::set('order',$args);
		
			$oYeyakModel = getModel('yeyak');
	
			if($args->isinfo != "Y"){
				$output =  $oYeyakModel->getResContent($args);	
			}else{
				$args->order_tel = $args->tel1."-".$args->tel2."-".$args->tel3;
				$output =  $oYeyakModel->getResContentByInfo($args);
			}
			$output_Res=$oYeyakModel->arrangeDataInfo($output);
			if(!$output_Res->res_srl){
				$returnUrl =  getNotEncodedUrl('', 'mid', 'yeyak', 'act', 'dispYeyakError','tp','nokeynum');
				$this->setRedirectUrl($returnUrl);
			}else{
				$output = executeQueryArray('yeyak.getPayContent',$args);
				$pay_info=$oYeyakModel->arrangeDataInfo($output);
				Context::set('pay_set',$pay_info);

				Context::set('info',$output_Res);
				Context::set('mypage',$args->mypage);
				$oYeyakAdminModel = &getAdminModel('yeyak');
				$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
				Context::set('yeyak_config',$yeyak_config);

				$this->setMessage('success');
				$this->setTemplateFile('result_view');
			}
		}

		function dispYeyakCancleResult(){
			$args=Context::getRequestVars();
			Context::set('order',$args);
			$oYeyakModel = getModel('yeyak');
	
			if($args->isinfo != "Y"){
				$output =  $oYeyakModel->getResContent($args);	
			}else{
				$args->order_tel = $args->tel1."-".$args->tel2."-".$args->tel3;
				$output =  $oYeyakModel->getResContentByInfo($args);
			}
			$output_Res=$oYeyakModel->arrangeDataInfo($output);

			if(!$output_Res->res_srl){
				$returnUrl =  getNotEncodedUrl('', 'mid', 'yeyak', 'act', 'dispYeyakError','tp','nokeynum');
				$this->setRedirectUrl($returnUrl);
				
			}else{

				if($output_Res->status==2){
					$returnUrl =  getNotEncodedUrl('', 'mid', 'yeyak', 'act', 'dispYeyakError','tp','isExitCancle');
					$this->setRedirectUrl($returnUrl);
				}else{
					$output = executeQueryArray('yeyak.getPayContent',$args);
					$pay_info=$oYeyakModel->arrangeDataInfo($output);
					Context::set('pay_set',$pay_info);

					Context::set('info',$output_Res);
					$oYeyakAdminModel = &getAdminModel('yeyak');
					$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
					Context::set('yeyak_config',$yeyak_config);
					$this->setMessage('success');
					$this->setTemplateFile('cancle_view');
				}
			}
		}

		function dispYeyakGuide(){
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			$etc_config=$oYeyakModel->getEtcConfig();
			Context::set('etc_config',$etc_config);
			Context::set('yeyak_config',$yeyak_config);
			$this->setTemplateFile('guide');
		}

		function dispYeyakCancleForm(){
			$this->setMessage('success');
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			Context::set('yeyak_config',$oYeyakAdminModel->getYeyakConfig());
			$etc_config=$oYeyakModel->getEtcConfig();
			Context::set('etc_config',$etc_config);
			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl){
				$args=new stdClass;
				$args->member_srl = $logged_info->member_srl;
				 $output = executeQueryArray('yeyak.getMemberResedListBySrl',$args);
				 Context::set('res_list',$output->data);
				 					// 템플릿에 전해주기 위해 set함
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

			}
			$this->setTemplateFile('cancle_form');			
		}

		function dispYeyakCheckForm(){
	
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');
			Context::set('yeyak_config',$oYeyakAdminModel->getYeyakConfig());

			$etc_config=$oYeyakModel->getEtcConfig();
			Context::set('etc_config',$etc_config);

			$logged_info = Context::get('logged_info');
			if($logged_info->member_srl){
				$args=new stdClass;
				$args->member_srl = $logged_info->member_srl;
				 $output = executeQueryArray('yeyak.getMemberResedListBySrl',$args);
				 Context::set('res_list',$output->data);

            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('page_navigation', $output->page_navigation);

			}
			$this->setMessage('success');
			$this->setTemplateFile('check_form');			
		}

		function dispResedList(){
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');

			if($args->cate_srl == ""){
				unset($args->cate_srl);
			}

			$args->end_date = date("Y-m-d", strtotime($args->start_date."+".($args->stay_length-1)."day"));
		//	$args->start_date = date("Y-m-d", strtotime($args->start_date."+".($args->stay_length-1)."day"));
			
			
			$args->end_date=str_replace('-','',$args->end_date);
			$args->start_date=str_replace('-','',$args->start_date);

			$output =  $oYeyakModel->getResedList($args);
			if($output->data){
				
				foreach($output->data as $k=>$val){
						$s_args = new stdClass;
						$s_args->keynum=$val->keynum;
						$doutput =  $oYeyakModel->getResedListStatus($s_args);
						if($doutput ){
							$output->data[$k]->status=$doutput->status;
						}
						unset($s_args);
				}
			}
			$this->add('room_list',$output->data);

		
			
			$this->setMessage('success');
		}




		function dispAcRun(){
			$oYeyakModel = getModel('yeyak');
			$oYeyakModel->AcRun('ok');
		}
		
		function dispYeyakError(){
			$args=Context::getRequestVars();
			Context::set('info',$args);

			$this->setMessage('success');
			$this->setTemplateFile('error_view');
		}

		/**
         * @brief 메세지 출력
         **/
        function dispYeyakMessage($msg_code) {
            $msg = Context::getLang($msg_code);
            if(!$msg) $msg = $msg_code;
            Context::set('message', $msg);
            $this->setTemplateFile('message');
        }

		function dispYeyakInicis(){

			$vars = Context::getRequestVars();

			//결제 실패시
			if(strcmp("0000", $vars->resultCode) !== 0)
			{
			
			}

		}


        function dispYeyakRoomList() {
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');

			if($args->cate_srl == ""){
				unset($args->cate_srl);
			}
	
			$output =  $oYeyakModel->getRoomList($args);
			$this->add('room_list',$output->data);

			$seasons=$oYeyakAdminModel->getAdminYeyakSeaonsLists();
			$this->add('seasons',$seasons);
			
			$seasons_info=$oYeyakAdminModel->getAdminSeasonsInfoByCate($args);
			$this->add('seasons_info',$seasons_info);

			if($args->start_date != ""){

				$end_date=date("Y-m-d", strtotime($args->start_date."+10 day"));

				$res_args=new stdClass;
				$res_args->start_date = str_replace("-","",$args->start_date);
				$res_args->end_date =  str_replace("-","",$end_date);

				$output = executeQueryArray('yeyak.getYeyakHdayList',$res_args);
				$resLogByHday=null;
				if(count($output->data)){
					foreach($output->data as $k=>$val) {
							$vas =$val->hday_srl.",".$val->day_color.",".$val->title.",".$val->day_type.",".$val->add_amount;
							$resLogByHday[(string)$val->use_date]= $vas;
					}
				}

				$this->add('hday_list',$output->data);			

			}
			
			$this->setMessage('success');

		}

		function dispYeyakGetConfig(){
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			$this->add('yeyak_config',$yeyak_config);
			$this->setMessage('success');
		}

		function alertMessageBack($message)
		{
		
			$script =  sprintf('<script> jQuery(function(){ alert("%s");history.back();} );</script>', Context::getLang($message));

			Context::addHtmlFooter( $script );
		}
	
		function alertMessageBackGoUrl($message,$gourl)
		{
		
			$script =  sprintf('<script> jQuery(function(){ alert("%s");location.href="%s";} );</script>', Context::getLang($message),$gourl);

			Context::addHtmlFooter( $script );
		}

		function dispYeyakRoomContent() {
			$args = Context::getRequestVars();
			$oYeyakModel = getModel('yeyak');
			$oYeyakAdminModel = &getAdminModel('yeyak');

			$seasons=$oYeyakAdminModel->getAdminYeyakSeaonsLists();
			$this->add('seasons',$seasons);

			$output =  $oYeyakModel->getRoomContent($args);
			$output_room=$oYeyakModel->arrangeDataInfo($output);
			if($args->s_type=="multi"){
				$seasons_info=$oYeyakAdminModel->getAdminSeasonsInfo($output_room);
			}else{
				$seasons_info=$oYeyakAdminModel->getAdminSeasonsInfoByCate($output_room);
			}
			$this->add('seasons_info',$seasons_info);
			
			$args->is_use=0;
            $output = executeQueryArray('yeyak.getYeyakRoomContent',$args);
			$this->add('room_list',$output->data);

			if($args->start_date != ""){

				$end_date=date("Y-m-d", strtotime($args->start_date."+10 day"));

				$res_args=new stdClass;
				$res_args->start_date = str_replace("-","",$args->start_date);
				$res_args->end_date =  str_replace("-","",$end_date);

				$output = executeQueryArray('yeyak.getYeyakHdayList',$res_args);
				$resLogByHday=null;
				if(count($output->data)){
					foreach($output->data as $k=>$val) {
							$vas =$val->hday_srl.",".$val->day_color.",".$val->title.",".$val->day_type;
							$resLogByHday[(string)$val->use_date]= $vas;
					}
				}

				$this->add('hday_list',$output->data);			

			}
			
			$this->setMessage('success');

		}

	

	}
?>