<?php
	@date_default_timezone_set('Asia/Seoul');
    class yeyakModel extends yeyak {
		  /**
         * @brief 초기화
         **/

		var $daysToWeek=array('일','월','화','수','목','금','토','연박할인');

        function init() {
			
        }

		function checkSale($roomData,$as_day,$y,$m,$j){
			$discount_day="no";
			if($roomData->discount_start == '' || $roomData->discount_end == '' ){
				$discount_day="ok";
			}else{
				$discount_ddys=-1;
				$discount_ddye=-1;
				$ad_day=$y."-".$m."-".str_pad($as_day,"2","0",STR_PAD_LEFT);
				$discount_s_date = $roomData->discount_start;
				$discount_e_date = $roomData->discount_end;
				$discount_ddys = ( strtotime($ad_day)  -  strtotime($discount_s_date));
				$discount_ddye = ( strtotime($ad_day)  -  strtotime($discount_e_date));
				if($discount_ddys >= 0 && $discount_ddye<=0){
					$discount_day="ok";
				}
			}

			if($roomData->discount_week != "" && $discount_day=="ok"){
				$discount_week=explode(",",$roomData->discount_week );
				if(in_array((string)$j,$discount_week)){
				$discount_day="ok";
				}else{
				$discount_day="no";
				}
			}

			if($roomData->use_discount == 'Y'  && $discount_day=="ok"){
				return true;
			}else{
				return false;
			}
		}

		function CheckBday($args,$yeyak_config){
			$dArray=explode("-",$args->use_date);
			$seekNoWork=$dArray[1]."-".$dArray[2];
			$yeyak_config->nowork_day=explode(PHP_EOL,$yeyak_config->bday_nowork);
			if(in_array($seekNoWork,$yeyak_config->nowork_day)){
				return false;
			}
			return true;
		}

		function insertYmember($args,$is_add="Y"){
			$in_args=new stdClass;
			$in_args->member_tel=$args->order_tel1."-".$args->order_tel2."-".$args->order_tel3;
			$in_args->member_name=trim($args->order_name);
			$output = executeQueryArray('yeyak.getYeyakMemberByInfo',$in_args);

			if(count($output->data) > 0){
				//회원 정보가 있다면
				$rs=$output->data[0];
				$rs->member_ip=$_SERVER['REMOTE_ADDR'];
				$rs->res_count=$rs->res_count+1;
				if($rs->status == "A"){
					executeQuery('yeyak.updateMemberIp',$rs);// ip 와 res_count 를 업데이트
				}
				return $rs;
			}else{
				if($is_add != "N"){
				$in_args->res_count=1;
				$in_args->status="A";
				$in_args->member_ip=$_SERVER['REMOTE_ADDR'];
				$in_args->reg_date=date("YmdHis");
				$in_args->last_res_date=date("YmdHis");
				$in_args->member_email=trim($args->order_mail);
				executeQuery('yeyak.insertYeyakAdminMember',$in_args);
				$oDB = DB::getInstance();
				$in_args->ymember_srl=$oDB->db_insert_id();
				}else{
					$in_args->status="A";
					$in_args->member_ip=$_SERVER['REMOTE_ADDR'];
				}
				return $in_args;
			}
		}

		function getSavePoint($logged_info,$room_list,$stay_length,$total_amount){
			$etc_config=$this->getEtcConfig();
			$save_point=array();
			$oModuleModel = getModel('module');
			$pointMD_config = $oModuleModel->getModuleConfig('point');
			$save_point_temp=array();
			if($etc_config->set_point['save'] == "Y" && $pointMD_config->able_module=="Y" ){ // 포인트 적립

				$save_point_temp['title']="기본 적립";
				if($etc_config->set_point['save_type'] == "A" ){
					 $save_point_temp['point']=floor($total_amount * $etc_config->set_point['save_point']/100);
					 if( (int)$etc_config->set_point['block'] > 1 ){
						$save_point_temp['point']= floor($save_point_temp['point']/$etc_config->set_point['block']);
					 }
					
				}else if($etc_config->set_point['save_type'] == "B"){
					for($j=0;$j<count($room_list);$j++){
						$room_args=new stdClass;
						$room_args->info_srl=$room_list[$j];
						$output =  $this->getRoomContent($room_args);
						$output_room=$this->arrangeDataInfo($output);
						$save_point_temp['point']=$output_room->add_point*$stay_length[$j];
					}
				}
				
				if($etc_config->set_point['max_save_point'] <  $save_point_temp['point']){
						 $save_point_temp['point']=$etc_config->set_point['max_save_point'];
				}
				
				array_push($save_point,$save_point_temp);
				unset($save_point_temp);
				}
				$save_point_temp=array();

			if($etc_config->set_point['save_reg_use'] == "Y" && $pointMD_config->able_module=="Y"){
				$member_res_count=1;
				if($logged_info->member_srl){
					$mrc_args=new stdClass;
					$mrc_args->member_srl=$logged_info->member_srl;
					$mrc_args->status="0,1";
					$mrc_output = executeQueryArray('yeyak.getMemberResedCountBySrl',$mrc_args);
					$mrc_result=$this->arrangeDataInfo($mrc_output);
					$member_res_count=$member_res_count+$mrc_result->cnt;
					
				}

				$sru_cnt=explode(",",$etc_config->set_point['save_reg_count']);
				$sru_point=explode(",",$etc_config->set_point['save_reg_point']);
				for($i=0;$i<count($sru_cnt);$i++){
					if($member_res_count == (int)$sru_cnt[$i]){
						$reptitle=$sru_cnt[$i];
						if($sru_cnt[$i]=="1"){
							$reptitle="첫";
						}else{
							$reptitle=$sru_cnt[$i]."번째";
						}
						$save_point_temp['title']=$reptitle." 예약";
						$save_point_temp['point']=$sru_point[$i];
						array_push($save_point,$save_point_temp);
						unset($save_point_temp);
						break;
					}
				}
			}
			return $save_point;
		}

		function getSmsMsgConfig(){
			$output = executeQueryArray('yeyak.getSmsContent',$sms_info_args);
			$sms_info=$this->arrangeDataInfo($output);

			if($sms_info->sms_var3==""){$sms_info->sms_var3="0830,1230,1530,";}
			if($sms_info->sms_var2==""){$sms_info->sms_var2="N";	}

			$smva3=explode(",",$sms_info->sms_var3);
			$sms_info->use_kakao=$sms_info->sms_var2;
			$sms_info->amTime=$smva3[0];
			$sms_info->outTime=$smva3[1];
			$sms_info->byeTime=$smva3[2];
			$sms_info->kakao_sender_key=$smva3[3];
			if($sms_info->sms_var4==""){
				$sms_info->sms_var4="[업체명] 예약 안내\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명] [인원]명\n[계좌번호]([비용]원)";
			}
			if($sms_info->sms_var5==""){
				$sms_info->sms_var5="([결제유형])\n[분류명]-[객실명] [인원]명\n[예약일] [예약기간]";
			}

			if($sms_info->sms_var6==""){
				$sms_info->sms_var6="[업체명] 예약 완료\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명] [인원]";
			}
			if($sms_info->sms_var7==""){
				$sms_info->sms_var7="([결제유형])\n[분류명]-[객실명] [인원]명\n[예약일] [예약기간]";
			}

			if($sms_info->sms_var8==""){
				$sms_info->sms_var8="[업체명] 예약 완료\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명]\n예약 완료 되었습니다.";
			}

			if($sms_info->sms_var9==""){
				$sms_info->sms_var9="[업체명] 예약 안내\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명]\n취소 대기 상태로 변경 되었습니다.";
			}

			if($sms_info->sms_var10==""){
				$sms_info->sms_var10="[업체명] 예약 취소 안내\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명]\n취소 되었습니다.";
			}

			if($sms_info->sms_var11==""){
				$sms_info->sms_var11="[업체명] 체크인 안내\n[예약자명]님 오늘은 [예약기간] 일정으로 방문 예정이십니다.\n[분류명]-[객실명]은 [입실시간]이후 체크인 가능합니다.\n즐거운 여행길 되길 바라겠습니다.\n문의전화 [업체연락처]";
			}

			if($sms_info->sms_var12==""){
				$sms_info->sms_var12="[업체명] 체크아웃 안내\n오늘은 [예약기간]일정의 마지막날 입니다.\n[퇴실시간]이전에 체크아웃을 부탁 드립니다.\n문의전화 [업체연락처]";
			}

			if($sms_info->sms_var13==""){
				$sms_info->sms_var13="[예약자명]님 [업체명]을 이용해 주셔서 진심으로 감사드립니다.\n집으로 돌아 가는길이 안전하고 편안하길 바라겠습니다.\n즐거운 추억 편안한 휴식 제공을 위해 더욱 노력하겠습니다.";
			}

			if($sms_info->sms_var14==""){
				$sms_info->sms_var14="사용자 취소-[예약상태]\n예약번호 [예약번호]\n[예약일] [예약기간]\n[분류명]-[객실명]\n[결제유형]";
			}

			if($sms_info->sms_var20==""){
				$sms_info->sms_var20="A01|@|[예약자명]님 [업체명]입니다.\n[예약일2] [예약기간] 예약 하셨습니다.\n예약번호는 [예약번호]입니다.\n감사합니다.";
			}

			if($sms_info->sms_var21==""){
				$sms_info->sms_var21="A02|@|[예약자명]님 [업체명]입니다.\n[예약일2]([예약기간]) [분류명]-[객실명]의 예약이 완료되었습니다.\n예약번호는 [예약번호] 입니다.\n감사합니다.";
			}

			if($sms_info->sms_var22==""){
				$sms_info->sms_var22="A03|@|[예약자명]님 [업체명]입니다.\n[예약일2]([예약기간]) [분류명]-[객실명]의 예약 상태가 [예약상태]로 변경 되었습니다.\n예약번호는 [예약번호] 입니다.";
			}

			if($sms_info->sms_var23==""){
				$sms_info->sms_var23="A04|@|[예약자명]님 [업체명]입니다.\n[예약자명]님 예약하신 [분류명]-[객실명]의 예약이 취소 되었습니다.";
			}

			if($sms_info->sms_var24==""){
				$sms_info->sms_var24="A05|@|[업체명] 체크인 안내\n[예약자명]님 오늘은 [예약기간] 일정으로 방문 예정이십니다.\n[분류명]-[객실명]은 [입실시간]이후 체크인 가능합니다.\n즐거운 여행길 되길 바라겠습니다.";
			}

			if($sms_info->sms_var25==""){
				$sms_info->sms_var25="A06|@|[업체명] 체크아웃 안내\n[예약자명]님 오늘은 [예약기간]일정의 마지막날 입니다.\n[퇴실시간]이전에 체크아웃을 부탁 드립니다.";
			}
			if($sms_info->sms_var26==""){
				$sms_info->sms_var26="A07|@|[예약자명]님 [업체명]을 이용해 주셔서 진심으로 감사드립니다.\n집으로 돌아 가는길이 안전하고 편안하길 바라겠습니다.\n즐거운 추억 편안한 휴식 제공을 위해 더욱 노력하겠습니다.";
			}

			$exp20=explode("|@|",$sms_info->sms_var20);
			$exp21=explode("|@|",$sms_info->sms_var21);
			$exp22=explode("|@|",$sms_info->sms_var22);
			$exp23=explode("|@|",$sms_info->sms_var23);
			$exp24=explode("|@|",$sms_info->sms_var24);
			$exp25=explode("|@|",$sms_info->sms_var25);
			$exp26=explode("|@|",$sms_info->sms_var26);

			$sms_info->kakao_wait_code=$exp20[0];
			$sms_info->kakao_wait_msg=$exp20[1];

			$sms_info->kakao_comp_code=$exp21[0];
			$sms_info->kakao_comp_msg=$exp21[1];

			$sms_info->kakao_status_code=$exp22[0];
			$sms_info->kakao_status_msg=$exp22[1];

			$sms_info->kakao_cancle_code=$exp23[0];
			$sms_info->kakao_cancle_msg=$exp23[1];

			$sms_info->kakao_welcome_code=$exp24[0];
			$sms_info->kakao_welcome_msg=$exp24[1];

			$sms_info->kakao_out_code=$exp25[0];
			$sms_info->kakao_out_msg=$exp25[1];

			$sms_info->kakao_bye_code=$exp26[0];
			$sms_info->kakao_bye_msg=$exp26[1];


			$sms_info->status_wait_user=$sms_info->sms_var4;
			$sms_info->status_wait_admin=$sms_info->sms_var5;
			$sms_info->status_comp_user=$sms_info->sms_var6;
			$sms_info->status_comp_admin=$sms_info->sms_var7;
			$sms_info->status_comp_change=$sms_info->sms_var8;
			$sms_info->status_cancle_wait=$sms_info->sms_var9;
			$sms_info->status_cancle_comp=$sms_info->sms_var10;
			$sms_info->status_welcome=$sms_info->sms_var11;
			$sms_info->status_out=$sms_info->sms_var12;
			$sms_info->status_bye=$sms_info->sms_var13;
			$sms_info->status_cancle_user=$sms_info->sms_var14;

			$varArray1=array("업체명","예약자명","예약번호","예약일","예약일2","예약기간","분류명","객실명","인원","계좌번호","비용","업체연락처","입실시간","퇴실시간","결제유형","예약상태");
			$varArray2=array("기본설정->업체명","예약자명","예약번호","체크인 날짜 - 예)2017/01/11","예)2017년 01월 11일","예)1박2일","분류명","객실명","기본인원+추가인원","결제->계좌번호","총 결제 금액","기본설정->운영정보->문의 전화","기본설정->운영정보->입실시간","기본설정->운영정보->퇴실시간","결제유형","결제대기,예약완료,취소대기,취소");

			$sms_info->va=$varArray1;
			$sms_info->va_guide=$varArray2;

			return $sms_info;
		}


		function getUinfo($logged_info){

			$telArray=array("","","");
			$emailValue="";
			$nameValue="";
			if($logged_info->member_srl){
			$oMemberModel = &getModel('member');
					$site_module_info = Context::get('site_module_info');
					$member_srl = $logged_info->member_srl;
					$member_config = $oMemberModel->getMemberConfig();
					$oMemberView = &getView('member');
			 
					$columnList = array('member_srl', 'user_id', 'email_address', 'user_name', 'nick_name', 'homepage', 'blog', 'birthday', 'regdate', 'last_login', 'extra_vars');
					$member_info = $oMemberModel->getMemberInfoByMemberSrl($member_srl, $site_module_info->site_srl, $columnList);

					$extendForm = $oMemberModel->getCombineJoinForm($member_info);
					unset($extendForm->find_member_account);
					unset($extendForm->find_member_answer);
			 
					$_member_info = $oMemberView->_getDisplayedMemberInfo($member_info, $extendForm, $member_config);
					for($i=0;$i<count($_member_info);$i++){
						if($_member_info[$i]->name == "tel"){
							$telArray = explode("-",$_member_info[$i]->value); 
						}

						if($_member_info[$i]->name == "email_address"){
							$emailValue=$_member_info[$i]->value;
						}
						
						if($_member_info[$i]->name == "user_name"){
							$nameValue=$_member_info[$i]->value;
						}
						if($nameValue== "" && $_member_info[$i]->name == "nick_name"){
							$nameValue=$_member_info[$i]->value;
						}
					}

					$meminfo = new stdClass;
					$meminfo->tel=$telArray;
					$meminfo->email=$emailValue;
					$meminfo->name=$nameValue;
			}
					return $meminfo;
		}

		
		function getKaKaoTmpl($msg){
			$rtmsg=$msg;
			$rtmsg=str_replace("[업체명]","#{업체명}",$rtmsg);
			$rtmsg=str_replace("[예약자명]","#{홍길동}",$rtmsg);
			$rtmsg=str_replace("[예약기간]","#{1박2일}",$rtmsg);
			$rtmsg=str_replace("[예약일2]","#{2017년 01월 02일}",$rtmsg);
			$rtmsg=str_replace("[예약일]","#{2017-01-02}",$rtmsg);
			$rtmsg=str_replace("[예약일]","#{2017-01-02}",$rtmsg);
			$rtmsg=str_replace("[분류명]-[객실명]","#{1층-객실명}",$rtmsg);
			$rtmsg=str_replace("[분류명]","#{1층}",$rtmsg);
			$rtmsg=str_replace("[객실명]","#{객실명}",$rtmsg);
			$rtmsg=str_replace("[예약번호]","#{ABCDEF01}",$rtmsg);
			$rtmsg=str_replace("[입실시간]","#{12시}",$rtmsg);
			$rtmsg=str_replace("[퇴실시간]","#{15시}",$rtmsg);
			return $rtmsg;
		}

		function getRoomMore($yeyak_config,$output_room,$args,$seasons,$seasons_data){
				$oYeyakModel = getModel('yeyak');
				$sLen = (int)$args->stayLength;
				$ds=array();
				for($i=0;$i<$sLen;$i++){
					$sekDay=date("Y-m-d", strtotime($args->start_date."+".$i."day"));
					$sekDayNum = date("w",strtotime($sekDay));
					$sekYear=date("Y", strtotime($args->start_date."+".$i."day"));
					$upType="0";
					$upPer=0;
					$upAmount=0;
					$upDay="0";
					$upDesc="";
					$totalAmount=(int)$output_room->amount;
					$upDescA=array();
					$upAmtA=array();
					$hArgs= new stdClass;
					$hArgs->use_date=str_replace("-","",$sekDay);
					$hday_info=$oYeyakModel->getYeyakHdayContent($hArgs);
					$isSeason="N";
					$add_longday_price=0;
					foreach($seasons->data as $no=>$val) {
							if($val->is_use == "Y"){
							$ddys=-1;
							$ddye=-1;
							$s_date = $val->start_date;
							$as_day=$sekDay;
							$e_date = $val->end_date;
							$ddys = ( strtotime($as_day)  -  strtotime($s_date));
							$ddye = ( strtotime($as_day)  -  strtotime($e_date));
							if($ddys >= 0 && $ddye<=0){
								$sdata = new stdClass;
								$sdata->seasons_type="Z";
								foreach($seasons_data->data as $k=>$sinfo){
									if($sinfo->seasons_srl == $val->seasons_srl){
										$sdata=$this->objectToArray($sinfo);
										break;
									}
								}

								$daySek="day".$sekDayNum;
								$upType=$sekDayNum;
								$upDesc=$val->s_title;

								if($sdata->seasons_type != "Z"){
									$upAmount=$sdata[$daySek];
									$add_longday_price=$sdata['longDayAmount'];
								}else{
									$upAmount=0;
								}
								array_push($upDescA,$upDesc);
								array_push($upAmtA,$upAmount);
								$totalAmount=$totalAmount+(int)$upAmount;

								$isSeason="Y";
								break;
							}
						}//sungsu end if
					}//sungsu end for

					if($isSeason == "N"){ //no season start
						$sdata = new stdClass;
						$sdata->seasons_type="Z";
						foreach($seasons_data->data as $k=>$sinfo){
							if($sinfo->seasons_type == 'X'){
								$sdata=$this->objectToArray($sinfo);
								break;
							}
						}
						
						if($sdata->seasons_type != "Z"){
							$daySek="day".$sekDayNum;
							$upAmount=$sdata[$daySek];
							if($upAmount != "0"){
								$upType=$sekDayNum;
								$upDesc=$this->daysToWeek[$sekDayNum]."요일";
								$add_longday_price=$sdata['longDayAmount'];
								array_push($upDescA,$upDesc);
								array_push($upAmtA,$upAmount);
								$totalAmount=$totalAmount+(int)$upAmount;
							}
						}
					} //no season end

					if($hday_info->hday_srl && $hday_info->day_type=="dic"){
						if($hday_info->add_amount != "0"){
							$upType="5";
							$upDesc=$hday_info->title;
							array_push($upDescA,$upDesc);
							$upAmount=$hday_info->add_amount;
							array_push($upAmtA,$upAmount);
							$totalAmount=$totalAmount+(int)$upAmount;
						}
					}
					if($output_room->use_discount == 'Y'){
						$discount_day="no";
						if($output_room->discount_start == '' || $output_room->discount_end == '' ){
							$discount_day="ok";
						}else{
							$ddys=-1;
							$ddye=-1;
							$s_date = $output_room->discount_start;
							$as_day=$sekDay;
							$e_date = $output_room->discount_end;
							$ddys = ( strtotime($as_day)  -  strtotime($s_date));
							$ddye = ( strtotime($as_day)  -  strtotime($e_date));
							if($ddys >= 0 && $ddye<=0){
								$discount_day="ok";
							}
						}

						if($output_room->discount_week != ""){
							$discount_week=explode(",",$output_room->discount_week );
							if(in_array((string)$sekDayNum,$discount_week)){
								$discount_day="ok";
							}else{
								$discount_day="no";
							}
						}

						if($discount_day=="ok"){
							$upType="discount";
							$upDesc=$output_room->discount_name;
							if($upDesc != ""){
							$upDesc=str_replace(':','',$output_room->discount_name);
							}
							array_push($upDescA,$upDesc);
							$upAmount=(int)$output_room->discount_amount;
							array_push($upAmtA,$upAmount);
							$totalAmount=(int)$totalAmount+(int)$upAmount;
						}

					}

					$rsR = array(
						'day'=>$sekDay,
						'dayNum'=>$sekDayNum,
						'upType'=>$upType,
						'upPer'=>$upPer,
						'upAmount'=>$upAmount,
						'upDay'=>$upType,
						'upDesc'=>$upDesc,
						'upDescA'=>$upDescA,
						'upAmtA'=>$upAmtA,
						'totalAmount'=>$totalAmount
					);
					$ds[$i]=$rsR;
					$args->total_amount=$args->total_amount+$totalAmount;
					
				}//end for length day
				
				$room_exvar=new stdClass;
				$room_exvar->discount_longday=0;
				$longday_price=(int)$output_room->longday_price+(int)$add_longday_price;
				if($sLen > 1){
					if($longday_price != "0"){
						$long_discount = $longday_price  * ($sLen - 1);
						$args->total_amount =$args->total_amount + $long_discount;
						$room_exvar->discount_longday=$long_discount ;
					}
					
				}
				$room_exvar->ds=$ds;
				$room_exvar->total_amount=$args->total_amount;
				return $room_exvar;
		}

		function getYeyakHdayContent($args){
            $output = executeQueryArray('yeyak.getYeyakHdayContent',$args);
			$output = $this->arrangeDataInfo($output);
			return $output;
		}
		
		function getOneDayUse($args){
		}


		function getEtcConfig(){
			$output = executeQueryArray('yeyak.getEtcContent',$args);
			$output = $this->arrangeDataInfo($output);
			if($output->yskin==""){
				$output->yskin=array();
				$output->yskin['use_multi']="N";
				$output->yskin['title_length']="12";
				$output->yskin['month_limit']="0";
				$output->yskin['use_scroll']="N";
				$output->yskin['scroll_height']="400";
				$output->yskin['show_empty_cate']="N";
				$output->yskin['show_subadmin']="N";
				$output->yskin['subadmin_menu']="예약관리";
				$output->yskin['show_addamount']="A";
				$output->yskin['show_addamountlist']="Y";
			}else{
				 $output->yskin=unserialize($output->yskin);
				 if($output->yskin['title_length'] == "" || !$output->yskin['title_length']){
					$output->yskin['title_length']="12";
				}
				if($output->yskin['month_limit'] == "" || !$output->yskin['month_limit']){
					$output->yskin['month_limit']="0";
				}

				if($output->yskin['use_scroll'] == "" || !$output->yskin['use_scroll']){
					$output->yskin['use_scroll']="N";
					$output->yskin['scroll_height']="400";
					$output->yskin['show_empty_cate']="N";
				}

				if($output->yskin['show_subadmin']=="" || !$output->yskin['show_subadmin']){
					$output->yskin['show_subadmin']="N";
					$output->yskin['subadmin_menu']="예약관리";
				}

				if($output->yskin['show_addamount']=="" || !$output->yskin['show_addamount']){
					$output->yskin['show_addamount']="A";
					$output->yskin['show_addamountlist']="Y";
				}
			}

			if($output->ac_manner_alert==""){
				$output->ac_manner=array();
				$output->ac_manner['use']="N";
				$output->ac_manner['start_time']='22:00';
				$output->ac_manner['end_time']='08:00';
			}else{
				$output->ac_manner=unserialize($output->ac_manner_alert);
			}

			if($output->set_point=="" || isset($output->set_point) === false ){
				$output->set_point=array();
				$output->set_point['block']="1"; // 1포인트당 단위
				$output->set_point['use']="N"; //사용여부
				$output->set_point['use_range_start']="5";//최소 범위
				$output->set_point['use_range_end']="20";//최대 범위
				$output->set_point['use_min_amount']="50000";//포인트 사용 가능한 최소 금액 (객실 기준)
				$output->set_point['use_max_amount']="500000";//포인트 사용 가능한 최대 금액 (객실 기준) - 미적용
				$output->set_point['use_groups']=""; //사용 가능한 그룹
				$output->set_point['use_guide']=""; //설명
				$output->set_point['use_login_disp']="Y"; // 회원 가입 유도
				$output->set_point['use_order']="A";// A 포인트 만 사용,B 포인트+쿠폰 동시

				$output->set_point['save']="N";//포인트 적립 사용
				$output->set_point['save_type']="A"; // A 결제금액 ,B 객실
				$output->set_point['save_order']="A";// A 쿠폰 사용시 적립 , B 쿠폰 사용시 미 적립
				$output->set_point['save_point']="5";// 그룹별
				$output->set_point['max_save_point']="100000"; // 1회 적립 가능한 최대 포인트 0 무제한
				$output->set_point['save_reg_use']="N"; //예약 횟수에 따른 포인트 지급
				$output->set_point['save_reg_count']="1,3,5"; 
				$output->set_point['save_reg_point']="5000,10000,18000"; 
			}else{
				$output->set_point=unserialize($output->set_point);
			}


			if(trim($output->skin_guide) == "" || isset($output->skin_guide) === false){
					$admin_url=getUrl('','module','admin','act','dispYeyakAdminSeasons');
					$admin_url2=getUrl('','module','admin','act','dispYeyakAdminEtc');
					$output->skin_guide="<table border=0  cellpadding=0 cellspacing=0  class='ct-table' >
					<caption>이용 안내</caption>
					<tr>
					<th >할증</th><td> <b>금,토</b></td>
					</tr>
					<tr>
					<th>인원</th><td> <b>만5세 이상 1인 추가</b></td>
					</tr>
					<tr>
					<th>여름 성수기</th><td><a href='".$admin_url."' target='_blank'>성수기 설정</a></td>
					</tr>
					<tr>
					<th>봄 성수기</th><td>미설정</td>
					</tr>
					<tr>
					<th>공지 메세지</th><td><a href='".$admin_url2."' target='_blank'>메세지 설정</a></td>
					</tr>
					</table>";
			}

			return $output;
		}

		function getCateList($args){
			
            $output = executeQueryArray('yeyak.getAdminYeyakCateList',$args);
			return $output;
		}



		function getRoomList($args){
	        $args->is_use=0;
            $output = executeQueryArray('yeyak.getYeyakRoomList',$args);
			return $output;
		
		}

		function clearOldRes(){
			
		}


		function getRoomContent($args){
   
            $output = executeQueryArray('yeyak.getAdminYeyakRoomContent',$args);
			return $output;
		
		}

		function getOptionsList($args){
        
            $output = executeQueryArray('yeyak.getAdminYeyakOptionsList',$args);
			return $output;
		
		}

		function getPgConfig(){

			$output = executeQueryArray('yeyak.getPayContent',$args);
			$pay_info=$this->arrangeDataInfo($output);
			$oYeyakAdminModel = &getAdminModel('yeyak');
			$yeyak_config=$oYeyakAdminModel->getYeyakConfig();
			$pg=new stdClass;
			return $pg;
		}


		function getResContent($args){
        
            $output = executeQueryArray('yeyak.getResContent',$args);
			return $output;
		
		}

		function getResContentByInfo($args){
        
            $output = executeQueryArray('yeyak.getResContentByInfo',$args);
			return $output;
		
		}

		function getYeyakSmsConfig(){
				$output = executeQuery("yeyak.getSmsContent", $args);
			//	$output=$this->arrangeDataInfo($output);
				return $output;
		}

		function getResLogs($args){
				$count = (int)$args->stay_length;
				for($i=0;$i<$count;$i++){
					$log_args=null;
					$log_args=new stdClass;
					$log_args->info_srl=$args->info_srl; 
					$log_args->status="0,1,2";
					$log_args->use_date = date("Y-m-d", strtotime($args->use_date."+".$i."day"));
					$log_args->use_date=str_replace('-','',$log_args->use_date);

					$output = executeQuery("yeyak.getResLog", $log_args);
	
				
			
				
					if($output->data->date_count != 0){
						return false;

					}
				}
			
				return true;

		}

		function getResLogsOneDay($args){		
					$log_args=null;
					$log_args=new stdClass;
					$log_args->info_srl=$args->info_srl; 
					$log_args->use_date=str_replace('-','',$args->use_date);
					$log_args->status="0,1,2";
					$output = executeQuery("yeyak.getResLog", $log_args);
					if($output->data->date_count > 0){
						return false;

					}
				return true;
		}

		function getResLogsOneDayStatus($args){		
					$log_args=null;
					$log_args=new stdClass;
					$log_args->info_srl=$args->info_srl; 
					$log_args->use_date=str_replace('-','',$args->use_date);
					$log_args->status="0,1,2";
					$output = executeQuery("yeyak.getResOneDayStatus", $log_args);
				
				return $output->data->status;
		}

		function getResLogsOneDayM($args){		
					$log_args=null;
					$log_args=new stdClass;
					$log_args->info_srl=$args->info_srl; 
					$log_args->use_date=str_replace('-','',$args->use_date);
					$log_args->status="0,1,2";
					$output = executeQuery("yeyak.getResLogM", $log_args);
					$rt_args=new stdClass;
					$rt_args->is_ok=true;
					if($output->data->date_count != 0){
						$rt_args->is_ok=false;

					}
					$rt_args->status=$output->data->status;

				
					
				return $rt_args;
		}

		function getResedList($args){
			$args->status="0,1,2";
            $output = executeQueryArray('yeyak.getResedList',$args);
			return $output;
		}

		function getResedListStatus($args){
			$args->status="0,1,2";
            $output = executeQueryArray('yeyak.getResedListStatus',$args);
			return $this->arrangeDataInfo($output);
		}

		function getMemberResedList($args){
			$args->status="0,1,2";
            $output = executeQueryArray('yeyak.getMemberResedList',$args);
			return $output;
		}

		function acMsg($send_msg,$val,$cf1,$cf2,$cf3){
			return $send_msg;
		}


		function acSendEmail($title,$msg,$val,$cf1){

		}

		function acSendSms($title,$msg,$val,$cf1,$sms_config){


		}

		function AcRun($daemon='ok'){
			if($daemon=='ok'){
				exit;
			}
		}

        function arrangeDataInfo($output) {
			if($output->data) {
				foreach($output->data as $k=>$val) {
					$res=$val;
				}
				return $res;
			}
		}

	function objectToArray($data)
	{
		if (is_object($data)) {
			$data = get_object_vars($data);
		}

		if (is_array($data)) {
			return array_map(array($this, 'objectToArray'), $data);
		}

		return $data;
	}
 
	}
?>