jQuery(function($) {
	"use strict";
	// hide last tag
	$('.read_footer .tags span:last-child').hide();
	// user input text blur/focus/change
	var iText = $('.item .iLabel').next('.iText');
	$('.item .iLabel').css('position','absolute');
	iText
		.focus(function() {
			$(this).prev('.iLabel').css('visibility','hidden');
		})
		.blur(function() {
			if(!$(this).val()) {
				$(this).prev('.iLabel').css('visibility','visible');
			} else {
				$(this).prev('.iLabel').css('visibility','hidden');
			}
		})
		.change(function() {
			if(!$(this).val()) {
				$(this).prev('.iLabel').css('visibility','visible');
			} else {
				$(this).prev('.iLabel').css('visibility','hidden');
			}
		})
		.blur();
	// add class to the parent category 
	$('.cTab>li>ul>li.on_').parents('li:first').addClass('on');
	// delete the margin-top for the first child of the ccomments
	$('.feedback .xe_content>*:first-child').css('margin-top','0');
});

// SNS post
(function($) {
	"use strict";
	$.fn.snspost = function(opts) {
		var loc = '';
		opts = $.extend({}, {type:'twitter', event:'click', content:''}, opts);
		opts.content = encodeURIComponent(opts.content);
		switch(opts.type) {
			case 'facebook':
				loc = 'http://www.facebook.com/share.php?t='+opts.content+'&u='+encodeURIComponent(opts.url||location.href);
				break;
			case 'delicious':
				loc = 'http://www.delicious.com/save?v=5&noui&jump=close&url='+encodeURIComponent(opts.url||location.href)+'&title='+opts.content;
				break;
			case 'twitter':
				loc = 'http://twitter.com/home?status='+opts.content;
				break;
			case 'google' :
				loc = 'http://plus.google.com/share?url='+encodeURIComponent(opts.url||location.href)+'?l=ko='+opts.content;
				break;
		}
		this.bind(opts.event, function() {
			window.open(loc);
			return false;
		});
	};
	$.snspost = function(selectors, action) {
		$.each(selectors, function(key,val) {
			$(val).snspost( $.extend({}, action, {type:key}) );
		});
	};
})(jQuery);

jQuery(function($) {
    
    // 게시판 글등록 시 비로그인 상황에 노출 되는 닉네임, 비밀번호, 이메일, 홈페이지 영역  
	$('.write_author .cmt_user_form input').focus(function(){
        $(this).prev().find('i').addClass('input_focused');
    });
    $('.write_author .cmt_user_form input').focusout(function(){
        $(this).prev().find('i').removeClass('input_focused');
    });
    
    // 게시판 상세페이지 좌,우 화살표 인터렉션  
    $('.board .btn_page').hover(
        function() {
            $(this).find('.panel').show();
            $(this).stop().animate({
                width: "200"
            }, 200);
        }, function() {
            $(this).find('.panel').hide();
            $(this).stop().animate({
                width: "50"
            }, 100);
        }
    );
    
    // 게시판 상세페이지 좌,우 화살표 위치
    var bdwindowWidth = $(window).width();
    bdPageArrowCheck(bdwindowWidth);
    $( window ).resize(function() {
        bdwindowWidth = $(window).width();
        bdPageArrowCheck(bdwindowWidth);
    });
    
    function bdPageArrowCheck(pBdwindowWidth){
        if(pBdwindowWidth < 1260) {
            $('.board_read .btn_page.prev_page').css('left',0);
            $('.board_read .btn_page.next_page').css('right',0);
        } else {
            $('.board_read .btn_page.prev_page').css('left','-80px');
            $('.board_read .btn_page.next_page').css('right','-80px');
        }
    }
    
    // 게시판 상세 페이지 좌우, 화살표 Top 위치
    $(window).scroll(function() {
        var bdScroll = bdGetCurrentScroll();
        if( bdScroll >= 300 ) {
           //$containerEl.addClass('fixed_header');
            $('.board_read .btn_page').css('top',bdScroll + 70);    
        }
    });
    
    function bdGetCurrentScroll() {
        return window.pageYOffset || document.documentElement.scrollTop;
    }
    
    // 툴팁
    $('.tooltip_wrap').hide();
    $('.tooltip').hover(
        function(){
            var tooltip = $(this);
            tooltip.find('.tooltip_wrap:hidden').css('bottom','150%').animate({bottom:'100%'},{duration:150,specialEasing:{left:'easeInOutQuad'},complete:function(){},step:null,queue:false}).fadeIn(150)
        },
        function(){
            $(this).find('.tooltip_wrap').fadeOut(100)
        }
    )
    // 모든 페이지
    $('.more_page .page_box').hide();
    $('.more_page .tooltip').click(function(){
        $(this).next('.page_box').toggle();
        return false;
    });
    
});
