<?php
    /**
     * @class  laweb_xeAdminView
     * @author XE스쿨 북마크 모듈 만들기 예제를 편집함
     * @brief  laweb_xe 모듈의 admin view class
     **/

    class laweb_xeAdminView extends laweb_xe {

        /**
         * @brief 초기화
         **/
        function init() {

            // module_srl이 있으면 미리 체크하여 존재하는 모듈이면 module_info 세팅
            $module_srl = Context::get('module_srl');
            if(!$module_srl && $this->module_srl) {
                $module_srl = $this->module_srl;
                Context::set('module_srl', $module_srl);
            }

            // module model 객체 생성 
            $oModuleModel = &getModel('module');

            // module_srl이 넘어오면 해당 모듈의 정보를 미리 구해 놓음
            if($module_srl) {
                $module_info = $oModuleModel->getModuleInfoByModuleSrl($module_srl);
                if(!$module_info) {
                    Context::set('module_srl','');
                    $this->act = 'list';
                } else {
                    ModuleModel::syncModuleToSite($module_info);
                    $this->module_info = $module_info;
					$this->module_info->use_status = explode('|@|', $module_info->use_status);
                    Context::set('module_info',$module_info);
                }
            }

            if($module_info && $module_info->module != 'laweb_xe') return $this->stop("msg_invalid_request");

            // 모듈 카테고리 목록을 구함
            $module_category = $oModuleModel->getModuleCategories();
            Context::set('module_category', $module_category);

			// 관리자 템플릿 파일의 경로 설정 (tpl)
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
		}

        /**
         * @brief 관리자 목록 
         **/
		function dispLaweb_xeAdminList() {

			// 페이지 네비게이션을 위한 설정
            $page = Context::get('page');
            if(!$page) $page = 1;
			$args->page = $page;

			// Model 파일을 이용하지 않고 직접 쿼리로 목록을 구함
			$output = executeQueryArray('laweb_xe.getLaweb_xeAdminList', $args);
            ModuleModel::syncModuleToSite($output->data);

			// 템플릿에 전해주기 위해 set함
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
			Context::set('laweb_xe_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

			// 관리자 목록 보기 템플릿 지정(tpl/index.html)
            $this->setTemplateFile('index');
		}

        /**
         * @brief 모듈(mid) insert/update 화면 출력
         **/
		function dispLaweb_xeAdminInsert() {

			if(!in_array($this->module_info->module, array('admin', 'laweb_xe'))) {
                return $this->alertMessage('msg_invalid_request');
            }

            // 스킨 목록을 구해옴
            $oModuleModel = &getModel('module');
            $skin_list = $oModuleModel->getSkins($this->module_path);
            Context::set('skin_list',$skin_list);

            // 레이아웃 목록을 구해옴
            $oLayoutModel = &getModel('layout');
            $layout_list = $oLayoutModel->getLayoutList();
            Context::set('layout_list', $layout_list);

            // 템플릿 파일 지정
            $this->setTemplateFile('admin_insert');
		}

        /**
         * @brief 선택된 모듈의 정보 출력은 곧바로 정보 입력으로 변경한다
         **/
        function dispLaweb_xeAdminInfo() {
            $this->dispLaweb_xeAdminInsert();
        }

        /**
         * @brief 권한 목록 출력
         **/
        function dispLaweb_xeAdminGrantInfo() {

            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $grant_content = $oModuleAdminModel->getModuleGrantHTML($this->module_info->module_srl, $this->xml_info->grant);
            Context::set('grant_content', $grant_content);

            $this->setTemplateFile('grant_list');
        }

        /**
         * @brief 스킨 정보 보여줌
         **/
        function dispLaweb_xeAdminSkinInfo() {
            // 공통 모듈 권한 설정 페이지 호출
            $oModuleAdminModel = &getAdminModel('module');
            $skin_content = $oModuleAdminModel->getModuleSkinHTML($this->module_info->module_srl);
            Context::set('skin_content', $skin_content);

            $this->setTemplateFile('skin_info');
        }
	}
?>
